/*
 * Decompiled with CFR 0.152.
 */
package io.github.blanketmc.blanket.config.screen;

import io.github.blanketmc.blanket.config.ConfigEntry;
import io.github.blanketmc.blanket.config.screen.BlanketConfigScreen;
import io.github.blanketmc.blanket.config.screen.widget.BlanketConfigEntryList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.EnumSelectorBuilder;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class FilterScreen
extends AbstractConfigScreen {
    private BlanketConfigEntryList entries;
    private final List<class_4068> drawables = new ArrayList<class_4068>();
    private final List<AbstractConfigEntry> entryList;
    private final Set<ConfigEntry.Category> filteredCategories = new HashSet<ConfigEntry.Category>();
    private FilterMode filterMode = FilterMode.INCLUDE;
    private SortMode sortMode = SortMode.DEFAULT;

    protected FilterScreen(BlanketConfigScreen parent) {
        super((class_437)parent, (class_2561)class_2561.method_43471((String)"blanket-client-tweaks.config.filter"), field_44669);
        for (ConfigEntry.Category category : ConfigEntry.Category.values()) {
            if (category == ConfigEntry.Category.ALL) continue;
            this.filteredCategories.add(category);
        }
        this.entryList = this.createEntries();
    }

    protected void method_25426() {
        super.method_25426();
        this.entries = new BlanketConfigEntryList(this, this.field_22787, this.field_22789, this.field_22790 - 60, 30, this.field_22790 - 30);
        this.entries.setElements(this.entryList);
        this.method_37063((class_364)this.entries);
        int buttonWidths = Math.min(200, (this.field_22789 - 50 - 12) / 3);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"blanket-client-tweaks.config.filter"), widget -> {
            this.saveAll(false);
            this.quit();
        }).method_46434((this.field_22789 + buttonWidths) / 2 - buttonWidths, this.field_22790 - 26, buttonWidths, 20).method_46431());
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        this.entries.method_25394(graphics, mouseX, mouseY, delta);
        for (class_4068 drawable : this.drawables) {
            drawable.method_25394(graphics, mouseX, mouseY, delta);
        }
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 4 * 3, 10, 0xFFFFFF);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    public void saveAll(boolean openOtherScreens) {
        super.saveAll(openOtherScreens);
        ((BlanketConfigScreen)this.parent).categoryFilter = categories -> {
            for (ConfigEntry.Category category : categories) {
                if (!this.filteredCategories.contains((Object)category)) continue;
                return this.filterMode == FilterMode.INCLUDE;
            }
            return this.filterMode == FilterMode.EXCLUDE;
        };
        ((BlanketConfigScreen)this.parent).setSortOrder(this.sortMode.order);
    }

    public boolean matchesSearch(Iterator<String> iterator) {
        return true;
    }

    public Map<class_2561, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        HashMap map = new HashMap();
        List list = this.entryList.stream().collect(ArrayList::new, List::add, List::addAll);
        map.put((class_2561)class_2561.method_43470((String)"bulk"), list);
        return map;
    }

    private List<AbstractConfigEntry> createEntries() {
        ArrayList<AbstractConfigEntry> entries = new ArrayList<AbstractConfigEntry>();
        ConfigEntryBuilder entryBuilder = ConfigEntryBuilder.create();
        EnumSelectorBuilder sortOrder = entryBuilder.startEnumSelector((class_2561)class_2561.method_43471((String)"blanket-client-tweaks.config.order"), SortMode.class, (Enum)this.sortMode);
        sortOrder.setSaveConsumer(order -> {
            this.sortMode = order;
        });
        entries.add((AbstractConfigEntry)sortOrder.build());
        EnumSelectorBuilder mode = entryBuilder.startEnumSelector((class_2561)class_2561.method_43471((String)"blanket-client-tweaks.config.filterMode"), FilterMode.class, (Enum)this.filterMode);
        mode.setSaveConsumer(filterMode -> {
            this.filterMode = filterMode;
        });
        entries.add((AbstractConfigEntry)mode.build());
        for (ConfigEntry.Category category : ConfigEntry.Category.values()) {
            if (category == ConfigEntry.Category.ALL) continue;
            BooleanToggleBuilder toggleBuilder = entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)category.toString()).method_27692(class_124.field_1078), this.filteredCategories.contains((Object)category));
            toggleBuilder.setSaveConsumer(aBoolean -> {
                if (aBoolean.booleanValue()) {
                    this.filteredCategories.add(category);
                } else {
                    this.filteredCategories.remove((Object)category);
                }
            });
            entries.add((AbstractConfigEntry)toggleBuilder.build());
        }
        for (AbstractConfigEntry entry : entries) {
            entry.setScreen((AbstractConfigScreen)this);
        }
        return entries;
    }

    private static enum FilterMode {
        INCLUDE,
        EXCLUDE;

    }

    private static enum SortMode {
        DEFAULT(0),
        INCREASING(1),
        DECREASING(-1);

        final int order;

        private SortMode(int order) {
            this.order = order;
        }
    }
}

