/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.client.renderer;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.DrawerBlock;
import io.github.mattidragon.extendeddrawers.block.base.StorageDrawerBlock;
import io.github.mattidragon.extendeddrawers.block.entity.DrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.client.renderer.AbstractDrawerBlockEntityRenderer;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.config.category.ClientCategory;
import io.github.mattidragon.extendeddrawers.storage.DrawerSlot;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;

@Environment(value=EnvType.CLIENT)
public class DrawerBlockEntityRenderer
extends AbstractDrawerBlockEntityRenderer<DrawerBlockEntity> {
    public DrawerBlockEntityRenderer(class_5614.class_5615 context) {
        super(context.method_43335(), context.method_32143());
    }

    public int method_33893() {
        ClientCategory config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client();
        return Math.max(config.iconRenderDistance(), Math.max(config.textRenderDistance(), config.itemRenderDistance()));
    }

    public void render(DrawerBlockEntity drawer, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2350 horizontalDir = (class_2350)drawer.method_11010().method_11654((class_2769)StorageDrawerBlock.FACING);
        class_2738 face = (class_2738)drawer.method_11010().method_11654(StorageDrawerBlock.FACE);
        class_2350 dir = StorageDrawerBlock.getFront(drawer.method_11010());
        class_1937 world = drawer.method_10997();
        if (!this.shouldRender(drawer, dir)) {
            return;
        }
        matrices.method_22903();
        this.alignMatrices(matrices, horizontalDir, face);
        light = class_761.method_23794((class_1920)((class_1920)Objects.requireNonNull(drawer.method_10997())), (class_2338)drawer.method_11016().method_10093(dir));
        int slots = ((DrawerBlock)drawer.method_11010().method_26204()).slots;
        class_2338 blockPos = drawer.method_11016();
        switch (slots) {
            case 1: {
                this.renderSlot(drawer.storages[0], false, light, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), overlay, blockPos, world);
                break;
            }
            case 2: {
                matrices.method_22904(-0.25, 0.0, 0.0);
                this.renderSlot(drawer.storages[0], true, light, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), overlay, blockPos, world);
                matrices.method_22904(0.5, 0.0, 0.0);
                this.renderSlot(drawer.storages[1], true, light, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), overlay, blockPos, world);
                break;
            }
            case 4: {
                matrices.method_22904(-0.25, 0.25, 0.0);
                this.renderSlot(drawer.storages[0], true, light, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), overlay, blockPos, world);
                matrices.method_22904(0.5, 0.0, 0.0);
                this.renderSlot(drawer.storages[1], true, light, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), overlay, blockPos, world);
                matrices.method_22904(-0.5, -0.5, 0.0);
                this.renderSlot(drawer.storages[2], true, light, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), overlay, blockPos, world);
                matrices.method_22904(0.5, 0.0, 0.0);
                this.renderSlot(drawer.storages[3], true, light, matrices, vertexConsumers, (int)drawer.method_11016().method_10063(), overlay, blockPos, world);
                break;
            }
            default: {
                ExtendedDrawers.LOGGER.error("Unexpected drawer slot count, skipping rendering. Are you an addon dev adding more configurations? If so please mixin into DrawerBlockEntityRenderer and add your layout.");
            }
        }
        matrices.method_22909();
    }

    private void renderSlot(DrawerSlot storage, boolean small, int light, class_4587 matrices, class_4597 vertexConsumers, int seed, int overlay, class_2338 pos, class_1937 world) {
        ArrayList<class_1058> icons = new ArrayList<class_1058>();
        ClientCategory.IconGroup config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client().icons();
        Function blockAtlas = class_310.method_1551().method_1549(class_1723.field_21668);
        if (storage.isLocked()) {
            icons.add((class_1058)blockAtlas.apply(config.lockedIcon()));
        }
        if (storage.isVoiding()) {
            icons.add((class_1058)blockAtlas.apply(config.voidingIcon()));
        }
        if (storage.isHidden()) {
            icons.add((class_1058)blockAtlas.apply(config.hiddenIcon()));
        }
        if (storage.isDuping()) {
            icons.add((class_1058)blockAtlas.apply(config.dupingIcon()));
        }
        if (storage.getUpgrade() != null) {
            icons.add((class_1058)blockAtlas.apply(storage.getUpgrade().sprite));
        }
        if (storage.hasLimiter()) {
            icons.add((class_1058)blockAtlas.apply(ExtendedDrawers.id("item/limiter")));
        }
        String amount = String.valueOf(storage.getAmount());
        if (storage.getAmount() == 0L && !((ConfigData)ExtendedDrawers.CONFIG.get()).client().displayEmptyCount()) {
            amount = null;
        }
        if (storage.isDuping()) {
            amount = "\u221e";
        }
        this.renderSlot(storage.getResource(), amount, small, storage.isHidden(), icons, matrices, vertexConsumers, light, overlay, seed, pos, world);
    }
}

