/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block.base;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.base.CreativeBreakBlocker;
import io.github.mattidragon.extendeddrawers.block.base.DrawerInteractionHandler;
import io.github.mattidragon.extendeddrawers.block.base.NetworkBlockWithEntity;
import io.github.mattidragon.extendeddrawers.block.entity.StorageDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.item.UpgradeItem;
import io.github.mattidragon.extendeddrawers.misc.DrawerInteractionStatusManager;
import io.github.mattidragon.extendeddrawers.misc.DrawerRaycastUtil;
import io.github.mattidragon.extendeddrawers.registry.ModItems;
import io.github.mattidragon.extendeddrawers.storage.ModifierAccess;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public abstract class StorageDrawerBlock<T extends StorageDrawerBlockEntity>
extends NetworkBlockWithEntity<T>
implements DrawerInteractionHandler,
CreativeBreakBlocker {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2754<class_2738> FACE = class_2741.field_12555;

    protected StorageDrawerBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(FACE, (Comparable)class_2738.field_12471));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, FACE});
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2738 face = switch (ctx.method_7715().method_10153()) {
            case class_2350.field_11033 -> class_2738.field_12473;
            case class_2350.field_11036 -> class_2738.field_12475;
            default -> class_2738.field_12471;
        };
        return (class_2680)((class_2680)this.method_9564().method_11657(FACE, (Comparable)face)).method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        StorageDrawerBlockEntity blockEntity = (StorageDrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        if (blockEntity != null && ((ConfigData)ExtendedDrawers.CONFIG.get()).misc().dropDrawersInCreative() && !world.field_9236 && player.method_7337() && !blockEntity.isEmpty()) {
            StorageDrawerBlock.method_9609((class_2680)state, (class_3218)((class_3218)world), (class_2338)pos, (class_2586)blockEntity, (class_1297)player, (class_1799)player.method_5998(class_1268.field_5808)).forEach(stack -> class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack));
        }
        super.method_9576(world, pos, state, player);
    }

    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!player.method_7294()) {
            return;
        }
        StorageDrawerBlockEntity drawer = (StorageDrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        if (drawer == null) {
            return;
        }
        class_3965 hit = DrawerRaycastUtil.getTarget(player, pos);
        if (hit.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        class_241 internalPos = DrawerRaycastUtil.calculateFaceLocation(pos, hit.method_17784(), hit.method_17780(), (class_2350)state.method_11654((class_2769)FACING), (class_2738)state.method_11654(FACE));
        if (internalPos == null) {
            return;
        }
        StorageView<ItemVariant> storage = this.getSlot(drawer, this.getSlotIndex(drawer, internalPos));
        if (storage.isResourceBlank()) {
            return;
        }
        try (Transaction t = Transaction.openOuter();){
            ItemVariant item = (ItemVariant)storage.getResource();
            int extracted = (int)storage.extract((Object)item, player.method_5715() ? (long)item.getItem().method_7882() : 1L, (TransactionContext)t);
            if (extracted == 0) {
                return;
            }
            player.method_31548().method_7398(item.toStack(extracted));
            t.commit();
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!this.isFront(state, hit.method_17780()) || !player.method_7294() || hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        if (!(world instanceof class_3218)) {
            return class_1269.field_33562;
        }
        class_241 internalPos = DrawerRaycastUtil.calculateFaceLocation(pos, hit.method_17784(), hit.method_17780(), (class_2350)state.method_11654((class_2769)FACING), (class_2738)state.method_11654(FACE));
        if (internalPos == null) {
            return class_1269.field_5811;
        }
        StorageDrawerBlockEntity drawer = (StorageDrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        if (drawer == null) {
            return class_1269.field_5811;
        }
        int slot = this.getSlotIndex(drawer, internalPos);
        StorageView<ItemVariant> storage = this.getSlot(drawer, slot);
        ModifierAccess modifiers = this.getModifierAccess(drawer, internalPos);
        class_1799 playerStack = player.method_5998(hand);
        if (playerStack.method_7960() && player.method_5715()) {
            boolean changeResult = modifiers.changeLimiter(ItemVariant.blank(), world, pos, hit.method_17780(), player) || modifiers.changeUpgrade(ItemVariant.blank(), world, pos, hit.method_17780(), player);
            return changeResult ? class_1269.field_5812 : class_1269.field_5814;
        }
        boolean isDoubleClick = DrawerInteractionStatusManager.getAndResetInsertStatus(player, pos, slot);
        try (Transaction t = Transaction.openOuter();){
            int inserted;
            modifiers.overrideLock((TransactionContext)t);
            if (isDoubleClick) {
                if (storage.isResourceBlank()) {
                    class_1269 class_12692 = class_1269.field_5811;
                    return class_12692;
                }
                inserted = (int)StorageUtil.move((Storage)PlayerInventoryStorage.of((class_1657)player), (Storage)((SingleSlotStorage)storage), itemVariant -> true, (long)Long.MAX_VALUE, (TransactionContext)t);
            } else {
                if (playerStack.method_7960()) {
                    class_1269 class_12693 = class_1269.field_5811;
                    return class_12693;
                }
                inserted = (int)((SingleSlotStorage)storage).insert((Object)ItemVariant.of((class_1799)playerStack), (long)playerStack.method_7947(), (TransactionContext)t);
                playerStack.method_7934(inserted);
            }
            if (inserted == 0) {
                class_1269 class_12694 = class_1269.field_33562;
                return class_12694;
            }
            t.commit();
            class_1269 class_12695 = class_1269.field_21466;
            return class_12695;
        }
    }

    public abstract int getSlotIndex(T var1, class_241 var2);

    public abstract StorageView<ItemVariant> getSlot(T var1, int var2);

    public abstract int method_9572(class_2680 var1, class_1937 var2, class_2338 var3);

    protected abstract ModifierAccess getModifierAccess(T var1, class_241 var2);

    @Nullable
    protected ModifierAccess tryGetModifierAccess(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        class_241 facePos = DrawerRaycastUtil.calculateFaceLocation(pos, hitPos, side, (class_2350)state.method_11654((class_2769)FACING), (class_2738)state.method_11654(FACE));
        if (facePos == null) {
            return null;
        }
        StorageDrawerBlockEntity drawer = (StorageDrawerBlockEntity)((Object)this.getBlockEntity(world, pos));
        if (drawer == null) {
            return null;
        }
        return this.getModifierAccess(drawer, facePos);
    }

    @Override
    public class_1269 toggleLock(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        ModifierAccess access = this.tryGetModifierAccess(state, world, pos, hitPos, side);
        if (access == null) {
            return class_1269.field_5811;
        }
        access.setLocked(!access.isLocked());
        return class_1269.field_5812;
    }

    @Override
    public class_1269 toggleVoid(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        ModifierAccess access = this.tryGetModifierAccess(state, world, pos, hitPos, side);
        if (access == null) {
            return class_1269.field_5811;
        }
        access.setVoiding(!access.isVoiding());
        return class_1269.field_5812;
    }

    @Override
    public class_1269 toggleHide(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        ModifierAccess access = this.tryGetModifierAccess(state, world, pos, hitPos, side);
        if (access == null) {
            return class_1269.field_5811;
        }
        access.setHidden(!access.isHidden());
        return class_1269.field_5812;
    }

    @Override
    public class_1269 toggleDuping(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side) {
        ModifierAccess access = this.tryGetModifierAccess(state, world, pos, hitPos, side);
        if (access == null) {
            return class_1269.field_5811;
        }
        access.setDuping(!access.isDuping());
        return class_1269.field_5812;
    }

    @Override
    public class_1269 changeUpgrade(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side, class_1657 player, class_1799 stack) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        ModifierAccess access = this.tryGetModifierAccess(state, world, pos, hitPos, side);
        if (access == null) {
            return class_1269.field_5811;
        }
        if (!(stack.method_7909() instanceof UpgradeItem)) {
            ExtendedDrawers.LOGGER.warn("Expected drawer upgrade to be UpgradeItem but found " + stack.method_7909().getClass().getSimpleName() + " instead");
            return class_1269.field_5814;
        }
        boolean changed = access.changeUpgrade(ItemVariant.of((class_1799)stack), world, pos, side, player);
        if (changed) {
            stack.method_7934(1);
        }
        return changed ? class_1269.field_5812 : class_1269.field_5814;
    }

    @Override
    public class_1269 changeLimiter(class_2680 state, class_1937 world, class_2338 pos, class_243 hitPos, class_2350 side, class_1657 player, class_1799 stack) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        ModifierAccess access = this.tryGetModifierAccess(state, world, pos, hitPos, side);
        if (access == null) {
            return class_1269.field_5811;
        }
        if (!stack.method_31574((class_1792)ModItems.LIMITER)) {
            ExtendedDrawers.LOGGER.warn("Expected limiter to be limiter but found " + stack + " instead");
            return class_1269.field_5814;
        }
        boolean changed = access.changeLimiter(ItemVariant.of((class_1799)stack), world, pos, side, player);
        if (changed) {
            stack.method_7934(1);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public static class_2350 getFront(class_2680 state) {
        return switch ((class_2738)state.method_11654(FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2738.field_12475 -> class_2350.field_11036;
            case class_2738.field_12473 -> class_2350.field_11033;
            case class_2738.field_12471 -> (class_2350)state.method_11654((class_2769)FACING);
        };
    }

    @Override
    public boolean isFront(class_2680 state, class_2350 direction) {
        return switch ((class_2738)state.method_11654(FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2738.field_12475 -> {
                if (direction == class_2350.field_11036) {
                    yield true;
                }
                yield false;
            }
            case class_2738.field_12473 -> {
                if (direction == class_2350.field_11033) {
                    yield true;
                }
                yield false;
            }
            case class_2738.field_12471 -> direction == state.method_11654((class_2769)FACING);
        };
    }
}

