/*
 * Decompiled with CFR 0.152.
 */
package com.kneelawk.extramodintegrations.tconstruct.recipe.melting;

import com.kneelawk.extramodintegrations.tconstruct.TiCCategories;
import com.kneelawk.extramodintegrations.tconstruct.Util;
import com.kneelawk.extramodintegrations.tconstruct.recipe.melting.AbstractMeltingEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TankWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;

public class MeltingEmiRecipe
extends AbstractMeltingEmiRecipe {
    private final int time;
    private final int temperature;
    private final IMeltingContainer.OreRateType oreRateType;

    public static MeltingEmiRecipe of(MeltingRecipe recipe) {
        class_2960 id;
        class_1799[] inputStacks = recipe.getInput().method_8105();
        if (inputStacks.length > 0) {
            class_2960 inputId = class_7923.field_41178.method_10221((Object)inputStacks[0].method_7909());
            id = recipe.method_8114().method_48331("/" + inputId.method_12836() + "/" + inputId.method_12832());
        } else {
            id = recipe.method_8114();
        }
        return new MeltingEmiRecipe(recipe, id);
    }

    private MeltingEmiRecipe(MeltingRecipe recipe, class_2960 id) {
        super(TiCCategories.MELTING, id);
        this.inputs = recipe.method_8117().stream().map(EmiIngredient::of).toList();
        this.outputs = List.of(Util.convertFluid(recipe.getOutput()));
        this.time = recipe.getTime();
        this.temperature = recipe.getTemperature();
        this.oreRateType = recipe.getOreType();
    }

    @Override
    protected int getTime() {
        return this.time;
    }

    @Override
    protected int getTemperature() {
        return this.temperature;
    }

    @Override
    protected IMeltingContainer.OreRateType getOreType() {
        return this.oreRateType;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        int fuelHeight;
        super.addWidgets(widgets);
        if (this.temperature <= 800) {
            widgets.addTexture(BACKGROUND_LOC, 1, 19, 18, 20, 164, 0);
        }
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 23, 17).drawBack(false);
        ((TankWidget)widgets.add((Widget)new TankWidget((EmiIngredient)this.outputs.get(0), 95, 3, 34, 34, 81000L))).drawBack(false).recipeContext((EmiRecipe)this);
        if (this.temperature <= 800) {
            fuelHeight = 15;
            widgets.addSlot(EmiIngredient.of(((List)MeltingFuelHandler.SOLID_FUELS.get()).stream().map(EmiStack::of).toList()), 1, 21).drawBack(false);
        } else {
            fuelHeight = 32;
        }
        ((TankWidget)widgets.add((Widget)new TankWidget(EmiIngredient.of(MeltingFuelHandler.getUsableFuels((int)this.temperature).stream().map(Util::convertFluid).toList()), 3, 3, 14, fuelHeight + 2, 1L))).drawBack(false);
    }
}

