/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.emi;

import com.christofmeg.justenoughbreeding.emi.EMIPlugin;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.utils.Utils;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class BreedingCategoryEMI
implements EmiRecipe {
    private final class_2960 id;
    private final BreedingRecipe recipe;
    public static final EmiTexture TOP = new EmiTexture(EmiRenderHelper.WIDGETS, 18, 0, 25, 1);
    public static final EmiTexture CORNER = new EmiTexture(EmiRenderHelper.WIDGETS, 43, 0, 1, 1);
    public static final EmiTexture LEFT = new EmiTexture(EmiRenderHelper.WIDGETS, 18, 0, 1, 25);
    public static final EmiTexture RIGHT = new EmiTexture(EmiRenderHelper.WIDGETS, 43, 1, 1, 25);
    public static final EmiTexture BOTTOM = new EmiTexture(EmiRenderHelper.WIDGETS, 19, 25, 25, 1);
    public static final EmiTexture BACKGROUND = new EmiTexture(EmiRenderHelper.WIDGETS, 19, 1, 24, 24);
    public static EmiRecipeCategory TYPE = new EmiRecipeCategory(new class_2960("justenoughbreeding:breeding"), (EmiRenderable)EmiStack.of((class_1935)class_1802.field_8861), EMIPlugin.simplifiedRenderer(), EmiRecipeSorting.none());

    protected BreedingCategoryEMI(Builder builder, BreedingRecipe breedingRecipe) {
        this.id = builder.id;
        this.recipe = breedingRecipe;
    }

    public static Builder builder() {
        return new Builder();
    }

    public EmiRecipeCategory getCategory() {
        return TYPE;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of((class_1856)this.recipe.breedingCatalyst));
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(EmiIngredient.of((class_1856)this.recipe.breedingCatalyst), EmiIngredient.of((class_1856)this.recipe.extraInputStack));
    }

    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> list = new ArrayList<EmiStack>();
        if (this.recipe.resultItemStack != null) {
            for (class_1799 item : this.recipe.resultItemStack.method_8105()) {
                list.add(EmiStack.of((class_1799)item));
            }
        }
        return list;
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public int getDisplayWidth() {
        return 168;
    }

    public int getDisplayHeight() {
        return 93;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 94, 48);
        widgets.addSlot((EmiIngredient)EmiStack.of((class_1799)this.recipe.spawnEgg), 149, 1);
        widgets.addSlot(EmiIngredient.of((class_1856)this.recipe.breedingCatalyst), 69, 58);
        widgets.addSlot(EmiIngredient.of((class_1856)this.recipe.extraInputStack), 69, 39);
        widgets.addSlot(EmiIngredient.of((class_1856)this.recipe.resultItemStack), 126, 44).large(true).recipeContext((EmiRecipe)this);
        widgets.addTexture(TOP, 1, 11);
        widgets.addTexture(TOP, 26, 11);
        widgets.addTexture(TOP, 36, 11);
        widgets.addTexture(CORNER, 61, 11);
        widgets.addTexture(LEFT, 1, 12);
        widgets.addTexture(LEFT, 1, 37);
        widgets.addTexture(LEFT, 1, 62);
        widgets.addTexture(LEFT, 1, 66);
        widgets.addTexture(RIGHT, 61, 12);
        widgets.addTexture(RIGHT, 61, 37);
        widgets.addTexture(RIGHT, 61, 62);
        widgets.addTexture(RIGHT, 61, 66);
        widgets.addTexture(BACKGROUND, 2, 12);
        widgets.addTexture(BACKGROUND, 26, 12);
        widgets.addTexture(BACKGROUND, 37, 12);
        widgets.addTexture(BACKGROUND, 2, 36);
        widgets.addTexture(BACKGROUND, 26, 36);
        widgets.addTexture(BACKGROUND, 37, 36);
        widgets.addTexture(BACKGROUND, 2, 60);
        widgets.addTexture(BACKGROUND, 26, 60);
        widgets.addTexture(BACKGROUND, 37, 60);
        widgets.addTexture(BACKGROUND, 2, 67);
        widgets.addTexture(BACKGROUND, 26, 67);
        widgets.addTexture(BACKGROUND, 37, 67);
        widgets.addTexture(CORNER, 1, 91);
        widgets.addTexture(BOTTOM, 2, 91);
        widgets.addTexture(BOTTOM, 27, 91);
        widgets.addTexture(BOTTOM, 37, 91);
        widgets.add(new Widget(){

            public Bounds getBounds() {
                return new Bounds(0, 0, 60, 80);
            }

            public void method_25394(class_332 stack, int mouseX, int mouseY, float delta) {
                class_1309 currentLivingEntity = BreedingCategoryEMI.this.recipe.doRendering();
                if (currentLivingEntity != null) {
                    Utils.renderEntity(stack.method_51448(), mouseX, currentLivingEntity);
                }
            }
        });
        class_1299<?> entityType = this.recipe.entityType;
        if (entityType != null) {
            class_310 instance = class_310.method_1551();
            class_327 font = instance.field_1772;
            class_5250 entityName = class_2561.method_43471((String)entityType.method_5882());
            Object entityNameString = entityName.getString();
            if (this.recipe.needsToBeTamed != null) {
                class_5250 tamed = class_2561.method_43471((String)"translation.justenoughbreeding.tamed");
                entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
            } else if (this.recipe.animalTrusting != null) {
                class_5250 trusting = class_2561.method_43471((String)"translation.justenoughbreeding.trusting");
                entityNameString = (String)entityNameString + " (" + trusting.getString() + ")";
            }
            int stringWidth = font.method_1727((String)entityNameString);
            int availableWidth = 154;
            if (stringWidth > availableWidth) {
                float pixelWidthPerCharacter = (float)stringWidth / (float)((String)entityNameString).length();
                int maxCharacters = (int)((float)availableWidth / pixelWidthPerCharacter);
                entityNameString = ((String)entityNameString).substring(0, maxCharacters);
            }
            if (!((String)entityNameString).isEmpty()) {
                class_2561 abbreviatedEntityName = class_2561.method_30163((String)entityNameString);
                widgets.addText(EmiPort.ordered((class_2561)abbreviatedEntityName), 1, 1, -1, true);
            }
        }
    }

    public static class Builder {
        private class_2960 id = null;
        private BreedingRecipe breedingRecipe;

        private Builder() {
        }

        public EmiRecipe build() {
            return new BreedingCategoryEMI(this, this.breedingRecipe);
        }

        public Builder id(class_2960 id) {
            this.id = id;
            return this;
        }

        public Builder breedingRecipe(BreedingRecipe recipe) {
            this.breedingRecipe = recipe;
            return this;
        }
    }
}

