/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import immersive_paintings.Config;
import immersive_paintings.Main;
import immersive_paintings.resources.ByteImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import org.jetbrains.annotations.Nullable;

public final class Painting {
    public int width;
    public int height;
    public final int resolution;
    public final String name;
    public final String author;
    public final boolean datapack;
    public final boolean hidden;
    public final boolean graffiti;
    public final Texture texture;
    public final Texture half;
    public final Texture quarter;
    public final Texture eighth;
    public final Texture thumbnail;
    public static final Painting DEFAULT = new Painting(new ByteImage(16, 16), 16);

    public Painting(@Nullable ByteImage image, int width, int height, int resolution, boolean hidden, boolean graffiti) {
        this(image, width, height, resolution, "", "", false, hidden, graffiti, UUID.randomUUID().toString());
    }

    public Painting(@Nullable ByteImage image, int width, int height, int resolution, String name, String author, boolean datapack, boolean hidden, boolean graffiti, String hash) {
        this.graffiti = graffiti;
        this.texture = new Texture(image, hash, Type.FULL);
        int res = Math.max(width, height) * resolution;
        Type halfType = res / 2 < Config.getInstance().lodResolutionMinimum ? Type.FULL : Type.HALF;
        this.half = new Texture(null, hash + "_half", halfType);
        Type quarterType = res / 4 < Config.getInstance().lodResolutionMinimum ? halfType : Type.QUARTER;
        this.quarter = new Texture(null, hash + "_quarter", quarterType);
        Type eighthType = res / 8 < Config.getInstance().lodResolutionMinimum ? quarterType : Type.EIGHTH;
        this.eighth = new Texture(null, hash + "_eighth", eighthType);
        Type thumbnailType = res < Config.getInstance().thumbnailSize ? Type.FULL : Type.THUMBNAIL;
        this.thumbnail = new Texture(null, hash + "_thumbnail", thumbnailType);
        this.width = width;
        this.height = height;
        this.resolution = resolution;
        this.name = name;
        this.author = author;
        this.datapack = datapack;
        this.hidden = hidden;
    }

    public Painting(ByteImage image, int resolution) {
        this(image, image.getWidth() / resolution, image.getHeight() / resolution, resolution, "", "", false, false, false, UUID.randomUUID().toString());
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("width", this.width);
        nbt.method_10569("height", this.height);
        nbt.method_10569("resolution", this.resolution);
        nbt.method_10582("name", this.name);
        nbt.method_10582("author", this.author);
        nbt.method_10556("datapack", this.datapack);
        nbt.method_10556("hidden", this.hidden);
        nbt.method_10556("graffiti", this.graffiti);
        nbt.method_10582("hash", this.texture.hash);
        return nbt;
    }

    public static Painting fromNbt(class_2487 nbt) {
        int width = nbt.method_10550("width");
        int height = nbt.method_10550("height");
        int resolution = nbt.method_10550("resolution");
        String name = nbt.method_10558("name");
        String author = nbt.method_10558("author");
        boolean datapack = nbt.method_10577("datapack");
        boolean hidden = nbt.method_10577("hidden");
        boolean graffiti = nbt.method_10577("graffiti");
        String hash = nbt.method_10558("hash");
        return new Painting(null, width, height, resolution, name, author, datapack, hidden, graffiti, hash);
    }

    public Texture getTexture(Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.FULL -> this.texture;
            case Type.HALF -> this.half;
            case Type.QUARTER -> this.quarter;
            case Type.EIGHTH -> this.eighth;
            case Type.THUMBNAIL -> this.thumbnail;
        };
    }

    public static class Texture {
        public ByteImage image;
        public boolean requested = false;
        public class_2960 textureIdentifier = Main.locate("textures/block/frame/canvas.png");
        public class_3298 resource;
        public final String hash;
        public final Type link;
        private byte[] cache;

        public Texture(ByteImage image, String hash, Type link) {
            this.image = image;
            this.hash = hash;
            this.link = link;
        }

        public byte[] getResource() {
            if (this.cache == null) {
                try (InputStream stream = this.resource.method_14482();){
                    this.cache = stream.readAllBytes();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.cache;
        }
    }

    public static enum Type {
        FULL,
        HALF,
        QUARTER,
        EIGHTH,
        THUMBNAIL;

    }
}

