/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.client.render.entity.renderer;

import immersive_paintings.Config;
import immersive_paintings.Main;
import immersive_paintings.entity.ImmersivePaintingEntity;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.ObjectLoader;
import immersive_paintings.resources.Painting;
import java.util.List;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import owens.oobjloader.Face;
import owens.oobjloader.FaceVertex;

public class ImmersivePaintingEntityRenderer<T extends ImmersivePaintingEntity>
extends class_897<T> {
    public ImmersivePaintingEntityRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    public void render(T entity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        matrixStack.method_22903();
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-yaw));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(-entity.method_5695(tickDelta)));
        matrixStack.method_22905(0.0625f, 0.0625f, 0.0625f);
        this.renderPainting(matrixStack, vertexConsumerProvider, entity);
        matrixStack.method_22909();
        super.method_3936(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
    }

    public class_2960 getTexture(T paintingEntity) {
        int resolution;
        class_310 client = class_310.method_1551();
        Config config = Config.getInstance();
        class_746 player = client.field_1724;
        double distance = player == null ? 0.0 : player.method_19538().method_1022(paintingEntity.method_19538());
        double blocksVisible = Math.tan((double)((Integer)client.field_1690.method_41808().method_41753()).intValue() / 180.0 * Math.PI / 2.0) * 2.0 * distance;
        double pixelDensity = blocksVisible * (double)(resolution = ClientPaintingManager.getPainting((class_2960)((ImmersivePaintingEntity)((Object)paintingEntity)).getMotive()).resolution) / (double)client.method_22683().method_4507();
        Painting.Type type = pixelDensity > (double)config.eighthResolutionThreshold ? Painting.Type.EIGHTH : (pixelDensity > (double)config.quarterResolutionThreshold ? Painting.Type.QUARTER : (pixelDensity > (double)config.halfResolutionThreshold ? Painting.Type.HALF : Painting.Type.FULL));
        return ClientPaintingManager.getPaintingTexture((class_2960)((ImmersivePaintingEntity)((Object)paintingEntity)).getMotive(), (Painting.Type)type).textureIdentifier;
    }

    protected int getLight(int light) {
        return light;
    }

    protected int getFrameLight(int light) {
        return light;
    }

    private void renderPainting(class_4587 matrices, class_4597 vertexConsumerProvider, T entity) {
        int light = class_761.method_23794((class_1920)entity.method_37908(), (class_2338)entity.method_24515());
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix4f posMat = entry.method_23761();
        Matrix3f normMat = entry.method_23762();
        boolean hasFrame = !((ImmersivePaintingEntity)((Object)entity)).getFrame().method_12832().equals("none");
        int width = ((ImmersivePaintingEntity)((Object)entity)).getWidthPixels();
        int height = ((ImmersivePaintingEntity)((Object)entity)).getHeightPixels();
        class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(this.isTranslucent() ? class_1921.method_23580((class_2960)this.getTexture(entity)) : class_1921.method_23572((class_2960)this.getTexture(entity)));
        this.renderFaces(this.isTranslucent() ? "objects/graffiti.obj" : "objects/canvas.obj", posMat, normMat, vertexConsumer, this.getLight(light), width, height, hasFrame ? 1.0f : 0.0f);
        int frameLight = this.getFrameLight(light);
        if (hasFrame) {
            vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23576((class_2960)((ImmersivePaintingEntity)((Object)entity)).getMaterial()));
            this.renderFrame(((ImmersivePaintingEntity)((Object)entity)).getFrame(), posMat, normMat, vertexConsumer, frameLight, width, height);
        }
    }

    protected boolean isTranslucent() {
        return false;
    }

    private void renderFaces(String name, Matrix4f posMat, Matrix3f normMat, class_4588 vertexConsumer, int light, float width, float height, float margin) {
        List<Face> faces = ObjectLoader.objects.get(Main.locate(name));
        for (Face face : faces) {
            for (FaceVertex v : face.vertices) {
                this.vertex(posMat, normMat, vertexConsumer, v.v.x * (width - margin * 2.0f), v.v.y * (height - margin * 2.0f), v.v.z * 16.0f, v.t.u * (width - margin * 2.0f) / width + margin / width, (1.0f - v.t.v) * (height - margin * 2.0f) / height + margin / height, v.n.x, v.n.y, v.n.z, light);
            }
        }
    }

    private List<Face> getFaces(class_2960 frame, String part) {
        class_2960 id = new class_2960(frame.method_12836(), frame.method_12832() + "/" + part + ".obj");
        if (ObjectLoader.objects.containsKey(id)) {
            return ObjectLoader.objects.get(id);
        }
        return List.of();
    }

    private void renderFrame(class_2960 frame, Matrix4f posMat, Matrix3f normMat, class_4588 vertexConsumer, int light, float width, float height) {
        float u;
        List<Face> faces = this.getFaces(frame, "bottom");
        int x = 0;
        while ((float)x < width / 16.0f) {
            u = width == 16.0f ? 0.75f : (x == 0 ? 0.0f : ((float)x == width / 16.0f - 1.0f ? 0.5f : 0.25f));
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(posMat, normMat, vertexConsumer, v.v.x + (float)(x * 16) - (width - 16.0f) / 2.0f, v.v.y - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++x;
        }
        faces = this.getFaces(frame, "top");
        x = 0;
        while ((float)x < width / 16.0f) {
            u = width == 16.0f ? 0.75f : (x == 0 ? 0.0f : ((float)x == width / 16.0f - 1.0f ? 0.5f : 0.25f));
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(posMat, normMat, vertexConsumer, v.v.x + (float)(x * 16) - (width - 16.0f) / 2.0f, v.v.y + (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++x;
        }
        faces = this.getFaces(frame, "right");
        int y = 0;
        while ((float)y < height / 16.0f) {
            u = 0.25f;
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(posMat, normMat, vertexConsumer, v.v.x + (width - 16.0f) / 2.0f, v.v.y + (float)(y * 16) - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++y;
        }
        faces = this.getFaces(frame, "left");
        y = 0;
        while ((float)y < height / 16.0f) {
            u = 0.25f;
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(posMat, normMat, vertexConsumer, v.v.x - (width - 16.0f) / 2.0f, v.v.y + (float)(y * 16) - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++y;
        }
    }

    private void vertex(Matrix4f positionMatrix, Matrix3f normalMatrix, class_4588 vertexConsumer, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ, int light) {
        vertexConsumer.method_22918(positionMatrix, x, y, z - 0.5f).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, normalX, normalY, normalZ).method_1344();
    }
}

