/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.bendylib.compat.tr7zw;

import dev.tr7zw.skinlayers.api.MeshTransformer;
import dev.tr7zw.skinlayers.api.SkinLayersAPI;
import io.github.kosmx.bendylib.ModelPartAccessor;
import io.github.kosmx.bendylib.MutableCuboid;
import io.github.kosmx.bendylib.impl.BendableCuboid;
import io.github.kosmx.bendylib.impl.IBendable;
import io.github.kosmx.bendylib.impl.ICuboid;
import io.github.kosmx.bendylib.impl.IPosWithOrigin;
import io.github.kosmx.bendylib.impl.RememberingPos;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2350;
import net.minecraft.class_3545;
import net.minecraft.class_630;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.slf4j.Logger;

public class TDSkinCompat {
    public static void init(Logger logger) throws ClassNotFoundException, NoClassDefFoundError {
        logger.info("Initializing 3D Skin Layers compatibility");
        SkinLayersAPI.setupMeshTransformerProvider(modelPart -> {
            Object patt1205$temp;
            final Optional<MutableCuboid> sourceCuboidOptional = ModelPartAccessor.optionalGetCuboid(modelPart, 0);
            if (sourceCuboidOptional.isPresent() && sourceCuboidOptional.get().getActiveMutator() != null && (patt1205$temp = sourceCuboidOptional.get().getActiveMutator().method_15441()) instanceof BendableCuboid) {
                final BendableCuboid bendableSource = (BendableCuboid)patt1205$temp;
                class Bender
                extends BendyMeshTransformer
                implements MeshTransformer {
                    private Consumer<IPosWithOrigin> transform;
                    final /* synthetic */ BendableCuboid val$bendableSource;
                    final /* synthetic */ Optional val$sourceCuboidOptional;

                    private Bender(BendableCuboid cuboid) {
                        this.val$bendableSource = bendableCuboid;
                        this.val$sourceCuboidOptional = optional;
                        super(cuboid);
                        this.transform = null;
                        this.applyBend(this.val$bendableSource.getBendAxis(), this.val$bendableSource.getBend(), consumer -> {
                            this.transform = consumer;
                        });
                        assert (this.transform != null);
                    }

                    public void transform(Vector3f vec3f, Vector4f[] vector4fs) {
                        for (int i = 0; i < vector4fs.length; ++i) {
                            RememberingPos pos = new RememberingPos(new Vector3f(vector4fs[i].x, vector4fs[i].y, vector4fs[i].z));
                            this.transform.accept(pos);
                            vector4fs[i] = new Vector4f((Vector3fc)pos.getPos(), 1.0f);
                        }
                        vec3f.set((Vector3fc)TDSkinCompat.calculateNormal(vector4fs));
                    }

                    public void transform(class_630.class_628 cuboid) {
                        MutableCuboid sourceCuboid = (MutableCuboid)this.val$sourceCuboidOptional.get();
                        class_3545<String, ICuboid> mutator = ((MutableCuboid)this.val$sourceCuboidOptional.get()).getActiveMutator();
                        if (cuboid instanceof MutableCuboid) {
                            MutableCuboid mutableCuboid = (MutableCuboid)cuboid;
                            if (!mutableCuboid.hasMutator((String)mutator.method_15442())) {
                                mutableCuboid.registerMutator((String)mutator.method_15442(), data -> new BendableCuboid.Builder().setDirection(this.getBendDirection()).build(data, (sides, positions, minX, minY, minZ, maxX, maxY, maxZ, fixX, fixY, fixZ, direction, basePlane, otherPlane, fullSize) -> new ModifiedBendableCuboid(sides, positions, minX, minY, minZ, maxX, maxY, maxZ, fixX, fixY, fixZ, direction, this.getBasePlane().scaled(16.0f), this.getOtherSidePlane().scaled(16.0f), this.bendHeight() * 16.0f)));
                            }
                            mutableCuboid.copyStateFrom(sourceCuboid);
                        }
                    }
                }
                return new Bender(bendableSource){
                    {
                        super(cuboid, bendableCuboid, optional);
                    }
                };
            }
            return new MeshTransformer(){

                public void transform(Vector3f vec3f, Vector4f[] vector4fs) {
                }

                public void transform(class_630.class_628 cuboid) {
                    ((MutableCuboid)cuboid).getAndActivateMutator(null);
                }
            };
        });
    }

    public static Vector3f calculateNormal(Vector4f[] vertices) {
        Vector3f buf = new Vector3f(vertices[3].x, vertices[3].y, vertices[3].z);
        buf.negate();
        Vector3f vecB = new Vector3f(vertices[1].x, vertices[1].y, vertices[1].z);
        vecB.add((Vector3fc)buf);
        buf = new Vector3f(vertices[2].x, vertices[2].y, vertices[2].z);
        buf.negate();
        Vector3f vecA = new Vector3f(vertices[0].x, vertices[0].y, vertices[0].z);
        vecA.add((Vector3fc)buf);
        vecA.cross((Vector3fc)vecB);
        return vecA.normalize().isFinite() ? vecA : class_2350.field_11043.method_23955();
    }

    private static class BendyMeshTransformer
    implements IBendable {
        private final class_2350 bendDirection;
        private final float bendX;
        private final float bendY;
        private final float bendZ;
        private final IBendable.Plane basePlane;
        private final IBendable.Plane otherSidePlane;
        private final float bendHeight;

        private BendyMeshTransformer(class_2350 bendDirection, float bendX, float bendY, float bendZ, IBendable.Plane basePlane, IBendable.Plane otherSidePlane, float bendHeight) {
            this.bendDirection = bendDirection;
            this.bendX = bendX / 16.0f;
            this.bendY = bendY / 16.0f;
            this.bendZ = bendZ / 16.0f;
            this.basePlane = basePlane.scaled(0.0625f);
            this.otherSidePlane = otherSidePlane.scaled(0.0625f);
            this.bendHeight = bendHeight / 16.0f;
        }

        private BendyMeshTransformer(BendableCuboid cuboid) {
            this(cuboid.getBendDirection(), cuboid.getBendX(), cuboid.getBendY(), cuboid.getBendZ(), cuboid.getBasePlane(), cuboid.getOtherSidePlane(), cuboid.bendHeight());
        }

        @Override
        public float bendHeight() {
            return this.bendHeight;
        }

        @Override
        public class_2350 getBendDirection() {
            return this.bendDirection;
        }

        @Override
        public float getBendX() {
            return this.bendX;
        }

        @Override
        public float getBendY() {
            return this.bendY;
        }

        @Override
        public float getBendZ() {
            return this.bendZ;
        }

        @Override
        public IBendable.Plane getBasePlane() {
            return this.basePlane;
        }

        @Override
        public IBendable.Plane getOtherSidePlane() {
            return this.otherSidePlane;
        }
    }

    private static class ModifiedBendableCuboid
    extends BendableCuboid {
        protected ModifiedBendableCuboid(BendableCuboid.Quad[] sides, RememberingPos[] positions, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float fixX, float fixY, float fixZ, class_2350 direction, IBendable.Plane basePlane, IBendable.Plane otherPlane, float fullSize) {
            super(sides, positions, minX, minY, minZ, maxX, maxY, maxZ, fixX, fixY, fixZ, direction, basePlane, otherPlane, fullSize);
        }
    }
}

