/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats;

import com.google.gson.JsonObject;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.tcdcommons.util.io.http.TcdWebApi;
import java.io.InputStream;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class BetterStatsProperties {
    private static final JsonObject MOD_PROPERTIES;
    public static final String URL_SOURCES;
    public static final String URL_ISSUES;
    public static final String URL_CURSEFORGE;
    public static final String URL_MODRINTH;
    public static final String URL_YOUTUBE;
    public static final String URL_FEEDBACK;

    public static final void init() {
    }

    @ApiStatus.Internal
    public static final JsonObject getModProperties() {
        return MOD_PROPERTIES;
    }

    static {
        try {
            InputStream propertiesStream = BetterStats.class.getResourceAsStream("/betterstats.properties.json");
            String propertiesJsonStr = new String(propertiesStream.readAllBytes());
            propertiesStream.close();
            MOD_PROPERTIES = (JsonObject)TcdWebApi.GSON.fromJson(propertiesJsonStr, JsonObject.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
        JsonObject links = MOD_PROPERTIES.get("links").getAsJsonObject();
        URL_SOURCES = links.get("sources").getAsString();
        URL_ISSUES = links.get("issues").getAsString();
        URL_CURSEFORGE = links.get("curseforge").getAsString();
        URL_MODRINTH = links.get("modrinth").getAsString();
        URL_YOUTUBE = links.get("youtube").getAsString();
        URL_FEEDBACK = links.get("feedback").getAsString();
    }
}

