/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.archeologyplus.register.items.custom;

import net.emilsg.archeologyplus.register.items.custom.DescriptionItem;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_6017;
import net.minecraft.class_6019;

public class RainIdolItem
extends DescriptionItem {
    public static final class_6017 CLEAR_WEATHER_DURATION_PROVIDER = class_6019.method_35017((int)12000, (int)180000);
    public static final class_6017 RAIN_WEATHER_DURATION_PROVIDER = class_6019.method_35017((int)12000, (int)24000);
    public static final class_6017 THUNDER_WEATHER_DURATION_PROVIDER = class_6019.method_35017((int)3600, (int)15600);

    public RainIdolItem(class_1792.class_1793 settings, String description, class_124 formatting) {
        super(settings, description, formatting);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!user.method_7357().method_7904((class_1792)this) && !world.field_9236) {
            this.toggleWeather((class_3218)world, user);
            for (class_1657 player : world.method_18456()) {
                player.method_7357().method_7906((class_1792)this, 2400);
            }
            return class_1271.method_22427((Object)user.method_5998(hand));
        }
        return super.method_7836(world, user, hand);
    }

    private void toggleWeather(class_3218 world, class_1657 serverUser) {
        int randomInt = world.field_9229.method_43048(4);
        String[] clearRainMsgs = new String[]{"The Clouds Break and Rain Stops", "The Rain stops Abruptly", "Suddenly the Rain Stops", "The Rainclouds Clear"};
        String[] clearThunderMsgs = new String[]{"The Thunder Fades into Silence", "The Thunder Quiets Down and the Sky Lightens", "The Clouds Scatter and Thunder Ceases", "Thunder Fades into the Distance"};
        String[] startRainMsgs = new String[]{"Rainclouds Begin to Form", "Rainclouds Gather in the Sky", "You Feel the Weather Changing", "First Drops of Rain Fall"};
        String[] startThunderMsgs = new String[]{"You Hear the First Clap of Thunder", "The Sky Vibrates with Thunder\u2019s Roar", "Electric Tension Fills the Air", "A Thunderstorm is Brewing"};
        if (world.method_8419() && !world.method_8546()) {
            RainIdolItem.setClear(world);
            serverUser.method_7353((class_2561)class_2561.method_43470((String)clearRainMsgs[randomInt]), true);
        } else if (world.method_8546()) {
            RainIdolItem.setClear(world);
            serverUser.method_7353((class_2561)class_2561.method_43470((String)clearThunderMsgs[randomInt]), true);
        } else {
            boolean thunderChance = world.field_9229.method_43048(3) > 0;
            this.setWeather(world, thunderChance);
            serverUser.method_7353((class_2561)class_2561.method_43470((String)(thunderChance ? startRainMsgs[randomInt] : startThunderMsgs[randomInt])), true);
        }
    }

    private void setWeather(class_3218 world, boolean makeRain) {
        if (makeRain) {
            RainIdolItem.setRain(world);
        } else {
            RainIdolItem.setThunder(world);
        }
    }

    private static int processDuration(class_3218 world, class_6017 provider) {
        return provider.method_35008(world.method_8409());
    }

    private static void setClear(class_3218 world) {
        world.method_27910(RainIdolItem.processDuration(world, CLEAR_WEATHER_DURATION_PROVIDER), 0, false, false);
    }

    private static void setRain(class_3218 world) {
        world.method_27910(0, RainIdolItem.processDuration(world, RAIN_WEATHER_DURATION_PROVIDER), true, false);
    }

    private static void setThunder(class_3218 world) {
        world.method_27910(0, RainIdolItem.processDuration(world, THUNDER_WEATHER_DURATION_PROVIDER), true, true);
    }
}

