/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.utils;

import de.ambertation.wunderlib.configs.ConfigFile;
import de.ambertation.wunderreich.Wunderreich;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.minecraft.class_1928;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class WunderreichGameRules {
    private static class_1928 currentRules;

    public static void setCurrentRules(class_1928 rules) {
        if (currentRules != rules) {
            Wunderreich.LOGGER.info("Load new Set of Server Rules");
            currentRules = rules;
        }
    }

    public static class IntRule
    extends Base<class_1928.class_4312, ConfigFile.IntValue, Integer> {
        public IntRule(class_1928.class_5198 category, ConfigFile.IntValue config) {
            this(category, config, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        public IntRule(class_1928.class_5198 category, ConfigFile.IntValue config, int minValue, int maxValue, BiConsumer<MinecraftServer, class_1928.class_4312> callback) {
            super(category, GameRuleFactory.createIntRule((int)((Integer)config.get()), (int)minValue, (int)maxValue, callback), config);
        }

        public IntRule(class_1928.class_5198 category, ConfigFile.IntValue config, int minValue, int maxValue) {
            super(category, GameRuleFactory.createIntRule((int)((Integer)config.get()), (int)minValue, (int)maxValue), config);
        }

        public IntRule(String name, class_1928.class_5198 category, ConfigFile.IntValue config) {
            this(name, category, config, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }

        public IntRule(String name, class_1928.class_5198 category, ConfigFile.IntValue config, int minValue, int maxValue) {
            super(name, category, GameRuleFactory.createIntRule((int)((Integer)config.get()), (int)minValue, (int)maxValue), config);
        }

        @Override
        protected Integer get(@NotNull class_1928 rules) {
            return rules.method_8356(this.key);
        }
    }

    public static class BooleanRule
    extends Base<class_1928.class_4310, ConfigFile.BooleanValue, Boolean> {
        public BooleanRule(class_1928.class_5198 category, ConfigFile.BooleanValue config) {
            super(category, GameRuleFactory.createBooleanRule((boolean)((Boolean)config.get())), config);
        }

        public BooleanRule(String name, class_1928.class_5198 category, ConfigFile.BooleanValue config) {
            super(name, category, GameRuleFactory.createBooleanRule((boolean)((Boolean)config.get())), config);
        }

        @Override
        protected Boolean get(@NotNull class_1928 rules) {
            return rules.method_8355(this.key);
        }
    }

    private static abstract class Base<T extends class_1928.class_4315<T>, V extends ConfigFile.Value<R, V>, R> {
        public final class_1928.class_4314<T> type;
        public final class_1928.class_4313<T> key;
        public final V config;

        protected Base(class_1928.class_5198 category, class_1928.class_4314<T> type, V config) {
            this(Base.buildName(config), category, type, config);
        }

        protected Base(String name, class_1928.class_5198 category, class_1928.class_4314<T> type, V config) {
            Wunderreich.LOGGER.info("Adding GameRule '" + name + "' (default: " + config.get() + ")");
            this.type = type;
            this.config = config;
            this.key = GameRuleRegistry.register((String)name, (class_1928.class_5198)category, type);
        }

        private static String upperCaseDots(String str) {
            String regex = "(\\.\\w)";
            Pattern pattern = Pattern.compile("(\\.\\w)", 8);
            Matcher matcher = pattern.matcher(str);
            return matcher.replaceAll(m -> m.group(0).substring(1).toUpperCase());
        }

        private static <VV extends ConfigFile.Value> String buildName(VV config) {
            return Base.upperCaseDots(config.token.path()) + config.token.key().substring(0, 1).toUpperCase() + config.token.key().substring(1);
        }

        protected abstract R get(@NotNull class_1928 var1);

        @NotNull
        public R get() {
            if (currentRules == null) {
                return (R)this.config.get();
            }
            return this.get(currentRules);
        }
    }
}

