/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.utils;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.config.LevelData;
import de.ambertation.wunderreich.registries.WunderreichRules;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_7659;
import net.minecraft.class_7780;

public class LiveBlockManager<T extends LiveBlock> {
    public static final class_3230<class_1923> TICKET = class_3230.method_14291((String)"wunderkiste", Comparator.comparingLong(class_1923::method_8324));
    public static final Codec<List<LiveBlock>> CODEC = class_5699.method_36973((Codec)LiveBlock.CODEC.listOf());
    private static final String POSITIONS_TAG = "positions";
    private final String type;
    private final Set<T> liveBlocks = ConcurrentHashMap.newKeySet(8);
    private final List<ChangeEvent> listeners = new LinkedList<ChangeEvent>();
    private class_7780<class_7659> registryAccess;
    private boolean isLoaded = false;
    private Timer saveTimer;
    private static final Map<class_1937, List<ChunkPosCounter>> FORCE_LOAD_CHUNKS = Maps.newConcurrentMap();

    public LiveBlockManager(String type) {
        this.type = type;
    }

    protected Codec<List<T>> codec() {
        return CODEC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancleScheduledSave() {
        LiveBlockManager liveBlockManager = this;
        synchronized (liveBlockManager) {
            if (this.saveTimer != null) {
                this.saveTimer.cancel();
                this.saveTimer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSave() {
        if (!this.isLoaded) {
            Wunderreich.LOGGER.error("Trying to schedule a save an unloaded LiveBlockManager!");
            return;
        }
        LiveBlockManager liveBlockManager = this;
        synchronized (liveBlockManager) {
            if (this.saveTimer != null) {
                return;
            }
            this.saveTimer = new Timer();
        }
        this.saveTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    LiveBlockManager.this.saveRaw();
                    LiveBlockManager.this.cancleScheduledSave();
                }
            }
        }, 10000L);
    }

    private void saveRaw() {
        if (!this.isLoaded) {
            Wunderreich.LOGGER.error("Trying to save an unloaded LiveBlockManager!");
            return;
        }
        class_2487 tag = LevelData.getInstance().getLiveBlocks(this.type);
        class_2520 result = (class_2520)this.codec().encodeStart((DynamicOps)class_2509.field_11560, this.liveBlocks.stream().toList()).resultOrPartial(Wunderreich.LOGGER::error).orElse(new class_2499());
        tag.method_10566(POSITIONS_TAG, result);
        LevelData.getInstance().saveLevelConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (!this.isLoaded) {
            Wunderreich.LOGGER.error("Trying to save an unloaded LiveBlockManager!");
            return;
        }
        LiveBlockManager liveBlockManager = this;
        synchronized (liveBlockManager) {
            this.cancleScheduledSave();
            this.saveRaw();
        }
    }

    public void unLoad() {
        this.save();
        this.registryAccess = null;
        this.isLoaded = false;
        this.liveBlocks.clear();
    }

    public void load(class_7780<class_7659> registryAccess) {
        this.registryAccess = registryAccess;
        this.liveBlocks.clear();
        class_2487 tag = LevelData.getInstance().getLiveBlocks(this.type);
        List list = null;
        if (tag.method_10545(POSITIONS_TAG)) {
            class_2499 positions = tag.method_10554(POSITIONS_TAG, 10);
            list = this.codec().parse((DynamicOps)class_2509.field_11560, (Object)positions).resultOrPartial(Wunderreich.LOGGER::error).orElse(null);
        }
        if (list != null) {
            this.liveBlocks.addAll(list);
        }
        this.isLoaded = true;
    }

    public void assignLevels(Map<class_5321<class_1937>, class_3218> levels) {
        this.liveBlocks.forEach((? super T l) -> l.loadLevel(levels));
    }

    public int size() {
        return this.liveBlocks.size();
    }

    public boolean contains(T live) {
        return this.liveBlocks.contains(live);
    }

    public boolean add(T live) {
        if (!this.isLoaded) {
            Wunderreich.LOGGER.error("Trying to add " + live + " to an unloaded LiveBlockManager!");
            return false;
        }
        if (this.contains(live)) {
            return false;
        }
        this.liveBlocks.add(live);
        this.emitChangeAt((LiveBlock)live);
        LiveBlockManager.addLoadedChunk(live, WunderreichRules.Wunderkiste.chunkLoaderDist());
        this.scheduleSave();
        return true;
    }

    public boolean remove(T live) {
        if (!this.isLoaded) {
            Wunderreich.LOGGER.error("Trying to remove " + live + " from an unloaded LiveBlockManager!");
            return false;
        }
        if (!this.contains(live)) {
            return false;
        }
        this.liveBlocks.remove(live);
        this.emitChangeAt((LiveBlock)live);
        LiveBlockManager.removeLoadedChunk(live, WunderreichRules.Wunderkiste.chunkLoaderDist());
        this.scheduleSave();
        return true;
    }

    public void forEach(Consumer<T> consumer) {
        this.liveBlocks.forEach(consumer);
    }

    public void emitChangeAt(LiveBlock bl) {
        this.listeners.forEach((? super T l) -> l.emit(bl));
    }

    public void emitChange() {
        this.liveBlocks.forEach((? super T bl) -> this.listeners.forEach((? super T l) -> l.emit((LiveBlock)bl)));
    }

    public void onChangeAt(ChangeEvent listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    private static Stream<class_1923> chunksWithRadius(class_1923 start, int radius) {
        Stream.Builder<class_1923> p = Stream.builder();
        for (int x = 1 - radius; x < radius; ++x) {
            for (int z = 1 - radius; z < radius; ++z) {
                p.add(new class_1923(start.field_9181 + x, start.field_9180 + z));
            }
        }
        return p.build();
    }

    public static void addLoadedChunk(LiveBlock live, int radius) {
        List chunks = FORCE_LOAD_CHUNKS.computeIfAbsent(live.level, k -> new LinkedList());
        LiveBlockManager.chunksWithRadius(live.chunkPos, radius).forEach((? super T cPos) -> {
            Optional<ChunkPosCounter> pos = chunks.stream().filter(c -> c.equals(cPos)).findAny();
            if (pos.isEmpty()) {
                chunks.add(new ChunkPosCounter((class_1923)cPos));
                LiveBlockManager.addTicket(live.level, cPos);
            } else {
                pos.get().inc();
            }
        });
    }

    private static void addTicket(class_1937 level, class_1923 cPos) {
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            Wunderreich.LOGGER.info("Keep Chunk " + cPos + " in " + level.method_27983().method_29177() + " permanently loaded");
            server.method_14178().field_17254.method_17263().method_17291(TICKET, cPos, 2, (Object)cPos);
        }
    }

    public static void removeLoadedChunk(LiveBlock live, int radius) {
        List chunks = FORCE_LOAD_CHUNKS.computeIfAbsent(live.level, k -> new LinkedList());
        LiveBlockManager.chunksWithRadius(live.chunkPos, radius).forEach((? super T cPos) -> {
            Optional<ChunkPosCounter> pos = chunks.stream().filter(c -> c.equals(cPos)).findAny();
            if (pos.isPresent() && pos.get().dec() == 0) {
                chunks.remove(cPos);
                LiveBlockManager.removeTicket(live.level, cPos);
            }
        });
    }

    private static void removeTicket(class_1937 level, class_1923 cPos) {
        if (level instanceof class_3218) {
            class_3218 server = (class_3218)level;
            Wunderreich.LOGGER.info("Remove Chunk " + cPos + " in " + level.method_27983().method_29177() + " from force loaded list");
            server.method_14178().field_17254.method_17263().method_17292(TICKET, cPos, 2, (Object)cPos);
        }
    }

    public void rebuildLoadedChunks() {
        for (Map.Entry<class_1937, List<ChunkPosCounter>> e : FORCE_LOAD_CHUNKS.entrySet()) {
            for (ChunkPosCounter cPos : e.getValue()) {
                LiveBlockManager.removeTicket(e.getKey(), cPos);
            }
        }
        FORCE_LOAD_CHUNKS.clear();
        for (LiveBlock live : this.liveBlocks) {
            LiveBlockManager.addLoadedChunk(live, WunderreichRules.Wunderkiste.chunkLoaderDist());
        }
    }

    public boolean shouldTick(class_3218 level) {
        return FORCE_LOAD_CHUNKS.containsKey(level);
    }

    public boolean shouldTick(class_3218 level, class_2338 pos) {
        class_1923 cPos = new class_1923(pos);
        return this.shouldTick(level, cPos);
    }

    public boolean shouldTick(class_3218 level, class_1923 cPos) {
        List chunks = FORCE_LOAD_CHUNKS.computeIfAbsent((class_1937)level, k -> new LinkedList());
        return chunks.contains(cPos);
    }

    public static class LiveBlock {
        public static final Codec<LiveBlock> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(o -> o.pos), (App)class_1937.field_25178.fieldOf("level").forGetter(o -> o.key)).apply((Applicative)instance, LiveBlock::new));
        public final class_2338 pos;
        public final class_1923 chunkPos;
        public final class_5321<class_1937> key;
        private class_1937 level;

        public LiveBlock(class_2338 pos, class_1937 level) {
            this(pos, (class_5321<class_1937>)level.method_27983());
            this.level = level;
        }

        private LiveBlock(class_2338 pos, class_5321<class_1937> key) {
            this.pos = pos;
            this.key = key;
            this.chunkPos = new class_1923(pos);
        }

        void loadLevel(Map<class_5321<class_1937>, class_3218> levels) {
            if (this.level == null) {
                this.level = (class_1937)levels.get(this.key);
                LiveBlockManager.addLoadedChunk(this, WunderreichRules.Wunderkiste.chunkLoaderDist());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LiveBlock liveBlock = (LiveBlock)o;
            return this.pos.equals((Object)liveBlock.pos) && this.key.equals(liveBlock.key);
        }

        public int hashCode() {
            return this.pos.hashCode() + this.key.hashCode();
        }

        public String toString() {
            return this.key + " (" + this.pos.method_10263() + ", " + this.pos.method_10264() + ", " + this.pos.method_10260() + ")";
        }

        public class_1937 getLevel() {
            return this.level;
        }
    }

    private static class ChunkPosCounter
    extends class_1923 {
        public final AtomicInteger count = new AtomicInteger(1);

        private ChunkPosCounter(class_1923 chunkPos) {
            super(chunkPos.field_9181, chunkPos.field_9180);
        }

        public void inc() {
            this.count.incrementAndGet();
        }

        public int dec() {
            return this.count.decrementAndGet();
        }

        public boolean equals(Object object) {
            return super.equals(object);
        }
    }

    @FunctionalInterface
    public static interface ChangeEvent {
        public void emit(LiveBlock var1);
    }
}

