/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.config.Configs;
import de.ambertation.wunderreich.interfaces.CanDropLoot;
import de.ambertation.wunderreich.loot.AlternativeEntries;
import de.ambertation.wunderreich.loot.Enchantment;
import de.ambertation.wunderreich.loot.EnchantmentPredicate;
import de.ambertation.wunderreich.loot.Entry;
import de.ambertation.wunderreich.loot.EntryList;
import de.ambertation.wunderreich.loot.EntryPool;
import de.ambertation.wunderreich.loot.ExplosionDecayFunction;
import de.ambertation.wunderreich.loot.MatchToolCondition;
import de.ambertation.wunderreich.loot.SetCountFunction;
import de.ambertation.wunderreich.loot.SurviveExplosionCondition;
import de.ambertation.wunderreich.registries.WunderreichBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class LootTableJsonBuilder {
    public final class_2960 ID;
    public final class_2960 sourceID;
    private final LootTypes type;
    private final List<EntryPool> pools = new ArrayList<EntryPool>(1);

    private LootTableJsonBuilder(class_2960 sourceID, LootTypes type) {
        this.sourceID = sourceID;
        this.ID = type == LootTypes.BLOCK ? new class_2960(sourceID.method_12836(), "blocks/" + sourceID.method_12832()) : sourceID;
        this.type = type;
    }

    public static Stream<Helper> getAllBlocks() {
        return WunderreichBlocks.getAllBlocks().stream().filter(bl -> bl instanceof CanDropLoot).filter(Configs.BLOCK_CONFIG::isEnabled).map(bl -> {
            LootTableJsonBuilder l = ((CanDropLoot)bl).buildLootTable();
            return new Helper(l.ID, l::build);
        });
    }

    public static LootTableJsonBuilder create(class_2248 bl) {
        return new LootTableJsonBuilder(class_7923.field_41175.method_10221((Object)bl), LootTypes.BLOCK);
    }

    public static LootTableJsonBuilder create(String name, LootTypes type) {
        return new LootTableJsonBuilder(Wunderreich.ID(name), type);
    }

    public LootTableJsonBuilder dropSelf(boolean silkTouch) {
        return this.startPool(1.0, 0.0, builder -> builder.survivesExplosion().startSelfEntry(e -> {
            if (silkTouch) {
                e.silkTouch();
            }
        }));
    }

    public LootTableJsonBuilder dropSelfSlab(boolean silkTouch) {
        return this.startPool(1.0, 0.0, builder -> builder.survivesExplosion().startSelfEntry(e -> {
            if (silkTouch) {
                e.silkTouch();
            }
            e.entry.addCountForStateFunction(2, false, class_2482.field_11501, class_2771.field_12682);
        }));
    }

    public LootTableJsonBuilder startPool(double rolls, double bonusRolls, Consumer<PoolBuilder> builder) {
        PoolBuilder res = new PoolBuilder(this, new EntryPool(rolls, bonusRolls));
        this.pools.add((EntryPool)res.container);
        builder.accept(res);
        return this;
    }

    protected String getLootType() {
        if (this.type == LootTypes.BLOCK) {
            return "minecraft:block";
        }
        return null;
    }

    public JsonElement build() {
        String tt = this.getLootType();
        if (tt == null) {
            throw new IllegalStateException("A LootTable needs a Type (" + this.ID + ")");
        }
        JsonObject root = new JsonObject();
        root.add("type", (JsonElement)new JsonPrimitive(tt));
        JsonArray f = new JsonArray();
        this.pools.stream().map(EntryPool::serialize).forEach(arg_0 -> ((JsonArray)f).add(arg_0));
        root.add("pools", (JsonElement)f);
        return root;
    }

    public static enum LootTypes {
        UNKNOWN,
        BLOCK;

    }

    public static final class PoolBuilder
    extends EntryListBuilder<EntryPool, PoolBuilder> {
        public PoolBuilder(LootTableJsonBuilder base, EntryPool pool) {
            super(base, pool);
        }

        @Override
        protected EntryBuilder makeEntryBuilder(Entry e) {
            return new EntryBuilder<PoolBuilder>(this.base, this, e);
        }

        public PoolBuilder survivesExplosion() {
            ((EntryPool)this.container).conditions.add(new SurviveExplosionCondition());
            return this;
        }

        public PoolBuilder startAlternatives(Consumer<AlternativeEntryBuilder> builder) {
            AlternativeEntries alt = new AlternativeEntries();
            AlternativeEntryBuilder res = new AlternativeEntryBuilder(this.base, alt);
            ((EntryPool)this.container).addEntry(alt);
            builder.accept(res);
            return this;
        }
    }

    public static abstract class EntryListBuilder<T extends EntryList, ME extends EntryListBuilder> {
        protected final LootTableJsonBuilder base;
        protected final T container;

        public EntryListBuilder(LootTableJsonBuilder base, T container) {
            this.base = base;
            this.container = container;
        }

        public ME addSelfEntry() {
            return this.startSelfEntry(b -> {});
        }

        public ME startSelfEntry(Consumer<EntryBuilder<ME>> builder) {
            return this.startEntry("minecraft:item", this.base.sourceID.toString(), builder);
        }

        public ME startItemEntry(class_1792 itm, Consumer<EntryBuilder<ME>> builder) {
            class_2960 id = class_7923.field_41178.method_10221((Object)itm);
            return this.startEntry("minecraft:item", id != null ? id.toString() : "", builder);
        }

        public ME startItemEntry(String name, Consumer<EntryBuilder<ME>> builder) {
            return this.startEntry("minecraft:item", name, builder);
        }

        protected abstract EntryBuilder<ME> makeEntryBuilder(Entry var1);

        public ME startEntry(String type, String name, Consumer<EntryBuilder<ME>> builder) {
            Entry e = new Entry(type, name);
            this.container.addEntry(e);
            builder.accept(this.makeEntryBuilder(e));
            return (ME)this;
        }
    }

    public static class EntryBuilder<P extends EntryListBuilder> {
        private final LootTableJsonBuilder base;
        private final P builder;
        private final Entry entry;

        public EntryBuilder(LootTableJsonBuilder base, P builder, Entry entry) {
            this.base = base;
            this.builder = builder;
            this.entry = entry;
        }

        public P finishEntry() {
            return this.builder;
        }

        public EntryBuilder<P> explosionDecay() {
            this.entry.addFunction(new ExplosionDecayFunction());
            return this;
        }

        public EntryBuilder<P> setCount(int count, boolean add) {
            this.entry.addFunction(new SetCountFunction(count, add));
            return this;
        }

        public EntryBuilder<P> silkTouch() {
            return this.enchantedTool(class_1893.field_9099, 1);
        }

        public EntryBuilder<P> enchantedTool(class_1887 e, int minLevel) {
            class_2960 id = class_7923.field_41176.method_10221((Object)e);
            if (id != null) {
                EnchantmentPredicate predicate = new EnchantmentPredicate();
                predicate.addEnchantment(new Enchantment(id.toString(), minLevel));
                this.entry.addCondition(new MatchToolCondition(predicate));
            } else {
                Wunderreich.LOGGER.warn("Unknown Enchantment '{}' in Loot Table '{}'", e.toString(), this.base.ID);
            }
            return this;
        }
    }

    public record Helper(class_2960 id, Supplier<JsonElement> json) {
    }

    public static final class AlternativeEntryBuilder
    extends EntryListBuilder<AlternativeEntries, AlternativeEntryBuilder> {
        public AlternativeEntryBuilder(LootTableJsonBuilder base, AlternativeEntries alt) {
            super(base, alt);
        }

        @Override
        protected EntryBuilder makeEntryBuilder(Entry e) {
            return new EntryBuilder<AlternativeEntryBuilder>(this.base, this, e);
        }
    }
}

