/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderreich.gui.construction;

import de.ambertation.wunderlib.math.sdf.SDF;
import de.ambertation.wunderlib.math.sdf.interfaces.Rotatable;
import de.ambertation.wunderlib.ui.layout.components.Button;
import de.ambertation.wunderlib.ui.layout.components.Container;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.Image;
import de.ambertation.wunderlib.ui.layout.components.ImageButton;
import de.ambertation.wunderlib.ui.layout.components.Item;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.Panel;
import de.ambertation.wunderlib.ui.layout.components.Text;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.components.render.RenderHelper;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Size;
import de.ambertation.wunderlib.ui.layout.values.Value;
import de.ambertation.wunderreich.Wunderreich;
import de.ambertation.wunderreich.gui.construction.RulerContainerMenu;
import de.ambertation.wunderreich.items.construction.BluePrintData;
import de.ambertation.wunderreich.network.ChangedSDFMessage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class RulerScreen
extends class_465<RulerContainerMenu> {
    public static final class_2960 SDF_TEXTURE = Wunderreich.ID("textures/gui/sdf.png");
    public static final Size SDF_TEXTURE_SIZE = new Size(256, 256);
    public static final Rectangle SMALL_DIAMOND = new Rectangle(77, 30, 15, 15);
    public static final Rectangle LARGE_DIAMOND = new Rectangle(95, 31, 33, 33);
    public static final Rectangle INVENTORY_SLOT = new Rectangle(129, 0, 17, 17);
    public static final Rectangle ROT_Y_CW = new Rectangle(76, 0, 13, 17);
    public static final Rectangle ROT_Y_CCW = new Rectangle(89, 0, 13, 17);
    public static final Rectangle ROT_X_CW = new Rectangle(102, 0, 13, 15);
    public static final Rectangle ROT_X_CCW = new Rectangle(115, 0, 13, 15);
    public static final Rectangle ROT_Z_CW = new Rectangle(76, 17, 17, 13);
    public static final Rectangle ROT_Z_CCW = new Rectangle(93, 17, 17, 13);
    private final RulerContainerMenu menu;
    Text materialText;
    Item materialItem;
    Button btSelectMat;
    private Button btSelectParent;
    private Button btSelectInputB;
    private Button btSelectInputA;
    private Item parentStack;
    private ImageButton rotY_CCW;
    private ImageButton rotY_CW;
    Button selectedPageButton;

    public RulerScreen(RulerContainerMenu menu, class_1661 inventory, class_2561 component) {
        super((class_1703)menu, inventory, component);
        this.menu = menu;
        this.field_2792 = 427;
        this.field_2779 = 240;
    }

    protected void method_25426() {
        super.method_25426();
        this.field_25269 = 1000;
        this.field_25267 = 1000;
        Panel inventoryPanel = this.createInventoryPanel();
        this.method_37063((class_364)inventoryPanel);
        Panel materialPanel = this.createMaterialPanel();
        this.method_37063((class_364)materialPanel);
        Panel sdfPanel = this.createSDFPanel();
        this.method_37063((class_364)sdfPanel);
        Panel widgetPanel = this.createWidgetPanel();
        this.method_37063((class_364)widgetPanel);
        this.updateSDFDisplay();
    }

    private Panel createMaterialPanel() {
        Panel materialPanel = new Panel(RulerContainerMenu.MATERIAL_PANEL);
        Container materialContainer = new Container(Value.fit(), Value.fit());
        Image inventoryBackground = new Image(Value.fit(), Value.fit(), SDF_TEXTURE).setResourceSize(SDF_TEXTURE_SIZE).setUvRect(79, 197, 177, 59);
        materialContainer.addChild((LayoutComponent)inventoryBackground);
        VerticalStack materialStack = new VerticalStack(Value.fill(), Value.fit());
        materialStack.indent(6).addText(Value.fit(), Value.fit(), (class_2561)class_2561.method_43470((String)"Materialgruppe"));
        materialStack.addSpacer(-9);
        materialStack.add((LayoutComponent)materialContainer);
        HorizontalStack buttonRow = materialStack.addRow().addSpacer(16);
        for (int i = 0; i < 8; ++i) {
            int finalI = i;
            Button b = (Button)buttonRow.addButton(Value.fixed((int)18), Value.fit(), (class_2561)class_2561.method_43470((String)("" + (i + 1)))).onPress(bt -> {
                if (this.selectedPageButton != null) {
                    this.selectedPageButton.setAlpha(0.5f);
                }
                this.menu.container.setActivePage(finalI);
                this.selectedPageButton = bt;
                if (this.selectedPageButton != null) {
                    this.selectedPageButton.setAlpha(1.0f);
                }
            }).setAlpha(i == 0 ? 1.0f : 0.5f);
            if (i != 0) continue;
            this.selectedPageButton = b;
        }
        materialPanel.setChild((LayoutComponent)materialStack);
        materialPanel.calculateLayout();
        return materialPanel;
    }

    private Panel createInventoryPanel() {
        Panel inventoryPanel = new Panel(RulerContainerMenu.INVENTORY_PANEL);
        Container inventoryContainer = new Container(Value.fit(), Value.fit());
        Image inventoryBackground = new Image(Value.fit(), Value.fit(), SDF_TEXTURE).setResourceSize(SDF_TEXTURE_SIZE).setUvRect(83, 110, 173, 87);
        inventoryContainer.addChild((LayoutComponent)inventoryBackground);
        VerticalStack inventoryStack = new VerticalStack(Value.fill(), Value.fit());
        inventoryStack.addFiller();
        inventoryStack.indent(5).addText(Value.fit(), Value.fit(), (class_2561)class_2561.method_43470((String)"Inventory"));
        inventoryStack.add((LayoutComponent)inventoryContainer);
        inventoryPanel.setChild((LayoutComponent)inventoryStack);
        inventoryPanel.calculateLayout();
        return inventoryPanel;
    }

    private Panel createWidgetPanel() {
        Panel panel = new Panel(RulerContainerMenu.WIDGET_PANEL);
        Container container = new Container(Value.fit(), Value.fit());
        this.rotY_CW = new ImageButton(Value.fit(), Value.fit(), SDF_TEXTURE).setResourceSize(SDF_TEXTURE_SIZE).setUvRect(ROT_Y_CW).onPress(bt -> {
            SDF patt6028$temp = this.menu.sdfSlot.getActiveSdf();
            if (patt6028$temp instanceof Rotatable) {
                Rotatable rot = (Rotatable)patt6028$temp;
                rot.rotate(Math.toRadians(15.0));
                ChangedSDFMessage.INSTANCE.sendTransform(this.menu, rot.getRoot().getLocalTransform());
                this.menu.data.SDF_DATA.set(rot.getRoot());
            }
        });
        container.addChild(20, 10, (LayoutComponent)this.rotY_CW);
        this.rotY_CCW = new ImageButton(Value.fit(), Value.fit(), SDF_TEXTURE).setResourceSize(SDF_TEXTURE_SIZE).setUvRect(ROT_Y_CCW).onPress(bt -> {
            SDF patt6618$temp = this.menu.sdfSlot.getActiveSdf();
            if (patt6618$temp instanceof Rotatable) {
                Rotatable rot = (Rotatable)patt6618$temp;
                rot.rotate(Math.toRadians(-15.0));
                ChangedSDFMessage.INSTANCE.sendTransform(this.menu, rot.getRoot().getLocalTransform());
                this.menu.data.SDF_DATA.set(rot.getRoot());
            }
        });
        container.addChild(40, 10, (LayoutComponent)this.rotY_CCW);
        panel.setChild((LayoutComponent)container);
        panel.calculateLayout();
        return panel;
    }

    private Panel createSDFPanel() {
        Panel inventoryPanel = new Panel(RulerContainerMenu.SDF_PANEL);
        Container inventoryContainer = new Container(Value.fit(), Value.fit());
        this.materialText = (Text)new Text(Value.fixed((int)RulerScreen.INVENTORY_SLOT.width), Value.fixed((int)RulerScreen.INVENTORY_SLOT.height), (class_2561)class_2561.method_43470((String)"-")).alignTop();
        this.materialItem = new Item(Value.fit(), Value.fit()).setItem(class_1799.field_8037);
        Button btRealize = new Button(Value.fit(), Value.fit(), (class_2561)class_2561.method_43470((String)"Realize")).onPress(bt -> ChangedSDFMessage.INSTANCE.sendRealize(this.menu));
        inventoryContainer.addChild(0, 70, (LayoutComponent)btRealize);
        this.btSelectInputA = new Button(Value.fixed((int)18), Value.fit(), (class_2561)class_2561.method_43470((String)"A")).onPress(bt -> {
            this.menu.sdfSlot.selectInput(0);
            this.updateSDFDisplay();
        });
        inventoryContainer.addChild(0, 0, (LayoutComponent)this.btSelectInputA);
        Image inputSlotA = new Image(Value.fit(), Value.fit(), SDF_TEXTURE).setResourceSize(SDF_TEXTURE_SIZE).setUvRect(SMALL_DIAMOND);
        inventoryContainer.addChild(0, 8, (LayoutComponent)inputSlotA);
        this.btSelectInputB = new Button(Value.fixed((int)18), Value.fit(), (class_2561)class_2561.method_43470((String)"B")).onPress(bt -> {
            this.menu.sdfSlot.selectInput(1);
            this.updateSDFDisplay();
        });
        inventoryContainer.addChild(0, 47, (LayoutComponent)this.btSelectInputB);
        Image inputSlotB = new Image(Value.fit(), Value.fit(), SDF_TEXTURE).setResourceSize(SDF_TEXTURE_SIZE).setUvRect(SMALL_DIAMOND);
        inventoryContainer.addChild(0, 32, (LayoutComponent)inputSlotB);
        this.btSelectParent = new Button(Value.fixed((int)18), Value.fit(), (class_2561)class_2561.method_43470((String)"P")).onPress(bt -> {
            this.menu.sdfSlot.selectParent();
            this.updateSDFDisplay();
        });
        inventoryContainer.addChild(47, 20, (LayoutComponent)this.btSelectParent);
        Image parentSlot = new Image(Value.fit(), Value.fit(), SDF_TEXTURE).setResourceSize(SDF_TEXTURE_SIZE).setUvRect(SMALL_DIAMOND);
        inventoryContainer.addChild(36, 20, (LayoutComponent)parentSlot);
        this.parentStack = new Item(Value.fit(), Value.fit()).setItem(class_1799.field_8037);
        inventoryContainer.addChild(36, 20, (LayoutComponent)this.parentStack);
        Image SDFSlot2 = new Image(Value.fit(), Value.fit(), SDF_TEXTURE).setResourceSize(SDF_TEXTURE_SIZE).setUvRect(LARGE_DIAMOND);
        inventoryContainer.addChild(3, 11, (LayoutComponent)SDFSlot2);
        inventoryContainer.addChild(27, 0, (LayoutComponent)this.materialItem);
        this.btSelectMat = new Button(Value.fixed((int)18), Value.fit(), (class_2561)class_2561.method_43470((String)"M")).onPress(bt -> this.updateMaterialDisplay(this.menu.sdfSlot.selectNextMaterialOnClient()));
        inventoryContainer.addChild(42, 0, (LayoutComponent)this.btSelectMat);
        Button btDebug = new Button(Value.fit(), Value.fit(), (class_2561)class_2561.method_43470((String)"D")).onPress(this::debugPressed);
        inventoryContainer.addChild(47, 44, (LayoutComponent)btDebug);
        inventoryPanel.setChild((LayoutComponent)inventoryContainer);
        inventoryPanel.calculateLayout();
        this.menu.sdfSlot.setOnActiveGraphIndexChange(this::activeGraphIndexChanged);
        this.menu.sdfSlot.setOnChangedContent(this::changedSlotContents);
        return inventoryPanel;
    }

    private void debugPressed(Button bt) {
        this.menu.sdfSlot.printDebugInfo();
    }

    private void updateSDFDisplay() {
        this.updateMaterialDisplay(this.menu.sdfSlot.getMaterialIndex());
        SDF active = this.menu.sdfSlot.getActiveSdf();
        this.btSelectParent.setEnabled(active != null && active.getParent() != null);
        this.btSelectInputA.setEnabled(active != null && active.getInputSlotCount() > 0);
        this.btSelectInputB.setEnabled(active != null && active.getInputSlotCount() > 1);
        if (this.btSelectParent.isEnabled()) {
            this.parentStack.setItem(BluePrintData.bluePrintWithSDF(active.getParent()));
        } else {
            this.parentStack.setItem(class_1799.field_8037);
        }
        if (this.rotY_CW != null) {
            this.rotY_CW.setEnabled(active instanceof Rotatable);
        }
        if (this.rotY_CCW != null) {
            this.rotY_CCW.setEnabled(active instanceof Rotatable);
        }
    }

    private void changedSlotContents() {
        this.updateSDFDisplay();
    }

    private void updateMaterialDisplay(int mIdx) {
        if (mIdx < 0 || mIdx >= 8) {
            this.materialItem.setItem(class_1799.field_8037);
            this.materialItem.setDecoration("");
            if (this.btSelectMat != null) {
                this.btSelectMat.setEnabled(false);
            }
        } else {
            this.materialItem.setItem(this.menu.container.getPageItem(mIdx, 0));
            this.materialItem.setDecoration("" + (mIdx + 1));
            if (this.btSelectMat != null) {
                this.btSelectMat.setEnabled(true);
            }
        }
    }

    void activeGraphIndexChanged(int activeGraphIndex) {
        ChangedSDFMessage.INSTANCE.sendActive(this.menu, activeGraphIndex);
    }

    protected void method_2389(class_332 guiGraphics, float deltaTime, int mouseX, int mouseY) {
        guiGraphics.method_25294(0, 0, this.field_22789, this.field_22790, -400284636);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float f) {
        super.method_25394(guiGraphics, mouseX, mouseY, f);
        if (this.selectedPageButton != null) {
            RenderHelper.renderImage((class_332)guiGraphics, (int)this.selectedPageButton.getScreenBounds().left, (int)(this.selectedPageButton.getScreenBounds().top - 4), (class_2960)SDF_TEXTURE, (Size)SDF_TEXTURE_SIZE, (Rectangle)new Rectangle(126, 18, 17, 3), (float)1.0f);
        }
        this.method_2380(guiGraphics, mouseX, mouseY);
    }
}

