/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.condition;

import com.almostreliable.lootjs.core.ILootContextData;
import com.almostreliable.lootjs.core.LootJSParamSets;
import com.almostreliable.lootjs.loot.condition.IExtendedLootCondition;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_47;

public class ContainsLootCondition
implements IExtendedLootCondition {
    private final Predicate<class_1799> predicate;
    private final boolean exact;

    public ContainsLootCondition(Predicate<class_1799> predicate, boolean exact) {
        this.predicate = predicate;
        this.exact = exact;
    }

    @Override
    public boolean applyLootHandler(class_47 context, List<class_1799> loot) {
        return this.exact ? this.matchExact(loot) : this.match(loot);
    }

    @Override
    public boolean test(class_47 context) {
        ILootContextData data = (ILootContextData)context.method_296(LootJSParamSets.DATA);
        if (data == null) {
            return false;
        }
        return this.applyLootHandler(context, data.getGeneratedLoot());
    }

    private boolean match(List<class_1799> generatedLoot) {
        for (class_1799 itemStack : generatedLoot) {
            if (!this.predicate.test(itemStack)) continue;
            return true;
        }
        return false;
    }

    private boolean matchExact(List<class_1799> generatedLoot) {
        for (class_1799 itemStack : generatedLoot) {
            if (this.predicate.test(itemStack)) continue;
            return false;
        }
        return true;
    }
}

