/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.kube;

import com.almostreliable.lootjs.LootJS;
import com.almostreliable.lootjs.core.ILootCondition;
import com.almostreliable.lootjs.filters.ItemFilter;
import com.almostreliable.lootjs.filters.Resolver;
import com.almostreliable.lootjs.kube.builder.DamageSourcePredicateBuilderJS;
import com.almostreliable.lootjs.kube.builder.EntityPredicateBuilderJS;
import com.almostreliable.lootjs.loot.condition.AndCondition;
import com.almostreliable.lootjs.loot.condition.AnyBiomeCheck;
import com.almostreliable.lootjs.loot.condition.AnyDimension;
import com.almostreliable.lootjs.loot.condition.AnyStructure;
import com.almostreliable.lootjs.loot.condition.BiomeCheck;
import com.almostreliable.lootjs.loot.condition.ContainsLootCondition;
import com.almostreliable.lootjs.loot.condition.CustomParamPredicate;
import com.almostreliable.lootjs.loot.condition.IsLightLevel;
import com.almostreliable.lootjs.loot.condition.MainHandTableBonus;
import com.almostreliable.lootjs.loot.condition.MatchEquipmentSlot;
import com.almostreliable.lootjs.loot.condition.MatchKillerDistance;
import com.almostreliable.lootjs.loot.condition.MatchPlayer;
import com.almostreliable.lootjs.loot.condition.NotCondition;
import com.almostreliable.lootjs.loot.condition.OrCondition;
import com.almostreliable.lootjs.loot.condition.PlayerParamPredicate;
import com.almostreliable.lootjs.loot.condition.builder.DistancePredicateBuilder;
import com.almostreliable.lootjs.util.Utils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.stages.Stages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_181;
import net.minecraft.class_1887;
import net.minecraft.class_1959;
import net.minecraft.class_201;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_212;
import net.minecraft.class_215;
import net.minecraft.class_219;
import net.minecraft.class_221;
import net.minecraft.class_2248;
import net.minecraft.class_225;
import net.minecraft.class_227;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_42;
import net.minecraft.class_4559;
import net.minecraft.class_4571;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public interface LootConditionsContainer<B extends LootConditionsContainer<?>> {
    default public B matchLoot(ItemFilter filter) {
        return this.matchLoot(filter, false);
    }

    default public B matchLoot(ItemFilter filter, boolean exact) {
        return this.addCondition(new ContainsLootCondition(filter, exact));
    }

    default public B matchMainHand(ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(class_1304.field_6173, filter));
    }

    default public B matchOffHand(ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(class_1304.field_6171, filter));
    }

    default public B matchEquip(class_1304 slot, ItemFilter filter) {
        return this.addCondition(new MatchEquipmentSlot(slot, filter));
    }

    default public B survivesExplosion() {
        return this.addCondition(class_201.method_871());
    }

    default public B timeCheck(long period, int min, int max) {
        return this.addCondition((class_5341.class_210)new class_4571.class_6164(class_42.method_282((int)min, (int)max)).method_35560(period));
    }

    default public B timeCheck(int min, int max) {
        return this.timeCheck(24000L, min, max);
    }

    default public B weatherCheck(Map<String, Boolean> map) {
        Boolean isRaining = map.getOrDefault("raining", null);
        Boolean isThundering = map.getOrDefault("thundering", null);
        return this.addCondition((class_5341.class_210)new class_227.class_6165().method_35565(isRaining).method_35567(isThundering));
    }

    default public B randomChance(float value) {
        return this.addCondition(class_219.method_932((float)value));
    }

    default public B randomChanceWithLooting(float value, float looting) {
        return this.addCondition(class_225.method_953((float)value, (float)looting));
    }

    default public B randomChanceWithEnchantment(@Nullable class_1887 enchantment, float[] chances) {
        if (enchantment == null) {
            throw new IllegalArgumentException("Enchant not found");
        }
        return this.addCondition(new MainHandTableBonus(enchantment, chances));
    }

    default public B biome(Resolver ... resolvers) {
        ArrayList<class_5321<class_1959>> biomes = new ArrayList<class_5321<class_1959>>();
        ArrayList<class_6862<class_1959>> tagKeys = new ArrayList<class_6862<class_1959>>();
        for (Resolver resolver : resolvers) {
            if (resolver instanceof Resolver.ByEntry) {
                Resolver.ByEntry byEntry = (Resolver.ByEntry)resolver;
                biomes.add(byEntry.resolve(class_7924.field_41236));
                continue;
            }
            if (!(resolver instanceof Resolver.ByTagKey)) continue;
            Resolver.ByTagKey byTagKey = (Resolver.ByTagKey)resolver;
            tagKeys.add(byTagKey.resolve(class_7924.field_41236));
        }
        return this.addCondition(new BiomeCheck(biomes, tagKeys));
    }

    default public B anyBiome(Resolver ... resolvers) {
        ArrayList<class_5321<class_1959>> biomes = new ArrayList<class_5321<class_1959>>();
        ArrayList<class_6862<class_1959>> tagKeys = new ArrayList<class_6862<class_1959>>();
        for (Resolver resolver : resolvers) {
            if (resolver instanceof Resolver.ByEntry) {
                Resolver.ByEntry byEntry = (Resolver.ByEntry)resolver;
                biomes.add(byEntry.resolve(class_7924.field_41236));
                continue;
            }
            if (!(resolver instanceof Resolver.ByTagKey)) continue;
            Resolver.ByTagKey byTagKey = (Resolver.ByTagKey)resolver;
            tagKeys.add(byTagKey.resolve(class_7924.field_41236));
        }
        return this.addCondition(new AnyBiomeCheck(biomes, tagKeys));
    }

    default public B anyDimension(class_2960 ... dimensions) {
        return this.addCondition(new AnyDimension(dimensions));
    }

    default public B anyStructure(String[] idOrTags, boolean exact) {
        AnyStructure.Builder builder = new AnyStructure.Builder();
        for (String s : idOrTags) {
            builder.add(s);
        }
        return this.addCondition(builder.build(exact));
    }

    default public B lightLevel(int min, int max) {
        return this.addCondition(new IsLightLevel(min, max));
    }

    default public B killedByPlayer() {
        return this.addCondition(class_221.method_939());
    }

    default public B matchBlockState(class_2248 block, Map<String, String> propertyMap) {
        class_4559.class_4560 properties = Utils.createProperties(block, propertyMap);
        return this.addCondition((class_5341.class_210)new class_212.class_213(block).method_22584(properties));
    }

    default public B matchFluid(Resolver resolver) {
        throw new UnsupportedOperationException("Not implemented in 1.18.2 currently.");
    }

    default public B matchEntity(Consumer<EntityPredicateBuilderJS> action) {
        EntityPredicateBuilderJS builder = new EntityPredicateBuilderJS();
        action.accept(builder);
        return this.addCondition(class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)builder.build()));
    }

    default public B matchKiller(Consumer<EntityPredicateBuilderJS> action) {
        EntityPredicateBuilderJS builder = new EntityPredicateBuilderJS();
        action.accept(builder);
        return this.addCondition(class_215.method_27865((class_47.class_50)class_47.class_50.field_936, (class_2048)builder.build()));
    }

    default public B matchDirectKiller(Consumer<EntityPredicateBuilderJS> action) {
        EntityPredicateBuilderJS builder = new EntityPredicateBuilderJS();
        action.accept(builder);
        return this.addCondition(class_215.method_27865((class_47.class_50)class_47.class_50.field_939, (class_2048)builder.build()));
    }

    default public B matchPlayer(Consumer<EntityPredicateBuilderJS> action) {
        EntityPredicateBuilderJS builder = new EntityPredicateBuilderJS();
        action.accept(builder);
        return this.addCondition(new MatchPlayer(builder.build()));
    }

    default public B matchDamageSource(Consumer<DamageSourcePredicateBuilderJS> action) {
        DamageSourcePredicateBuilderJS builder = new DamageSourcePredicateBuilderJS();
        action.accept(builder);
        return this.addCondition(builder);
    }

    default public B distanceToKiller(class_2096.class_2099 bounds) {
        return this.customDistanceToPlayer(builder -> builder.absolute(bounds));
    }

    default public B customDistanceToPlayer(Consumer<DistancePredicateBuilder> action) {
        DistancePredicateBuilder builder = new DistancePredicateBuilder();
        action.accept(builder);
        return this.addCondition(new MatchKillerDistance(builder.build()));
    }

    default public B playerPredicate(Predicate<class_3222> predicate) {
        return this.addCondition(new PlayerParamPredicate(predicate));
    }

    default public B entityPredicate(Predicate<class_1297> predicate) {
        return this.addCondition(new CustomParamPredicate<class_1297>(class_181.field_1226, predicate));
    }

    default public B killerPredicate(Predicate<class_1297> predicate) {
        return this.addCondition(new CustomParamPredicate<class_1297>(class_181.field_1230, predicate));
    }

    default public B directKillerPredicate(Predicate<class_1297> predicate) {
        return this.addCondition(new CustomParamPredicate<class_1297>(class_181.field_1227, predicate));
    }

    default public B blockEntityPredicate(Predicate<class_2586> predicate) {
        return this.addCondition(new CustomParamPredicate<class_2586>(class_181.field_1228, predicate));
    }

    default public B hasAnyStage(String ... stages) {
        if (stages.length == 1) {
            String stage = stages[0];
            return this.addCondition(new PlayerParamPredicate(player -> Stages.get((class_1657)player).has(stage)));
        }
        return this.addCondition(new PlayerParamPredicate(player -> {
            for (String stage : stages) {
                if (!Stages.get((class_1657)player).has(stage)) continue;
                return true;
            }
            return false;
        }));
    }

    default public B not(Consumer<LootConditionsContainer<B>> action) {
        List<ILootCondition> conditions = this.createConditions(action);
        if (conditions.size() != 1) {
            throw new IllegalArgumentException("You only can have one condition for `not`");
        }
        NotCondition condition = new NotCondition(conditions.get(0));
        return this.addCondition(condition);
    }

    default public B or(Consumer<LootConditionsContainer<B>> action) {
        List<ILootCondition> conditions = this.createConditions(action);
        ILootCondition[] array = conditions.toArray(new ILootCondition[0]);
        return this.addCondition(new OrCondition(array));
    }

    default public B and(Consumer<LootConditionsContainer<B>> action) {
        List<ILootCondition> conditions = this.createConditions(action);
        ILootCondition[] array = conditions.toArray(new ILootCondition[0]);
        return this.addCondition(new AndCondition(array));
    }

    default public List<ILootCondition> createConditions(Consumer<LootConditionsContainer<B>> action) {
        final ArrayList<ILootCondition> conditions = new ArrayList<ILootCondition>();
        LootConditionsContainer container = new LootConditionsContainer<B>(){

            @Override
            public B addCondition(ILootCondition condition) {
                conditions.add(condition);
                return this;
            }
        };
        action.accept(container);
        return conditions;
    }

    default public B customCondition(JsonObject json) {
        class_5341 condition = (class_5341)LootJS.CONDITION_GSON.fromJson((JsonElement)json, class_5341.class);
        return this.addCondition((ILootCondition)condition);
    }

    default public B addCondition(class_5341.class_210 builder) {
        return this.addCondition((ILootCondition)builder.build());
    }

    public B addCondition(ILootCondition var1);
}

