/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.portable_crafting;

import folk.sisby.portable_crafting.PortableCraftingConfig;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1706;
import net.minecraft.class_1714;
import net.minecraft.class_1726;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3803;
import net.minecraft.class_3908;
import net.minecraft.class_3910;
import net.minecraft.class_3914;
import net.minecraft.class_3971;
import net.minecraft.class_4862;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_747;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortableCrafting
implements ModInitializer {
    public static final String ID = "portable_crafting";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"portable_crafting");
    public static final PortableCraftingConfig CONFIG = (PortableCraftingConfig)PortableCraftingConfig.createToml((Path)FabricLoader.getInstance().getConfigDir(), (String)"", (String)"portable_crafting", PortableCraftingConfig.class);
    public static final Map<class_6862<class_1792>, class_3908> SCREEN_FACTORIES = new HashMap<class_6862<class_1792>, class_3908>();
    public static final Map<Class<? extends class_1703>, class_6862<class_1792>> SCREEN_TYPES = new HashMap<Class<? extends class_1703>, class_6862<class_1792>>();
    public static final class_2960 S2C_SCREENS_ENABLED = new class_2960("portable_crafting", "s2c_screens_enabled");
    public static final class_2960 C2S_OPEN_PORTABLE_CRAFTING = new class_2960("portable_crafting", "c2s_open_portable_crafting");
    public static boolean CHANGING_SCREENS;

    public static boolean canUse(class_1657 player) {
        class_6862 tag = SCREEN_TYPES.getOrDefault(player.field_7512.getClass(), null);
        return tag != null && (player.method_31548().method_7382(tag) || player.field_7512.method_34255().method_31573(tag) || player.field_7512.field_7761.stream().anyMatch(s -> s.method_7677().method_31573(tag)));
    }

    public static boolean openPortableCrafting(class_1657 player, class_1799 stack, boolean dry) {
        Optional<class_6862> tag = SCREEN_FACTORIES.keySet().stream().filter(t -> PortableCrafting.CONFIG.screensEnabled.get(t.comp_327().toString())).filter(arg_0 -> ((class_1799)stack).method_31573(arg_0)).findFirst();
        if (tag.isPresent()) {
            if (!dry && player instanceof class_3222) {
                class_3222 spe = (class_3222)player;
                if (tag.get() != SCREEN_TYPES.getOrDefault(player.field_7512.getClass(), null)) {
                    CHANGING_SCREENS = true;
                    spe.method_17355(SCREEN_FACTORIES.get(tag.get()));
                    CHANGING_SCREENS = false;
                }
            }
            return true;
        }
        return false;
    }

    public void onInitialize() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)C2S_OPEN_PORTABLE_CRAFTING, (server, player, handler, buf, sender) -> {
            class_1792 item = class_1792.method_7875((int)buf.method_10816());
            server.execute(() -> {
                if (player.method_31548().method_18862(Set.of(item))) {
                    PortableCrafting.openPortableCrafting((class_1657)player, item.method_7854(), false);
                }
            });
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_2540 buf = PacketByteBufs.create();
            buf.method_34062(PortableCrafting.CONFIG.screensEnabled.keySet().stream().filter(PortableCrafting.CONFIG.screensEnabled::get).toList(), class_2540::method_10814);
            sender.sendPacket(S2C_SCREENS_ENABLED, buf);
        });
        this.registerCraftingScreen(true, (class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("c", "crafting_tables")), class_1714.class, (class_3908)new class_747((i, inv, p) -> new class_1714(i, inv, class_3914.method_17392((class_1937)p.method_37908(), (class_2338)p.method_24515())), (class_2561)class_2561.method_43471((String)"container.crafting")));
        this.registerCraftingScreen(true, (class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("c", "smithing_tables")), class_4862.class, (class_3908)new class_747((i, inv, p) -> new class_4862(i, inv, class_3914.method_17392((class_1937)p.method_37908(), (class_2338)p.method_24515())), (class_2561)class_2561.method_43471((String)"container.upgrade")));
        this.registerCraftingScreen(true, (class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("c", "grindstones")), class_3803.class, (class_3908)new class_747((i, inv, p) -> new class_3803(i, inv, class_3914.method_17392((class_1937)p.method_37908(), (class_2338)p.method_24515())), (class_2561)class_2561.method_43471((String)"container.grindstone_title")));
        this.registerCraftingScreen(true, (class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("c", "cartography_tables")), class_3910.class, (class_3908)new class_747((i, inv, p) -> new class_3910(i, inv, class_3914.method_17392((class_1937)p.method_37908(), (class_2338)p.method_24515())), (class_2561)class_2561.method_43471((String)"container.cartography_table")));
        this.registerCraftingScreen(true, (class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("c", "looms")), class_1726.class, (class_3908)new class_747((i, inv, p) -> new class_1726(i, inv, class_3914.method_17392((class_1937)p.method_37908(), (class_2338)p.method_24515())), (class_2561)class_2561.method_43471((String)"container.loom")));
        this.registerCraftingScreen(true, (class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("c", "stonecutters")), class_3971.class, (class_3908)new class_747((i, inv, p) -> new class_3971(i, inv, class_3914.method_17392((class_1937)p.method_37908(), (class_2338)p.method_24515())), (class_2561)class_2561.method_43471((String)"container.stonecutter")));
        this.registerCraftingScreen(false, (class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("c", "anvils")), class_1706.class, (class_3908)new class_747((i, inv, p) -> new class_1706(i, inv, class_3914.method_17392((class_1937)p.method_37908(), (class_2338)p.method_24515())), (class_2561)class_2561.method_43471((String)"container.repair")));
        LOGGER.info("[Portable Crafting] Initialised!");
    }

    public void registerCraftingScreen(boolean enabled, class_6862<class_1792> tag, Class<? extends class_1703> handler, class_3908 factory) {
        SCREEN_TYPES.put(handler, tag);
        SCREEN_FACTORIES.put(tag, factory);
        PortableCrafting.CONFIG.screensEnabled.putIfAbsent(tag.comp_327().toString(), enabled);
    }
}

