/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1548;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5819;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;
import tech.thatgravyboat.creeperoverhaul.common.utils.PlatformUtils;

public record CreeperType(Function<BaseCreeper, class_2960> texture, Function<BaseCreeper, class_2960> glowingTexture, Function<BaseCreeper, class_2960> chargedTexture, Function<BaseCreeper, class_2960> model, Function<BaseCreeper, class_2960> shearedModel, Function<BaseCreeper, class_2960> animation, int melee, Map<Predicate<class_2680>, Function<class_5819, class_2680>> replacer, Collection<class_1299<?>> entitiesAfraidOf, Collection<class_1293> inflictingPotions, Collection<class_1293> potionsWhenDead, Collection<Class<? extends class_1309>> entities, Collection<class_1282> immunities, class_5132.class_5133 attributes, Supplier<class_1799> shearDrop, Function<BaseCreeper, class_3414> deathSound, Function<BaseCreeper, class_3414> explosionSound, Function<BaseCreeper, class_3414> hitSound, Function<BaseCreeper, class_3414> hurtSound, Function<BaseCreeper, class_3414> primeSound, Function<BaseCreeper, class_3414> swimSound, Function<BaseCreeper, class_3414> flopSound, BooleanSupplier canSpawn) {
    public Optional<class_3414> getDeathSound(BaseCreeper creeper) {
        return Optional.ofNullable(this.deathSound.apply(creeper));
    }

    public Optional<class_3414> getExplosionSound(BaseCreeper creeper) {
        return Optional.ofNullable(this.explosionSound.apply(creeper));
    }

    public Optional<class_3414> getHitSound(BaseCreeper creeper) {
        return Optional.ofNullable(this.hitSound.apply(creeper));
    }

    public Optional<class_3414> getHurtSound(BaseCreeper creeper) {
        return Optional.ofNullable(this.hurtSound.apply(creeper));
    }

    public Optional<class_3414> getPrimeSound(BaseCreeper creeper) {
        return Optional.ofNullable(this.primeSound.apply(creeper));
    }

    public Optional<class_3414> getSwimSound(BaseCreeper creeper) {
        return Optional.ofNullable(this.swimSound.apply(creeper));
    }

    public Optional<class_3414> getFlopSound(BaseCreeper creeper) {
        return Optional.ofNullable(this.flopSound.apply(creeper));
    }

    public boolean isShearable() {
        return this.shearDrop != null;
    }

    public static class Builder {
        private Function<BaseCreeper, class_2960> texture;
        private Function<BaseCreeper, class_2960> glowingTexture;
        private Function<BaseCreeper, class_2960> chargedTexture;
        private Function<BaseCreeper, class_2960> model;
        private Function<BaseCreeper, class_2960> shearedModel;
        private Function<BaseCreeper, class_2960> animation;
        private int melee = 0;
        private final List<class_1299<?>> afraidOf = new ArrayList();
        private final List<class_1293> inflictingPotions = new ArrayList<class_1293>();
        private final List<class_1293> potionsWhenDying = new ArrayList<class_1293>();
        private final List<Class<? extends class_1309>> attackingEntities = new ArrayList<Class<? extends class_1309>>();
        private final List<class_1282> immunities = new ArrayList<class_1282>();
        private final Map<Predicate<class_2680>, Function<class_5819, class_2680>> replacer = new HashMap<Predicate<class_2680>, Function<class_5819, class_2680>>();
        private final class_5132.class_5133 attributes = class_1548.method_26908().method_26868(PlatformUtils.getModAttribute("reach_distance"), 0.0).method_26867(PlatformUtils.getModAttribute("swim_speed"));
        private Supplier<class_1799> shearable = null;
        private Function<BaseCreeper, class_3414> deathSound = creeper -> class_3417.field_14907;
        private Function<BaseCreeper, class_3414> explosionSound = creeper -> null;
        private Function<BaseCreeper, class_3414> hitSound = creeper -> null;
        private Function<BaseCreeper, class_3414> hurtSound = creeper -> class_3417.field_15192;
        private Function<BaseCreeper, class_3414> primeSound = creeper -> class_3417.field_15057;
        private Function<BaseCreeper, class_3414> swimSound = creeper -> class_3417.field_14818;
        private Function<BaseCreeper, class_3414> flopSound = creeper -> class_3417.field_14584;
        private BooleanSupplier canSpawn = () -> true;

        public Builder setTexture(class_2960 texture) {
            this.texture = creeper -> texture;
            return this;
        }

        public Builder setTexture(Function<BaseCreeper, class_2960> texture) {
            this.texture = texture;
            return this;
        }

        public Builder setGlowingTexture(Function<BaseCreeper, class_2960> glowingTexture) {
            this.glowingTexture = glowingTexture;
            return this;
        }

        public Builder setGlowingTexture(class_2960 glowingTexture) {
            return this.setGlowingTexture((BaseCreeper creeper) -> glowingTexture);
        }

        public Builder setChargedTexture(Function<BaseCreeper, class_2960> chargedTexture) {
            this.chargedTexture = chargedTexture;
            return this;
        }

        public Builder setChargedTexture(class_2960 chargedTexture) {
            return this.setChargedTexture((BaseCreeper creeper) -> chargedTexture);
        }

        public Builder setModel(Function<BaseCreeper, class_2960> model) {
            this.model = model;
            return this;
        }

        public Builder setModel(class_2960 model) {
            return this.setModel((BaseCreeper creeper) -> model);
        }

        public Builder setShearedModel(Function<BaseCreeper, class_2960> shearedModel) {
            this.shearedModel = shearedModel;
            return this;
        }

        public Builder setShearedModel(class_2960 shearedModel) {
            return this.setShearedModel((BaseCreeper creeper) -> shearedModel);
        }

        public Builder setAnimation(Function<BaseCreeper, class_2960> animation) {
            this.animation = animation;
            return this;
        }

        public Builder setAnimation(class_2960 animation) {
            return this.setAnimation((BaseCreeper creeper) -> animation);
        }

        public Builder setMelee(int melee) {
            this.melee = melee;
            return this;
        }

        public Builder addReplacer(Predicate<class_2680> predicate, Function<class_5819, class_2680> function) {
            this.replacer.put(predicate, function);
            return this;
        }

        public Builder addAfraidOf(class_1299<?> entity) {
            this.afraidOf.add(entity);
            return this;
        }

        public Builder addInflictingPotion(class_1293 potion) {
            this.inflictingPotions.add(potion);
            return this;
        }

        public Builder addPotionsWhenDying(class_1293 potion) {
            this.potionsWhenDying.add(potion);
            return this;
        }

        public Builder addAttackingEntities(Class<? extends class_1309> attackingEntities) {
            this.attackingEntities.add(attackingEntities);
            return this;
        }

        public Builder addImmunity(class_1282 source) {
            this.immunities.add(source);
            return this;
        }

        public Builder addAttribute(String attribute, double value) {
            class_1320 modAttribute = PlatformUtils.getModAttribute(attribute);
            if (modAttribute == null) {
                throw new IllegalArgumentException("Mod Attribute " + attribute + " does not exist");
            }
            this.attributes.method_26868(modAttribute, value);
            return this;
        }

        public Builder addAttribute(class_1320 attribute, double value) {
            this.attributes.method_26868(attribute, value);
            return this;
        }

        public Builder setShearable(Supplier<class_1799> shearable) {
            this.shearable = shearable;
            return this;
        }

        public Builder setDeathSound(Function<BaseCreeper, class_3414> deathSound) {
            this.deathSound = deathSound;
            return this;
        }

        public Builder setDeathSounds(Supplier<class_3414> sound) {
            return this.setDeathSound(creeper -> (class_3414)sound.get());
        }

        public Builder setExplosionSound(Function<BaseCreeper, class_3414> explosionSound) {
            this.explosionSound = explosionSound;
            return this;
        }

        public Builder setExplosionSounds(Supplier<class_3414> sound) {
            return this.setExplosionSound(creeper -> (class_3414)sound.get());
        }

        public Builder setHitSound(Function<BaseCreeper, class_3414> hitSound) {
            this.hitSound = hitSound;
            return this;
        }

        public Builder setHitSounds(Supplier<class_3414> sound) {
            return this.setHitSound(creeper -> (class_3414)sound.get());
        }

        public Builder setHurtSound(Function<BaseCreeper, class_3414> hurtSound) {
            this.hurtSound = hurtSound;
            return this;
        }

        public Builder setHurtSounds(Supplier<class_3414> sound) {
            return this.setHurtSound(creeper -> (class_3414)sound.get());
        }

        public Builder setPrimeSound(Function<BaseCreeper, class_3414> primeSound) {
            this.primeSound = primeSound;
            return this;
        }

        public Builder setPrimeSounds(Supplier<class_3414> sound) {
            return this.setPrimeSound(creeper -> (class_3414)sound.get());
        }

        public Builder setSwimSound(Function<BaseCreeper, class_3414> swimSound) {
            this.swimSound = swimSound;
            return this;
        }

        public Builder setSwimSounds(Supplier<class_3414> sound) {
            return this.setSwimSound(creeper -> (class_3414)sound.get());
        }

        public Builder setFlopSound(Function<BaseCreeper, class_3414> flopSound) {
            this.flopSound = flopSound;
            return this;
        }

        public Builder setFlopSounds(Supplier<class_3414> sound) {
            return this.setFlopSound(creeper -> (class_3414)sound.get());
        }

        public Builder setCanSpawn(BooleanSupplier canSpawn) {
            this.canSpawn = canSpawn;
            return this;
        }

        public CreeperType build() {
            return new CreeperType(this.texture, this.glowingTexture, this.chargedTexture, this.model, this.shearedModel, this.animation, this.melee, this.replacer, this.afraidOf, this.inflictingPotions, this.potionsWhenDying, this.attackingEntities, this.immunities, this.attributes, this.shearable, this.deathSound, this.explosionSound, this.hitSound, this.hurtSound, this.primeSound, this.swimSound, this.flopSound, this.canSpawn);
        }
    }
}

