/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.wildlife.entity;

import com.mojang.datafixers.DataFixUtils;
import com.yahoo.chirpycricket.wildlife.entity.WildlifeEntity;
import com.yahoo.chirpycricket.wildlife.registry.Entities;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1338;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1374;
import net.minecraft.class_1378;
import net.minecraft.class_1408;
import net.minecraft.class_1412;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.RawAnimation;

public class LargeAquaticWildlifeEntity
extends WildlifeEntity {
    @Nullable
    private LargeAquaticWildlifeEntity leader;
    private int groupSize = 1;
    private int maxGroupSize = 8;

    public LargeAquaticWildlifeEntity(class_1299<? extends class_1429> type, class_1937 worldIn, Entities.EntityKey mountKey) {
        super(type, worldIn, mountKey, false, true);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6207 = new FishMoveControl(this);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1374((class_1314)this, 1.25));
        class_1355 var10000 = this.field_6201;
        Predicate var10009 = class_1301.field_6155;
        Objects.requireNonNull(var10009);
        var10000.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1657.class, 8.0f, 1.6, 1.4, var10009::test));
        this.field_6201.method_6277(4, (class_1352)new SwimToRandomPlaceGoal(this));
        this.field_6201.method_6277(5, (class_1352)new FollowGroupLeaderGoal(this));
    }

    @Override
    public RawAnimation getFlopAnimation() {
        return RawAnimation.begin().thenLoop("animation.entity.flop");
    }

    public int method_5945() {
        return this.getMaxGroupSize();
    }

    public int getMaxGroupSize() {
        return this.maxGroupSize;
    }

    protected boolean hasSelfControl() {
        return !this.hasLeader();
    }

    public boolean hasLeader() {
        return this.leader != null && this.leader.method_5805();
    }

    public LargeAquaticWildlifeEntity joinGroupOf(LargeAquaticWildlifeEntity groupLeader) {
        this.leader = groupLeader;
        groupLeader.increaseGroupSize();
        return groupLeader;
    }

    public void leaveGroup() {
        this.leader.decreaseGroupSize();
        this.leader = null;
    }

    private void increaseGroupSize() {
        ++this.groupSize;
    }

    private void decreaseGroupSize() {
        --this.groupSize;
    }

    public boolean canHaveMoreFishInGroup() {
        return this.hasOtherFishInGroup() && this.groupSize < this.getMaxGroupSize();
    }

    @Override
    public void method_5773() {
        List list;
        super.method_5773();
        if (this.hasOtherFishInGroup() && this.method_37908().field_9229.method_43048(200) == 1 && (list = this.method_37908().method_18467(((Object)((Object)this)).getClass(), this.method_5829().method_1009(8.0, 8.0, 8.0))).size() <= 1) {
            this.groupSize = 1;
        }
    }

    public boolean hasOtherFishInGroup() {
        return this.groupSize > 1;
    }

    public boolean isCloseEnoughToLeader() {
        return this.method_5858((class_1297)this.leader) <= 121.0;
    }

    public void moveTowardLeader() {
        if (this.hasLeader()) {
            this.method_5942().method_6335((class_1297)this.leader, 1.0);
        }
    }

    public void pullInOtherFish(Stream<? extends LargeAquaticWildlifeEntity> fish) {
        fish.limit(this.getMaxGroupSize() - this.groupSize).filter(fishx -> fishx != this).forEach(fishx -> fishx.joinGroupOf(this));
    }

    @Override
    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
        if (entityData == null) {
            entityData = new FishData(this);
        } else {
            this.joinGroupOf(((FishData)entityData).leader);
        }
        return entityData;
    }

    public boolean method_6094() {
        return true;
    }

    public class_1310 method_6046() {
        return class_1310.field_6292;
    }

    @Override
    public boolean method_5957(class_4538 world) {
        return world.method_8606((class_1297)this);
    }

    public int method_5970() {
        return 120;
    }

    protected int getXpToDrop(class_1657 player) {
        return 1 + this.method_37908().field_9229.method_43048(3);
    }

    protected void tickWaterBreathingAir(int air) {
        if (this.method_5805() && !this.method_5816()) {
            this.method_5855(air - 1);
            if (this.method_5669() == -20) {
                this.method_5855(0);
                this.method_5643(this.method_37908().method_48963().method_48824(), 2.0f);
            }
        } else {
            this.method_5855(300);
        }
    }

    public void method_5670() {
        int i = this.method_5669();
        super.method_5670();
        this.tickWaterBreathingAir(i);
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_5931(class_1657 player) {
        return true;
    }

    public static boolean canSpawn(class_1299<? extends class_1480> type, class_1936 world, class_3730 reason, class_2338 pos, Random random) {
        int i = world.method_8615();
        int j = i - 13;
        return pos.method_10264() >= j && pos.method_10264() <= i && world.method_8316(pos.method_10074()).method_15767(class_3486.field_15517) && world.method_8320(pos.method_10084()).method_27852(class_2246.field_10382);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.65f;
    }

    public static class_5132.class_5133 createFishAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 3.0);
    }

    protected class_1408 method_5965(class_1937 world) {
        return new class_1412((class_1308)this, world);
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_6034() && this.method_5799()) {
            this.method_5724(0.05f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
            if (this.method_5968() == null) {
                this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
            }
        } else {
            super.method_6091(movementInput);
        }
    }

    public void method_6007() {
        if (!this.method_5799() && this.method_24828() && this.field_5992) {
            this.method_18799(this.method_18798().method_1031((double)((this.field_5974.method_43057() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_5974.method_43057() * 2.0f - 1.0f) * 0.05f)));
            this.method_24830(false);
            this.field_6007 = true;
            this.method_5783(this.getFlopSound(), this.method_6107(), this.method_6017());
        }
        super.method_6007();
    }

    protected class_3414 getFlopSound() {
        return class_3417.field_14563;
    }

    protected class_3414 method_5737() {
        return class_3417.field_14591;
    }

    @Override
    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    static class FishMoveControl
    extends class_1335 {
        private final LargeAquaticWildlifeEntity fish;

        FishMoveControl(LargeAquaticWildlifeEntity owner) {
            super((class_1308)owner);
            this.fish = owner;
        }

        public void method_6240() {
            if (this.fish.method_5777(class_3486.field_15517)) {
                this.fish.method_18799(this.fish.method_18798().method_1031(0.0, 0.005, 0.0));
            }
            if (this.field_6374 == class_1335.class_1336.field_6378 && !this.fish.method_5942().method_6357()) {
                float f = (float)(this.field_6372 * this.fish.method_26825(class_5134.field_23719));
                this.fish.method_6125(class_3532.method_16439((float)0.125f, (float)this.fish.method_6029(), (float)f));
                double d = this.field_6370 - this.fish.method_23317();
                double e = this.field_6369 - this.fish.method_23318();
                double g = this.field_6367 - this.fish.method_23321();
                if (e != 0.0) {
                    double h = Math.sqrt(d * d + e * e + g * g);
                    this.fish.method_18799(this.fish.method_18798().method_1031(0.0, (double)this.fish.method_6029() * (e / h) * 0.1, 0.0));
                }
                if (d != 0.0 || g != 0.0) {
                    float h = (float)(class_3532.method_15349((double)g, (double)d) * 57.2957763671875) - 90.0f;
                    this.fish.method_36456(this.method_6238(this.fish.method_36454(), h, 90.0f));
                    this.fish.field_6283 = this.fish.method_36454();
                }
            } else {
                this.fish.method_6125(0.0f);
            }
        }
    }

    static class SwimToRandomPlaceGoal
    extends class_1378 {
        private final LargeAquaticWildlifeEntity fish;

        public SwimToRandomPlaceGoal(LargeAquaticWildlifeEntity fish) {
            super((class_1314)fish, 1.0, 40);
            this.fish = fish;
        }

        public boolean method_6264() {
            return this.fish.hasSelfControl() && super.method_6264();
        }
    }

    public class FollowGroupLeaderGoal
    extends class_1352 {
        private static final int MIN_SEARCH_DELAY = 200;
        private final LargeAquaticWildlifeEntity fish;
        private int moveDelay;
        private int checkSurroundingDelay;

        public FollowGroupLeaderGoal(LargeAquaticWildlifeEntity fish) {
            this.fish = fish;
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(fish);
        }

        protected int getSurroundingSearchDelay(LargeAquaticWildlifeEntity fish) {
            return FollowGroupLeaderGoal.method_38848((int)(200 + fish.method_6051().method_43048(200) % 20));
        }

        public boolean method_6264() {
            if (this.fish.hasOtherFishInGroup()) {
                return false;
            }
            if (this.fish.hasLeader()) {
                return true;
            }
            if (this.checkSurroundingDelay > 0) {
                --this.checkSurroundingDelay;
                return false;
            }
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(this.fish);
            Predicate<LargeAquaticWildlifeEntity> predicate = fish -> fish.canHaveMoreFishInGroup() || !fish.hasLeader();
            List list = this.fish.method_37908().method_8390(((Object)((Object)this.fish)).getClass(), this.fish.method_5829().method_1009(8.0, 8.0, 8.0), predicate);
            LargeAquaticWildlifeEntity schoolingFish = (LargeAquaticWildlifeEntity)((Object)DataFixUtils.orElse(list.stream().filter(LargeAquaticWildlifeEntity::canHaveMoreFishInGroup).findAny(), (Object)((Object)this.fish)));
            schoolingFish.pullInOtherFish(list.stream().filter(fish -> !fish.hasLeader()));
            return this.fish.hasLeader();
        }

        public boolean method_6266() {
            return this.fish.hasLeader() && this.fish.isCloseEnoughToLeader();
        }

        public void method_6269() {
            this.moveDelay = 0;
        }

        public void method_6270() {
            this.fish.leaveGroup();
        }

        public void method_6268() {
            if (--this.moveDelay <= 0) {
                this.moveDelay = this.method_38847(10);
                this.fish.moveTowardLeader();
            }
        }
    }

    public static class FishData
    implements class_1315 {
        public final LargeAquaticWildlifeEntity leader;

        public FishData(LargeAquaticWildlifeEntity leader) {
            this.leader = leader;
        }
    }
}

