/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jeresources.platform.Services;
import jeresources.profiling.ProfiledDimensionData;
import jeresources.profiling.ProfilingBlacklist;
import jeresources.profiling.ProfilingTimer;
import jeresources.util.MapKeys;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_746;

public class ChunkProfiler
implements Runnable {
    private final class_3218 level;
    private final class_5321<class_1937> dimensionKey;
    private final ProfilingTimer timer;
    private final ProfilingBlacklist blacklist;
    private final List<class_2791> chunks;
    @Nonnull
    private final ProfiledDimensionData dimensionData;
    public static final int CHUNK_SIZE = 16;
    public static final int CHUNK_HEIGHT = 256;

    public ChunkProfiler(class_3218 level, class_5321<class_1937> dimensionKey, List<class_2791> chunks, @Nonnull ProfiledDimensionData dimensionData, ProfilingTimer timer, ProfilingBlacklist blacklist) {
        this.level = level;
        this.dimensionKey = dimensionKey;
        this.chunks = chunks;
        this.dimensionData = dimensionData;
        this.timer = timer;
        this.blacklist = blacklist;
    }

    @Override
    public void run() {
        this.chunks.forEach(this::profileChunk);
    }

    private void profileChunk(class_2791 chunk) {
        class_5321 worldRegistryKey = this.level.method_27983();
        this.timer.startChunk((class_5321<class_1937>)worldRegistryKey);
        HashMap<String, Object[]> temp = new HashMap<String, Object[]>();
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        class_3965 rayTraceResult = new class_3965(new class_243(0.0, 0.0, 0.0), class_2350.field_11033, (class_2338)blockPos, true);
        class_746 player = class_310.method_1551().field_1724;
        int maxY = chunk.method_12031();
        for (int y = 0; y < maxY; ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Object[] array;
                    blockPos.method_10103(x + chunk.method_12004().field_9181 * 16, y, z + chunk.method_12004().field_9180 * 16);
                    class_2680 blockState = chunk.method_8320(new class_2338(x, y, z));
                    if (this.blacklist.contains(blockState)) continue;
                    String key = MapKeys.getKey(blockState, this.level, (class_2338)blockPos);
                    if (!this.dimensionData.dropsMap.containsKey(key)) {
                        this.dimensionData.dropsMap.put(key, ChunkProfiler.getDrops(this.level, (class_2338)blockPos, blockState));
                    }
                    if (!this.dimensionData.silkTouchMap.containsKey(key)) {
                        class_2248 block = blockState.method_26204();
                        boolean canSilkTouch = Services.PLATFORM.isCorrectToolForBlock(block, blockState, (class_1922)this.level, (class_2338)blockPos, (class_1657)player);
                        this.dimensionData.silkTouchMap.put(key, canSilkTouch);
                    }
                    if ((array = (Integer[])temp.get(key)) == null) {
                        array = new Integer[256];
                        Arrays.fill(array, (Object)0);
                    }
                    Object[] objectArray = array;
                    int n = y;
                    Object object = objectArray[n];
                    objectArray[n] = (Integer)objectArray[n] + 1;
                    temp.put(key, array);
                }
            }
        }
        for (Map.Entry entry : temp.entrySet()) {
            Object[] array = (Integer[])this.dimensionData.distributionMap.get(entry.getKey());
            if (array == null) {
                array = new Integer[256];
                Arrays.fill(array, (Object)0);
            }
            for (int i = 0; i < 256; ++i) {
                Object[] objectArray = array;
                int n = i;
                Integer.valueOf((Integer)objectArray[n] + ((Integer[])entry.getValue())[i]);
            }
            this.dimensionData.distributionMap.put((String)entry.getKey(), (Integer[])array);
        }
        this.timer.endChunk(this.dimensionKey);
    }

    public static Map<String, Map<Integer, Float>> getDrops(class_3218 level, class_2338 pos, class_2680 state) {
        int totalTries = 10000;
        HashMap<String, Map<Integer, Float>> resultMap = new HashMap<String, Map<Integer, Float>>();
        for (int fortune = 0; fortune <= 3; ++fortune) {
            HashMap<String, Integer> dropsMap = new HashMap<String, Integer>();
            for (int i = 0; i < 10000; ++i) {
                class_2371 drops = class_2371.method_10211();
                class_2248.method_9562((class_2680)state, (class_3218)level, (class_2338)pos, null);
                for (class_1799 drop : drops) {
                    if (drop == null) continue;
                    String key = MapKeys.getKey(drop);
                    Integer count = (Integer)dropsMap.get(key);
                    count = count != null ? Integer.valueOf(count + drop.method_7947()) : Integer.valueOf(drop.method_7947());
                    dropsMap.put(key, count);
                }
            }
            for (Map.Entry dropEntry : dropsMap.entrySet()) {
                HashMap<Integer, Float> fortuneMap = (HashMap<Integer, Float>)resultMap.get(dropEntry.getKey());
                if (fortuneMap == null) {
                    fortuneMap = new HashMap<Integer, Float>();
                }
                fortuneMap.put(fortune, Float.valueOf((float)((Integer)dropEntry.getValue()).intValue() / 10000.0f));
                resultMap.put((String)dropEntry.getKey(), fortuneMap);
            }
        }
        return resultMap;
    }
}

