/*
 * Decompiled with CFR 0.152.
 */
package com.dynview.ViewDistHandler;

import com.dynview.DynView;
import com.dynview.ViewDistHandler.IDynamicViewDistanceManager;
import net.minecraft.server.MinecraftServer;

public class ServerDynamicViewDistanceManager
implements IDynamicViewDistanceManager {
    private static final int UPDATE_LEEWAY = 3;
    private static ServerDynamicViewDistanceManager instance;
    public static int minChunkViewDist;
    public static int maxChunkViewDist;
    public static int minChunkUpdateDist;
    public static int maxChunkUpdateDist;
    public static double meanTickToStayBelow;
    private boolean reduceViewDistance = true;
    private boolean increaseViewDistance = true;
    private int currentChunkViewDist = 0;
    private int currentChunkUpdateDist = 0;
    private MinecraftServer server;

    private ServerDynamicViewDistanceManager() {
    }

    public static IDynamicViewDistanceManager getInstance() {
        if (instance == null) {
            instance = new ServerDynamicViewDistanceManager();
        }
        return instance;
    }

    @Override
    public void initViewDist(MinecraftServer server) {
        this.currentChunkViewDist = (minChunkViewDist + maxChunkViewDist) / 2;
        this.currentChunkUpdateDist = (minChunkUpdateDist + maxChunkUpdateDist) / 2;
        server.method_3760().method_14608(minChunkViewDist);
        if (DynView.getConfig().getCommonConfig().adjustSimulationDistance) {
            server.method_3738().forEach(level -> level.method_14178().method_38634(this.currentChunkUpdateDist));
        }
        this.server = server;
    }

    @Override
    public void updateViewDistForMeanTick(int meanTickTime) {
        if (this.server.method_3760().method_14571().isEmpty()) {
            return;
        }
        if ((double)(meanTickTime - 3) > meanTickToStayBelow) {
            this.increaseViewDistance = true;
            if (this.reduceViewDistance && this.currentChunkViewDist > minChunkViewDist) {
                this.reduceViewDistance = !DynView.getConfig().getCommonConfig().adjustSimulationDistance;
                --this.currentChunkViewDist;
                if (DynView.getConfig().getCommonConfig().logMessages) {
                    DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms decreasing chunk view distance to: " + this.currentChunkViewDist);
                }
                this.server.method_3760().method_14608(this.currentChunkViewDist);
                return;
            }
            if (!this.reduceViewDistance && this.currentChunkUpdateDist > minChunkUpdateDist) {
                this.reduceViewDistance = true;
                --this.currentChunkUpdateDist;
                if (DynView.getConfig().getCommonConfig().logMessages) {
                    DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms decreasing simulation distance to: " + this.currentChunkUpdateDist);
                }
                this.server.method_3738().forEach(level -> level.method_14178().method_38634(this.currentChunkUpdateDist));
            }
            if (!DynView.getConfig().getCommonConfig().adjustSimulationDistance) {
                this.reduceViewDistance = true;
            }
        }
        if ((double)(meanTickTime + 3) < meanTickToStayBelow) {
            this.reduceViewDistance = false;
            if (this.increaseViewDistance && this.currentChunkViewDist < maxChunkViewDist) {
                this.increaseViewDistance = !DynView.getConfig().getCommonConfig().adjustSimulationDistance;
                ++this.currentChunkViewDist;
                if (DynView.getConfig().getCommonConfig().logMessages) {
                    DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms increasing chunk view distance to: " + this.currentChunkViewDist);
                }
                this.server.method_3760().method_14608(this.currentChunkViewDist);
                return;
            }
            if (!this.increaseViewDistance && this.currentChunkUpdateDist < maxChunkUpdateDist) {
                this.increaseViewDistance = true;
                ++this.currentChunkUpdateDist;
                if (DynView.getConfig().getCommonConfig().logMessages) {
                    DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms increasing simulation distance to: " + this.currentChunkUpdateDist);
                }
                this.server.method_3738().forEach(level -> level.method_14178().method_38634(this.currentChunkUpdateDist));
            }
            if (!DynView.getConfig().getCommonConfig().adjustSimulationDistance) {
                this.increaseViewDistance = true;
            }
        }
    }
}

