/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.jem_objects;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1047;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.EMF;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFOptiFinePartNameMappings;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_model_features.utils.OptifineMobNameForFileAndEMFMapId;

public class EMFJemData {
    private final LinkedHashMap<String, LinkedHashMap<String, String>> allTopLevelAnimationsByVanillaPartName = new LinkedHashMap();
    public String texture = "";
    public int[] textureSize = null;
    public double shadow_size = 1.0;
    public LinkedList<EMFPartData> models = new LinkedList();
    private String fileName = "none";
    private String filePath = "";
    private OptifineMobNameForFileAndEMFMapId mobModelIDInfo = null;
    private class_2960 customTexture = null;

    public LinkedHashMap<String, LinkedHashMap<String, String>> getAllTopLevelAnimationsByVanillaPartName() {
        return this.allTopLevelAnimationsByVanillaPartName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public OptifineMobNameForFileAndEMFMapId getMobModelIDInfo() {
        return this.mobModelIDInfo;
    }

    public class_2960 getCustomTexture() {
        return this.customTexture;
    }

    @Nullable
    public class_2960 validateJemTexture(String textureIn) {
        if (textureIn == null || textureIn.isBlank()) {
            return null;
        }
        Object textureTest = textureIn.trim();
        if (!((String)textureTest).isBlank()) {
            if (((String)textureTest).endsWith("/trident.jem")) {
                EMFUtils.logWarn("trident texture overrides are not supported currently, they will be ignored.");
                return null;
            }
            if (!((String)textureTest).contains(":")) {
                if (!((String)textureTest).endsWith(".png")) {
                    textureTest = (String)textureTest + ".png";
                }
                if (!((String)textureTest).contains("/") || ((String)textureTest).startsWith("./")) {
                    textureTest = this.filePath + (String)textureTest;
                } else if (((String)textureTest).startsWith("~/")) {
                    textureTest = "optifine/" + (String)textureTest;
                }
            }
            if (class_2960.method_20207((String)textureTest)) {
                class_2960 possibleTexture = new class_2960((String)textureTest);
                if (class_310.method_1551().method_1478().method_14486(possibleTexture).isPresent()) {
                    return possibleTexture;
                }
            } else {
                EMFUtils.logWarn("Invalid texture identifier: " + (String)textureTest + " for " + this.fileName);
            }
        }
        return class_1047.method_4539();
    }

    private String workingDirectory() {
        String[] directorySplit = this.fileName.split("/");
        if (directorySplit.length > 1) {
            String lastDirectoryComponentOfFileName = directorySplit[directorySplit.length - 1];
            return this.fileName.replaceAll(lastDirectoryComponentOfFileName + "$", "");
        }
        return "optifine/cem/";
    }

    public void prepare(String fileName, OptifineMobNameForFileAndEMFMapId mobModelIDInfo) {
        if (this.textureSize != null && this.textureSize.length != 2) {
            this.textureSize = new int[]{64, 32};
            EMFUtils.logWarn("No textureSize provided for: " + fileName + ". Defaulting to 64x32 texture size for model.");
        }
        this.mobModelIDInfo = mobModelIDInfo;
        this.fileName = fileName;
        this.filePath = this.workingDirectory();
        LinkedList<EMFPartData> originalModelsForReadingOnly = new LinkedList<EMFPartData>(this.models);
        this.customTexture = this.validateJemTexture(this.texture);
        String mapId = mobModelIDInfo.getMapId();
        Map<String, String> map = EMFOptiFinePartNameMappings.getMapOf(mapId, null);
        for (EMFPartData eMFPartData : this.models) {
            if (eMFPartData.part == null || !map.containsKey(eMFPartData.part)) continue;
            eMFPartData.part = map.get(eMFPartData.part);
        }
        for (EMFPartData eMFPartData : this.models) {
            eMFPartData.prepare(this.textureSize, this, this.customTexture);
        }
        TreeMap alphabeticalOrderedParts = new TreeMap(Comparator.naturalOrder());
        if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
            EMFUtils.log("originalModelsForReadingOnly #= " + originalModelsForReadingOnly.size());
        }
        for (EMFPartData partData : originalModelsForReadingOnly) {
            String newId = EMFUtils.getIdUnique(alphabeticalOrderedParts.keySet(), partData.id);
            if (!newId.equals(partData.id)) {
                partData.id = newId;
            }
            alphabeticalOrderedParts.put(partData.id, partData);
        }
        if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
            EMFUtils.log("alphabeticalOrderedParts = " + alphabeticalOrderedParts);
        }
        for (EMFPartData part : alphabeticalOrderedParts.values()) {
            if (part.animations == null) continue;
            for (LinkedHashMap linkedHashMap : part.animations) {
                LinkedHashMap thisPartsAnimations = new LinkedHashMap();
                linkedHashMap.forEach((key, anim) -> {
                    key = key.trim().replaceAll("\\s", "");
                    anim = anim.trim().replaceAll("\\s", "");
                    if (key.startsWith("this.")) {
                        key = key.replaceFirst("this", part.id);
                    }
                    if (anim.contains("this.")) {
                        anim = anim.replaceAll("this", part.id);
                    }
                    if (!key.isBlank() && !anim.isBlank()) {
                        thisPartsAnimations.put(key, anim);
                    }
                });
                if (thisPartsAnimations.isEmpty()) continue;
                if (this.allTopLevelAnimationsByVanillaPartName.containsKey(part.part)) {
                    this.allTopLevelAnimationsByVanillaPartName.get(part.part).putAll(thisPartsAnimations);
                    continue;
                }
                this.allTopLevelAnimationsByVanillaPartName.put(part.part, thisPartsAnimations);
            }
        }
        if (this.shadow_size != 1.0) {
            if (this.shadow_size < 0.0) {
                this.shadow_size = 0.0;
            }
            String string = "root";
            LinkedHashMap<String, String> shadowAnimation = new LinkedHashMap<String, String>();
            shadowAnimation.put("render.shadow_size", String.valueOf(this.shadow_size));
            if (this.allTopLevelAnimationsByVanillaPartName.containsKey(string)) {
                this.allTopLevelAnimationsByVanillaPartName.get(string).putAll(shadowAnimation);
            } else {
                this.allTopLevelAnimationsByVanillaPartName.put(string, shadowAnimation);
            }
        }
    }

    public String toString() {
        return "EMF_JemData{texture='" + this.texture + "', textureSize=" + Arrays.toString(this.textureSize) + ", shadow_size=" + this.shadow_size + ", models=" + this.models.toString() + "}";
    }

    public static class EMFJemPrinter {
        public String texture = "";
        public int[] textureSize = new int[]{16, 16};
        public double shadow_size = 1.0;
        public LinkedList<EMFPartData.EMFPartPrinter> models = new LinkedList();
    }
}

