/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.latvian.mods.kubejs.core.InventoryKJS;
import dev.latvian.mods.kubejs.level.ExplosionJS;
import dev.latvian.mods.kubejs.level.FireworksJS;
import dev.latvian.mods.kubejs.platform.LevelPlatformHelper;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.util.SpecialEquality;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class BlockContainerJS
implements SpecialEquality {
    private static final class_2960 AIR_ID = new class_2960("minecraft:air");
    public final class_1937 minecraftLevel;
    private final class_2338 pos;
    public transient class_2680 cachedState;
    public transient class_2586 cachedEntity;

    public BlockContainerJS(class_1937 w, class_2338 p) {
        this.minecraftLevel = w;
        this.pos = p;
    }

    public BlockContainerJS(class_2586 blockEntity) {
        this.minecraftLevel = blockEntity.method_10997();
        this.pos = blockEntity.method_11016();
        this.cachedEntity = blockEntity;
    }

    public void clearCache() {
        this.cachedState = null;
        this.cachedEntity = null;
    }

    public class_1937 getLevel() {
        return this.minecraftLevel;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2960 getDimension() {
        return this.minecraftLevel.method_27983().method_29177();
    }

    public int getX() {
        return this.getPos().method_10263();
    }

    public int getY() {
        return this.getPos().method_10264();
    }

    public int getZ() {
        return this.getPos().method_10260();
    }

    public BlockContainerJS offset(class_2350 f, int d) {
        return new BlockContainerJS(this.minecraftLevel, this.getPos().method_10079(f, d));
    }

    public BlockContainerJS offset(class_2350 f) {
        return this.offset(f, 1);
    }

    public BlockContainerJS offset(int x, int y, int z) {
        return new BlockContainerJS(this.minecraftLevel, this.getPos().method_10069(x, y, z));
    }

    public BlockContainerJS getDown() {
        return this.offset(class_2350.field_11033);
    }

    public BlockContainerJS getUp() {
        return this.offset(class_2350.field_11036);
    }

    public BlockContainerJS getNorth() {
        return this.offset(class_2350.field_11043);
    }

    public BlockContainerJS getSouth() {
        return this.offset(class_2350.field_11035);
    }

    public BlockContainerJS getWest() {
        return this.offset(class_2350.field_11039);
    }

    public BlockContainerJS getEast() {
        return this.offset(class_2350.field_11034);
    }

    public class_2680 getBlockState() {
        if (this.cachedState == null) {
            this.cachedState = this.minecraftLevel.method_8320(this.getPos());
        }
        return this.cachedState;
    }

    public void setBlockState(class_2680 state, int flags) {
        this.minecraftLevel.method_8652(this.getPos(), state, flags);
        this.clearCache();
        this.cachedState = state;
    }

    public String getId() {
        return RegistryInfo.BLOCK.getId(this.getBlockState().method_26204()).toString();
    }

    public Collection<class_2960> getTags() {
        return Tags.byBlockState(this.getBlockState()).map(class_6862::comp_327).collect(Collectors.toSet());
    }

    public boolean hasTag(class_2960 tag) {
        return this.getBlockState().method_26164(Tags.block(tag));
    }

    public void set(class_2960 id, Map<?, ?> properties, int flags) {
        class_2248 block = RegistryInfo.BLOCK.getValue(id);
        class_2680 state = block.method_9564();
        if (!properties.isEmpty() && state.method_26204() != class_2246.field_10124) {
            HashMap<String, class_2769> pmap = new HashMap<String, class_2769>();
            for (class_2769 class_27692 : state.method_28501()) {
                pmap.put(class_27692.method_11899(), class_27692);
            }
            for (Map.Entry entry : properties.entrySet()) {
                class_2769 property = (class_2769)pmap.get(String.valueOf(entry.getKey()));
                if (property == null) continue;
                state = (class_2680)state.method_11657(property, (Comparable)UtilsJS.cast(property.method_11900(String.valueOf(entry.getValue())).orElseThrow()));
            }
        }
        this.setBlockState(state, flags);
    }

    public void set(class_2960 id, Map<?, ?> properties) {
        this.set(id, properties, 3);
    }

    public void set(class_2960 id) {
        this.set(id, Collections.emptyMap());
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        class_2680 state = this.getBlockState();
        for (class_2769 property : state.method_28501()) {
            map.put(property.method_11899(), property.method_11901(state.method_11654(property)));
        }
        return map;
    }

    @Nullable
    public class_2586 getEntity() {
        if (this.cachedEntity == null || this.cachedEntity.method_11015()) {
            this.cachedEntity = this.minecraftLevel.method_8321(this.pos);
        }
        return this.cachedEntity;
    }

    public String getEntityId() {
        class_2586 entity = this.getEntity();
        return entity == null ? "minecraft:air" : RegistryInfo.BLOCK_ENTITY_TYPE.getId(entity.method_11017()).toString();
    }

    @Nullable
    public class_2487 getEntityData() {
        class_2586 entity = this.getEntity();
        if (entity != null) {
            return entity.method_38242();
        }
        return null;
    }

    public void setEntityData(@Nullable class_2487 tag) {
        class_2586 entity;
        if (tag != null && (entity = this.getEntity()) != null) {
            entity.method_11014(tag);
        }
    }

    public void mergeEntityData(@Nullable class_2487 tag) {
        class_2487 t = this.getEntityData();
        if (t == null) {
            this.setEntityData(tag);
        } else if (tag != null && !tag.method_33133()) {
            for (String s : tag.method_10541()) {
                t.method_10566(s, tag.method_10580(s));
            }
        }
        this.setEntityData(t);
    }

    public int getLight() {
        return this.minecraftLevel.method_22339(this.pos);
    }

    public int getSkyLight() {
        return this.minecraftLevel.method_8314(class_1944.field_9284, this.pos) - this.minecraftLevel.method_8594();
    }

    public int getBlockLight() {
        return this.minecraftLevel.method_8314(class_1944.field_9282, this.pos);
    }

    public boolean getCanSeeSky() {
        return this.minecraftLevel.method_8311(this.pos);
    }

    public boolean canSeeSkyFromBelowWater() {
        return this.minecraftLevel.method_22348(this.pos);
    }

    public String toString() {
        String id = this.getId();
        Map<String, String> properties = this.getProperties();
        if (properties.isEmpty()) {
            return id;
        }
        StringBuilder builder = new StringBuilder(id);
        builder.append('[');
        boolean first = true;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
        builder.append(']');
        return builder.toString();
    }

    public ExplosionJS createExplosion() {
        return new ExplosionJS((class_1936)this.minecraftLevel, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
    }

    @Nullable
    public class_1297 createEntity(class_1299<?> type) {
        class_1297 entity = this.getLevel().kjs$createEntity(type);
        if (entity != null) {
            entity.kjs$setPosition(this);
        }
        return entity;
    }

    public void spawnLightning(boolean effectOnly, @Nullable class_3222 player) {
        if (this.minecraftLevel instanceof class_3218) {
            class_1538 e = (class_1538)class_1299.field_6112.method_5883(this.minecraftLevel);
            e.method_24203((double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5);
            e.method_6961(player);
            e.method_29498(effectOnly);
            this.minecraftLevel.method_8649((class_1297)e);
        }
    }

    public void spawnLightning(boolean effectOnly) {
        this.spawnLightning(effectOnly, null);
    }

    public void spawnLightning() {
        this.spawnLightning(false);
    }

    public void spawnFireworks(FireworksJS fireworks) {
        this.minecraftLevel.method_8649((class_1297)fireworks.createFireworkRocket(this.minecraftLevel, (double)this.getX() + 0.5, (double)this.getY() + 0.5, (double)this.getZ() + 0.5));
    }

    @Nullable
    public InventoryKJS getInventory() {
        return this.getInventory(class_2350.field_11036);
    }

    @Nullable
    public InventoryKJS getInventory(class_2350 facing) {
        class_2586 entity = this.getEntity();
        if (entity != null) {
            InventoryKJS c = LevelPlatformHelper.get().getInventoryFromBlockEntity(entity, facing);
            if (c != null) {
                return c;
            }
            if (entity instanceof InventoryKJS) {
                InventoryKJS inv = (InventoryKJS)entity;
                return inv;
            }
        }
        return null;
    }

    public class_1799 getItem() {
        class_2680 state = this.getBlockState();
        return state.method_26204().method_9574((class_1922)this.minecraftLevel, this.pos, state);
    }

    public List<class_1799> getDrops() {
        return this.getDrops(null, class_1799.field_8037);
    }

    public List<class_1799> getDrops(@Nullable class_1297 entity, class_1799 heldItem) {
        class_1937 class_19372 = this.minecraftLevel;
        if (class_19372 instanceof class_3218) {
            class_3218 s = (class_3218)class_19372;
            return class_2248.method_9609((class_2680)this.getBlockState(), (class_3218)s, (class_2338)this.pos, (class_2586)this.getEntity(), (class_1297)entity, (class_1799)heldItem);
        }
        return null;
    }

    public void popItem(class_1799 item) {
        class_2248.method_9577((class_1937)this.minecraftLevel, (class_2338)this.pos, (class_1799)item);
    }

    public void popItemFromFace(class_1799 item, class_2350 dir) {
        class_2248.method_36992((class_1937)this.minecraftLevel, (class_2338)this.pos, (class_2350)dir, (class_1799)item);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CharSequence || obj instanceof class_2960) {
            return this.getId().equals(obj.toString());
        }
        return super.equals(obj);
    }

    private static boolean isReal(class_1657 p) {
        return !PlayerHooks.isFake((class_1657)p);
    }

    public EntityArrayList getPlayersInRadius(double radius) {
        return new EntityArrayList(this.minecraftLevel, this.minecraftLevel.method_8390(class_1657.class, new class_238((double)this.pos.method_10263() - radius, (double)this.pos.method_10264() - radius, (double)this.pos.method_10260() - radius, (double)this.pos.method_10263() + 1.0 + radius, (double)this.pos.method_10264() + 1.0 + radius, (double)this.pos.method_10260() + 1.0 + radius), BlockContainerJS::isReal));
    }

    public EntityArrayList getPlayersInRadius() {
        return this.getPlayersInRadius(8.0);
    }

    public class_2960 getBiomeId() {
        return this.minecraftLevel.method_23753(this.pos).method_40230().orElse(class_1972.field_9451).method_29177();
    }

    public boolean specialEquals(Object o, boolean shallow) {
        if (o instanceof CharSequence || o instanceof class_2960) {
            return this.getId().equals(o.toString());
        }
        return this.equals(o);
    }

    public class_2487 getTypeData() {
        return this.getBlockState().method_26204().kjs$getTypeData();
    }
}

