/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.custom;

import dev.latvian.mods.kubejs.client.LangEventJS;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_8052;

public class SmithingTemplateItemBuilder
extends ItemBuilder {
    private static final List<class_2960> ARMOR_ICONS = class_8052.method_48414();
    private static final List<class_2960> INGOTS_AND_CRYSTALS_ICONS = class_8052.method_48415();
    private static final List<class_2960> EQUIPMENT_ICONS = class_8052.method_48416();
    private static final List<class_2960> TOOL_ICONS = List.of(class_8052.field_41992, class_8052.field_41993, class_8052.field_41958, class_8052.field_41959, class_8052.field_41960);
    private static final List<class_2960> CRYSTAL_ICONS = List.of(class_8052.field_41962, class_8052.field_41963, class_8052.field_41964, class_8052.field_41965, class_8052.field_41966, class_8052.field_42472);
    private final Map<String, String> translations = new HashMap<String, String>();
    public class_2561 appliesToText = class_2561.method_43470((String)"set with .appliesToDescription(string) on your smithing_template type item").method_27692(class_124.field_1078);
    public class_2561 ingredientsText = class_2561.method_43470((String)"set with .ingredientsDescription(string) on your smithing_template type item").method_27692(class_124.field_1078);
    public class_2561 appliesToSlotDescriptionText = class_2561.method_43470((String)"set with .appliesToSlotDescription(string) on your smithing_template type item");
    public class_2561 ingredientSlotDescriptionText = class_2561.method_43470((String)"set with .ingredientsSlotDescription(string) on your smithing_template type item");
    public final List<class_2960> appliesToEmptyIcons = new ArrayList<class_2960>();
    public final List<class_2960> ingredientsSlotEmptyIcons = new ArrayList<class_2960>();

    public SmithingTemplateItemBuilder(class_2960 i) {
        super(i);
    }

    @Info(value="Sets the description text that shows in the item tooltip to describe what it can be applied to.\nUsing 'Armor' or 'Diamond Equipment' will use the vanilla language keys so it is translated into other languages automatically.\nTHIS IS PURELY VISUAL\n\nIf you wish to apply non standard formatting (like change the colour) set the `ingredientsText` field.\n")
    public SmithingTemplateItemBuilder appliesTo(String text) {
        this.appliesToText = switch (text) {
            case "Armor" -> class_8052.field_41980;
            case "Diamond Equipment" -> class_8052.field_41984;
            default -> this.defaultTranslateableTooltipComponent(text, "applies_to", true);
        };
        return this;
    }

    @Info(value="Sets the description text that shows in the item tooltip to describe what ingredients can be added.\nUsing 'Ingots & Crystals' or 'Netherite Ingot' will use the vanilla language keys so it is translated into other languages automatically.\nTHIS IS PURELY VISUAL\n\nIf you wish to apply non standard formatting (like change the colour) set the `ingredientsText` field.\n")
    public SmithingTemplateItemBuilder ingredients(String text) {
        this.ingredientsText = switch (text) {
            case "Ingots and Crystals", "Ingots & Crystals" -> class_8052.field_41981;
            case "Netherite Ingot" -> class_8052.field_41985;
            default -> this.defaultTranslateableTooltipComponent(text, "ingredients", true);
        };
        return this;
    }

    @Info(value="Sets the description text that shows when you hover over the base item slot when this item is put in smithing table as a template.\nUsing 'Add a piece of armor' or 'Add diamond armor, weapon, or tool' will use the vanilla language keys so it is translated into other languages automatically.\n\nIf you wish to apply non standard formatting (like change the colour) set the `appliesToSlotDescriptionText` field.\n")
    public SmithingTemplateItemBuilder appliesToSlotDescription(String text) {
        this.appliesToSlotDescriptionText = switch (text) {
            case "Add a piece of armor" -> class_8052.field_41982;
            case "Add diamond armor, weapon, or tool" -> class_8052.field_41986;
            default -> this.defaultTranslateableTooltipComponent(text, "base_slot_description", false);
        };
        return this;
    }

    @Info(value="Sets the description text that shows when you hover over the ingredient slot when this item is put in smithing table as a template.\nUsing 'Add ingot or crystal' or 'Add Netherite Ingot' will use the vanilla language keys so it is translated into other languages automatically.\n\nIf you wish to apply non standard formatting (like change the colour) set the `ingredientSlotDescriptionText` field.\n")
    public SmithingTemplateItemBuilder ingredientsSlotDescription(String text) {
        this.ingredientSlotDescriptionText = switch (text) {
            case "Add ingot or crystal" -> class_8052.field_41982;
            case "Add Netherite Ingot" -> class_8052.field_41986;
            default -> this.defaultTranslateableTooltipComponent(text, "ingredient_slot_description", false);
        };
        return this;
    }

    @Info(value="Adds the specified texture location to the list of base slot icons that the smithing table cycles through when this smithing template is put in.")
    public SmithingTemplateItemBuilder addAppliesToSlotIcon(class_2960 location) {
        this.appliesToEmptyIcons.add(location);
        return this;
    }

    @Info(value="Adds the specified texture location to the list of ingredient slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder addIngredientsSlotIcon(class_2960 location) {
        this.ingredientsSlotEmptyIcons.add(location);
        return this;
    }

    @Info(value="Adds all armor icons to the list of base slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder armorIcons() {
        this.appliesToEmptyIcons.addAll(ARMOR_ICONS);
        return this;
    }

    @Info(value="Adds all armor and basic tool icons to the list of base slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder equipmentIcons() {
        this.appliesToEmptyIcons.addAll(EQUIPMENT_ICONS);
        return this;
    }

    @Info(value="Adds all basic tool icons to the list of base slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder toolIcons() {
        this.appliesToEmptyIcons.addAll(TOOL_ICONS);
        return this;
    }

    @Info(value="Adds an ingot, dust, diamond, emerald, quartz, lapis lazuli and amethyst shard icons to the list of ingredient slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder ingotAndCrystalIcons() {
        this.ingredientsSlotEmptyIcons.addAll(INGOTS_AND_CRYSTALS_ICONS);
        return this;
    }

    @Info(value="Adds a dust, diamond, emerald, quartz, lapis lazuli and amethyst shard icons to the list of ingredient slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder crystalIcons() {
        this.ingredientsSlotEmptyIcons.addAll(CRYSTAL_ICONS);
        return this;
    }

    @Info(value="Adds an ingot to the list of ingredient slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder ingotIcon() {
        return this.addIngredientsSlotIcon(class_8052.field_41961);
    }

    @Info(value="Adds a dust to the list of ingredient slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder dustIcon() {
        return this.addIngredientsSlotIcon(class_8052.field_41962);
    }

    @Info(value="Adds an amethyst shard to the list of ingredient slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder shardIcon() {
        return this.addIngredientsSlotIcon(class_8052.field_42472);
    }

    @Info(value="Adds a diamond to the list of ingredient slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder diamondIcon() {
        return this.addIngredientsSlotIcon(class_8052.field_41965);
    }

    @Info(value="Adds an emerald to the list of ingredient slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder emeraldIcon() {
        return this.addIngredientsSlotIcon(class_8052.field_41964);
    }

    @Info(value="Adds a quartz to the list of ingredient slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder quartzIcon() {
        return this.addIngredientsSlotIcon(class_8052.field_41963);
    }

    @Info(value="Adds a lapis lazuli to the list of ingredient slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder lapisIcon() {
        return this.addIngredientsSlotIcon(class_8052.field_41966);
    }

    @Info(value="Adds a sword to the list of base item slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder swordIcon() {
        return this.addAppliesToSlotIcon(class_8052.field_41958);
    }

    @Info(value="Adds a shovel to the list of base item slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder shovelIcon() {
        return this.addAppliesToSlotIcon(class_8052.field_41959);
    }

    @Info(value="Adds a axe to the list of base item slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder axeIcon() {
        return this.addAppliesToSlotIcon(class_8052.field_41993);
    }

    @Info(value="Adds a pickaxe to the list of base item slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder pickaxeIcon() {
        return this.addAppliesToSlotIcon(class_8052.field_41960);
    }

    @Info(value="Adds a hoe to the list of base item slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder hoeIcon() {
        return this.addAppliesToSlotIcon(class_8052.field_41992);
    }

    @Info(value="Adds a helmet to the list of base item slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder helmetIcon() {
        return this.addAppliesToSlotIcon(class_8052.field_41988);
    }

    @Info(value="Adds a chestplate to the list of base item slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder chestplateIcon() {
        return this.addAppliesToSlotIcon(class_8052.field_41989);
    }

    @Info(value="Adds leggings to the list of base item slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder leggingsIcon() {
        return this.addAppliesToSlotIcon(class_8052.field_41990);
    }

    @Info(value="Adds boots to the list of base item slot icons that the smithing table cycles through when this smithing template is put in")
    public SmithingTemplateItemBuilder bootsIcon() {
        return this.addAppliesToSlotIcon(class_8052.field_41991);
    }

    private class_2561 defaultTranslateableTooltipComponent(String text, String type, boolean tooltipDescription) {
        String translationKey = this.makeTooltipDescriptionId(type);
        this.translations.put(translationKey, text);
        class_5250 component = class_2561.method_43471((String)translationKey);
        if (tooltipDescription) {
            component.method_27692(class_8052.field_41975);
        }
        return component;
    }

    private String makeTooltipDescriptionId(String type) {
        return this.getTranslationKeyGroup() + "." + this.id.method_12836() + ".smithing_template." + this.id.method_12832() + "." + type;
    }

    @Info(value="Sets the name for this smithing template.\nNote that the normal display name for all smithing templates is the same and cannot be changed, this instead sets the name in the tooltip (see vanilla smithing templates for what this looks like).\n\nThis will be overridden by a lang file if it exists.\n")
    public SmithingTemplateItemBuilder displayName(class_2561 name) {
        super.displayName((class_2561)name.method_27661().method_27692(class_8052.field_41974));
        return this;
    }

    @Override
    public void generateLang(LangEventJS lang) {
        super.generateLang(lang);
        lang.addAll(this.id.method_12836(), this.translations);
    }

    @Override
    public class_8052 createObject() {
        return new class_8052(this.appliesToText, this.ingredientsText, (class_2561)Objects.requireNonNullElse(this.displayName, class_2561.method_43471((String)this.getBuilderTranslationKey()).method_27692(class_8052.field_41974)), this.appliesToSlotDescriptionText, this.ingredientSlotDescriptionText, this.appliesToEmptyIcons, this.ingredientsSlotEmptyIcons);
    }
}

