/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.state;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.level.gen.ruletest.AllMatchRuleTest;
import dev.latvian.mods.kubejs.level.gen.ruletest.AlwaysFalseRuleTest;
import dev.latvian.mods.kubejs.level.gen.ruletest.AnyMatchRuleTest;
import dev.latvian.mods.kubejs.level.gen.ruletest.InvertRuleTest;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.Tags;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3124;
import net.minecraft.class_3798;
import net.minecraft.class_3818;
import net.minecraft.class_3819;
import net.minecraft.class_3820;
import net.minecraft.class_3825;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BlockStatePredicate
extends Predicate<class_2680>,
ReplacementMatch {
    public static final class_2960 AIR_ID = new class_2960("minecraft:air");

    @Override
    public boolean test(class_2680 var1);

    default public boolean testBlock(class_2248 block) {
        return this.test(block.method_9564());
    }

    @Nullable
    default public class_3825 asRuleTest() {
        return null;
    }

    public static BlockStatePredicate fromString(String s) {
        if (s.equals("*")) {
            return Simple.ALL;
        }
        if (s.equals("-")) {
            return Simple.NONE;
        }
        if (s.startsWith("#")) {
            return new TagMatch(Tags.block(new class_2960(s.substring(1))));
        }
        if (s.indexOf(91) != -1) {
            class_2680 state = UtilsJS.parseBlockState(s);
            if (state != class_2246.field_10124.method_9564()) {
                return new StateMatch(state);
            }
        } else {
            class_2248 block = RegistryInfo.BLOCK.getValue(new class_2960(s));
            if (block != class_2246.field_10124) {
                return new BlockMatch(block);
            }
        }
        return Simple.NONE;
    }

    public static BlockStatePredicate of(Object o) {
        if (o == null || o == Simple.ALL) {
            return Simple.ALL;
        }
        if (o == Simple.NONE) {
            return Simple.NONE;
        }
        List<?> list = ListJS.orSelf(o);
        if (list.isEmpty()) {
            return Simple.NONE;
        }
        if (list.size() > 1) {
            ArrayList<BlockStatePredicate> predicates = new ArrayList<BlockStatePredicate>();
            for (Object o1 : list) {
                BlockStatePredicate p = BlockStatePredicate.of(o1);
                if (p == Simple.ALL) {
                    return Simple.ALL;
                }
                if (p == Simple.NONE) continue;
                predicates.add(p);
            }
            return predicates.isEmpty() ? Simple.NONE : (predicates.size() == 1 ? (BlockStatePredicate)predicates.get(0) : new OrMatch(predicates));
        }
        Map<?, ?> map = MapJS.of(o);
        if (map != null) {
            if (map.isEmpty()) {
                return Simple.ALL;
            }
            ArrayList<BlockStatePredicate> predicates = new ArrayList<BlockStatePredicate>();
            if (map.get("or") != null) {
                predicates.add(BlockStatePredicate.of(map.get("or")));
            }
            if (map.get("not") != null) {
                predicates.add(new NotMatch(BlockStatePredicate.of(map.get("not"))));
            }
            return new AndMatch(predicates);
        }
        return BlockStatePredicate.ofSingle(o);
    }

    public static class_3825 ruleTestOf(Object o) {
        BlockStatePredicate bsp;
        if (o instanceof class_3825) {
            class_3825 rule = (class_3825)o;
            return rule;
        }
        if (o instanceof BlockStatePredicate && (bsp = (BlockStatePredicate)o).asRuleTest() != null) {
            return bsp.asRuleTest();
        }
        return (class_3825)Optional.ofNullable(NBTUtils.toTagCompound((Object)o)).map(tag -> class_3825.field_25012.parse((DynamicOps)class_2509.field_11560, tag)).flatMap(DataResult::result).or(() -> Optional.ofNullable(BlockStatePredicate.of(o).asRuleTest())).orElseThrow(() -> new IllegalArgumentException("Could not parse valid rule test from " + o + "!"));
    }

    private static BlockStatePredicate ofSingle(Object o) {
        if (o instanceof BlockStatePredicate) {
            BlockStatePredicate bsp = (BlockStatePredicate)o;
            return bsp;
        }
        if (o instanceof class_2248) {
            class_2248 block = (class_2248)o;
            return new BlockMatch(block);
        }
        if (o instanceof class_2680) {
            class_2680 state = (class_2680)o;
            return new StateMatch(state);
        }
        if (o instanceof class_6862) {
            class_6862 tag = (class_6862)o;
            return new TagMatch((class_6862<class_2248>)tag);
        }
        Pattern pattern = UtilsJS.parseRegex(o);
        return pattern == null ? BlockStatePredicate.fromString(o.toString()) : new RegexMatch(pattern);
    }

    default public Collection<class_2680> getBlockStates() {
        HashSet<class_2680> states = new HashSet<class_2680>();
        for (class_2680 state : UtilsJS.getAllBlockStates()) {
            if (!this.test(state)) continue;
            states.add(state);
        }
        return states;
    }

    default public Collection<class_2248> getBlocks() {
        HashSet<class_2248> blocks = new HashSet<class_2248>();
        for (class_2680 state : this.getBlockStates()) {
            blocks.add(state.method_26204());
        }
        return blocks;
    }

    default public Set<class_2960> getBlockIds() {
        LinkedHashSet<class_2960> set = new LinkedHashSet<class_2960>();
        for (class_2248 block : this.getBlocks()) {
            class_2960 blockId = RegistryInfo.BLOCK.getId(block);
            if (blockId == null) continue;
            set.add(blockId);
        }
        return set;
    }

    default public boolean check(List<class_3124.class_5876> targetStates) {
        for (class_3124.class_5876 state : targetStates) {
            if (!this.test(state.field_29069)) continue;
            return true;
        }
        return false;
    }

    public static enum Simple implements BlockStatePredicate
    {
        ALL(true),
        NONE(false);

        private final boolean match;

        private Simple(boolean match) {
            this.match = match;
        }

        @Override
        public boolean test(class_2680 state) {
            return this.match;
        }

        @Override
        public boolean testBlock(class_2248 block) {
            return this.match;
        }

        @Override
        public class_3825 asRuleTest() {
            return this.match ? class_3818.field_16868 : AlwaysFalseRuleTest.INSTANCE;
        }

        @Override
        public Collection<class_2680> getBlockStates() {
            return this.match ? UtilsJS.getAllBlockStates() : List.of();
        }
    }

    public record TagMatch(class_6862<class_2248> tag) implements BlockStatePredicate
    {
        @Override
        public boolean test(class_2680 state) {
            return state.method_26164(this.tag);
        }

        @Override
        public boolean testBlock(class_2248 block) {
            return block.method_40142().method_40220(this.tag);
        }

        @Override
        public Collection<class_2248> getBlocks() {
            return (Collection)class_156.method_654(new LinkedHashSet(), set -> {
                for (class_6880 holder : class_7923.field_41175.method_40286(this.tag)) {
                    set.add((class_2248)holder.comp_349());
                }
            });
        }

        @Override
        public class_3825 asRuleTest() {
            return new class_3798(this.tag);
        }
    }

    public record StateMatch(class_2680 state) implements BlockStatePredicate
    {
        @Override
        public boolean test(class_2680 s) {
            return this.state == s;
        }

        @Override
        public boolean testBlock(class_2248 block) {
            return this.state.method_26204() == block;
        }

        @Override
        public Collection<class_2248> getBlocks() {
            return Collections.singleton(this.state.method_26204());
        }

        @Override
        public Collection<class_2680> getBlockStates() {
            return Collections.singleton(this.state);
        }

        @Override
        public Set<class_2960> getBlockIds() {
            class_2960 blockId = RegistryInfo.BLOCK.getId(this.state.method_26204());
            return blockId == null ? Collections.emptySet() : Collections.singleton(blockId);
        }

        @Override
        public class_3825 asRuleTest() {
            return new class_3820(this.state);
        }
    }

    public record BlockMatch(class_2248 block) implements BlockStatePredicate
    {
        @Override
        public boolean test(class_2680 state) {
            return state.method_27852(this.block);
        }

        @Override
        public boolean testBlock(class_2248 block) {
            return this.block == block;
        }

        @Override
        public Collection<class_2248> getBlocks() {
            return Collections.singleton(this.block);
        }

        @Override
        public Collection<class_2680> getBlockStates() {
            return this.block.method_9595().method_11662();
        }

        @Override
        public Set<class_2960> getBlockIds() {
            class_2960 blockId = RegistryInfo.BLOCK.getId(this.block);
            return blockId == null ? Collections.emptySet() : Collections.singleton(blockId);
        }

        @Override
        public class_3825 asRuleTest() {
            return new class_3819(this.block);
        }
    }

    public record OrMatch(List<BlockStatePredicate> list) implements BlockStatePredicate
    {
        @Override
        public boolean test(class_2680 state) {
            for (BlockStatePredicate predicate : this.list) {
                if (!predicate.test(state)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testBlock(class_2248 block) {
            for (BlockStatePredicate predicate : this.list) {
                if (!predicate.testBlock(block)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<class_2248> getBlocks() {
            HashSet<class_2248> set = new HashSet<class_2248>();
            for (BlockStatePredicate predicate : this.list) {
                set.addAll(predicate.getBlocks());
            }
            return set;
        }

        @Override
        public Collection<class_2680> getBlockStates() {
            HashSet<class_2680> set = new HashSet<class_2680>();
            for (BlockStatePredicate predicate : this.list) {
                set.addAll(predicate.getBlockStates());
            }
            return set;
        }

        @Override
        public Set<class_2960> getBlockIds() {
            LinkedHashSet<class_2960> set = new LinkedHashSet<class_2960>();
            for (BlockStatePredicate predicate : this.list) {
                set.addAll(predicate.getBlockIds());
            }
            return set;
        }

        @Override
        public class_3825 asRuleTest() {
            AnyMatchRuleTest test = new AnyMatchRuleTest();
            for (BlockStatePredicate predicate : this.list) {
                test.rules.add(predicate.asRuleTest());
            }
            return test;
        }
    }

    public static final class NotMatch
    implements BlockStatePredicate {
        private final BlockStatePredicate predicate;
        private final Collection<class_2680> cachedStates;

        public NotMatch(BlockStatePredicate predicate) {
            this.predicate = predicate;
            this.cachedStates = new LinkedHashSet<class_2680>();
            for (Map.Entry<class_5321<class_2248>, class_2248> entry : RegistryInfo.BLOCK.entrySet()) {
                for (class_2680 state : entry.getValue().method_9595().method_11662()) {
                    if (predicate.test(state)) continue;
                    this.cachedStates.add(state);
                }
            }
        }

        @Override
        public boolean test(class_2680 state) {
            return !this.predicate.test(state);
        }

        @Override
        public boolean testBlock(class_2248 block) {
            return !this.predicate.testBlock(block);
        }

        @Override
        public Collection<class_2248> getBlocks() {
            HashSet<class_2248> set = new HashSet<class_2248>();
            for (class_2680 blockState : this.getBlockStates()) {
                set.add(blockState.method_26204());
            }
            return set;
        }

        @Override
        public Collection<class_2680> getBlockStates() {
            return this.cachedStates;
        }

        @Override
        public Set<class_2960> getBlockIds() {
            HashSet<class_2960> set = new HashSet<class_2960>();
            for (class_2248 block : this.getBlocks()) {
                set.add(RegistryInfo.BLOCK.getId(block));
            }
            return set;
        }

        @Override
        public class_3825 asRuleTest() {
            return new InvertRuleTest(this.predicate.asRuleTest());
        }
    }

    public static final class AndMatch
    implements BlockStatePredicate {
        private final List<BlockStatePredicate> list;
        private final Collection<class_2680> cachedStates;

        public AndMatch(List<BlockStatePredicate> list) {
            this.list = list;
            this.cachedStates = new LinkedHashSet<class_2680>();
            for (Map.Entry<class_5321<class_2248>, class_2248> entry : RegistryInfo.BLOCK.entrySet()) {
                for (class_2680 state : entry.getValue().method_9595().method_11662()) {
                    boolean match = true;
                    for (BlockStatePredicate predicate : list) {
                        if (predicate.test(state)) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    this.cachedStates.add(state);
                }
            }
        }

        @Override
        public boolean test(class_2680 state) {
            for (BlockStatePredicate predicate : this.list) {
                if (predicate.test(state)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean testBlock(class_2248 block) {
            for (BlockStatePredicate predicate : this.list) {
                if (predicate.testBlock(block)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Collection<class_2248> getBlocks() {
            HashSet<class_2248> set = new HashSet<class_2248>();
            for (class_2680 blockState : this.getBlockStates()) {
                set.add(blockState.method_26204());
            }
            return set;
        }

        @Override
        public Collection<class_2680> getBlockStates() {
            return this.cachedStates;
        }

        @Override
        public class_3825 asRuleTest() {
            AllMatchRuleTest test = new AllMatchRuleTest();
            for (BlockStatePredicate predicate : this.list) {
                test.rules.add(predicate.asRuleTest());
            }
            return test;
        }
    }

    public static final class RegexMatch
    implements BlockStatePredicate {
        public final Pattern pattern;
        private final LinkedHashSet<class_2248> matchedBlocks;

        public RegexMatch(Pattern p) {
            this.pattern = p;
            this.matchedBlocks = new LinkedHashSet();
            for (class_2680 state : UtilsJS.getAllBlockStates()) {
                class_2248 block = state.method_26204();
                if (this.matchedBlocks.contains(block) || !this.pattern.matcher(RegistryInfo.BLOCK.getId(block).toString()).find()) continue;
                this.matchedBlocks.add(state.method_26204());
            }
        }

        @Override
        public boolean test(class_2680 state) {
            return this.matchedBlocks.contains(state.method_26204());
        }

        @Override
        public boolean testBlock(class_2248 block) {
            return this.matchedBlocks.contains(block);
        }

        @Override
        public Collection<class_2248> getBlocks() {
            return this.matchedBlocks;
        }

        @Override
        public class_3825 asRuleTest() {
            AnyMatchRuleTest test = new AnyMatchRuleTest();
            for (class_2248 block : this.matchedBlocks) {
                test.rules.add((class_3825)new class_3819(block));
            }
            return test;
        }
    }
}

