/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.worldgen.features;

import com.mojang.serialization.Codec;
import com.ordana.spelunkery.worldgen.feature_configs.util.FastNoiseLite;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5778;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7268;

public class SculkGrowthFeature
extends class_3031<class_3111> {
    FastNoiseLite sculkShapeNoise;
    private class_5281 worldGenLevel;
    private class_5819 random;
    private static final float DECORATION_THRESHOLD = 0.03f;
    private static final float SENSOR_THRESHOLD = 0.7f;
    private static final float CATALYST_THRESHOLD = 0.8f;
    private static final float SHRIEKER_THRESHOLD = 1.0f;
    private static final int MAX_CATALYSTS = 1;
    private int catalystCount;

    public SculkGrowthFeature(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
        this.sculkShapeNoise = new FastNoiseLite(0);
        this.sculkShapeNoise.SetFrequency(0.16666667f);
        this.sculkShapeNoise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        this.worldGenLevel = featurePlaceContext.method_33652();
        class_2338 blockPos = featurePlaceContext.method_33655();
        this.random = featurePlaceContext.method_33654();
        this.catalystCount = 0;
        for (int x = -8; x < 8; ++x) {
            for (int y = -8; y < 8; ++y) {
                for (int z = -8; z < 8; ++z) {
                    float dist = class_3532.method_15355((float)((float)blockPos.method_10069(x, y, z).method_10262((class_2382)blockPos))) / 8.0f;
                    class_2338 blockPos1 = blockPos.method_10069(x, y, z);
                    int worldX = blockPos1.method_10263();
                    int worldY = blockPos1.method_10264();
                    int worldZ = blockPos1.method_10260();
                    dist = 1.0f - dist;
                    dist = class_3532.method_16439((float)0.5f, (float)dist, (float)(dist * dist));
                    dist = 1.0f - dist;
                    float noise = this.sculkShapeNoise.GetNoise(worldX, worldZ);
                    noise = Math.abs(noise);
                    noise = 1.0f - noise;
                    noise *= noise;
                    noise = 1.0f - noise;
                    dist += noise * 0.4f;
                    dist -= 0.1f;
                    if (!this.isBlockExposedToAir(blockPos.method_10069(x, y, z))) continue;
                    if ((double)dist < 0.825) {
                        this.setSculkBlock(blockPos.method_10069(x, y, z));
                        continue;
                    }
                    if (!(dist < 1.0f)) continue;
                    this.coverWithSculkVeins(blockPos.method_10069(x, y, z));
                }
            }
        }
        return true;
    }

    private boolean isBlockExposedToAir(class_2338 blockPos) {
        return this.worldGenLevel.method_8320(blockPos).method_26234((class_1922)this.worldGenLevel, blockPos) && this.exposedToAir(blockPos);
    }

    private boolean exposedToAir(class_2338 blockPos) {
        for (class_2350 direction : class_2350.values()) {
            class_2680 blockState = this.worldGenLevel.method_8320(blockPos.method_10093(direction));
            if (!blockState.method_27852(class_2246.field_10124) && !blockState.method_27852(class_2246.field_37569)) continue;
            return true;
        }
        return false;
    }

    private boolean exposedToAirNotSculk(class_2338 blockPos) {
        for (class_2350 direction : class_2350.values()) {
            class_2680 blockState = this.worldGenLevel.method_8320(blockPos.method_10093(direction));
            if (!blockState.method_27852(class_2246.field_10124)) continue;
            return true;
        }
        return false;
    }

    private void setSculkBlock(class_2338 blockPos) {
        class_2680 blockState = this.worldGenLevel.method_8320(blockPos);
        if (blockState.method_26164(class_3481.field_37400)) {
            if (this.exposedToAirNotSculk(blockPos)) {
                this.worldGenLevel.method_8652(blockPos, class_2246.field_37568.method_9564(), 2);
                this.placeDecoration(blockPos.method_10069(0, 1, 0));
            }
        } else if (!this.blockIsSculkAlready(blockPos)) {
            this.coverWithSculkVeins(blockPos);
        }
    }

    private boolean belowAirOrVeins(class_2338 blockPos) {
        class_2680 blockState = this.worldGenLevel.method_8320(blockPos.method_10093(class_2350.field_11036));
        return blockState.method_27852(class_2246.field_10124) || blockState.method_27852(class_2246.field_37569);
    }

    private void placeDecoration(class_2338 blockPos) {
        if (this.belowAirOrVeins(blockPos) && this.random.method_43057() < 0.03f) {
            class_2680 blockState;
            if (this.random.method_43057() < 0.7f) {
                blockState = class_2246.field_28108.method_9564();
            } else if (this.random.method_43057() < 0.8f && this.catalystCount < 1) {
                ++this.catalystCount;
                blockState = class_2246.field_37570.method_9564();
            } else {
                blockState = (class_2680)class_2246.field_37571.method_9564().method_11657((class_2769)class_7268.field_38422, (Comparable)Boolean.valueOf(true));
            }
            this.worldGenLevel.method_8652(blockPos, blockState, 2);
        }
    }

    private boolean blockIsSculkAlready(class_2338 blockPos) {
        class_2680 blockState = this.worldGenLevel.method_8320(blockPos);
        return blockState.method_27852(class_2246.field_37569) || blockState.method_27852(class_2246.field_37568);
    }

    private void coverWithSculkVeins(class_2338 blockPos) {
        class_2680 blockToCoverState = this.worldGenLevel.method_8320(blockPos);
        if (!blockToCoverState.method_27852(class_2246.field_37568) && !blockToCoverState.method_27852(class_2246.field_37570)) {
            for (class_2350 direction : class_2350.values()) {
                class_5778 multifaceBlock;
                class_2680 veinBlockState;
                class_2680 blockState = this.worldGenLevel.method_8320(blockPos.method_10093(direction));
                if (!blockState.method_27852(class_2246.field_10124) && !blockState.method_27852(class_2246.field_37569) || (veinBlockState = (multifaceBlock = (class_5778)class_2246.field_37569).method_33362(this.worldGenLevel.method_8320(blockPos.method_10093(direction)), (class_1922)this.worldGenLevel, blockPos.method_10093(direction), direction.method_10153())) == null) continue;
                this.worldGenLevel.method_8652(blockPos.method_10093(direction), veinBlockState, 2);
            }
        }
    }
}

