/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.mixin;

import fuzs.puzzleslib.api.event.v1.FabricLivingEvents;
import fuzs.puzzleslib.api.event.v1.FabricPlayerEvents;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingAttackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemTossCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
abstract class PlayerFabricMixin
extends class_1309 {
    @Unique
    private DefaultedFloat puzzleslib$damageAmount;

    protected PlayerFabricMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick$0(CallbackInfo callback) {
        ((PlayerTickEvents.Start)FabricPlayerEvents.PLAYER_TICK_START.invoker()).onStartPlayerTick((class_1657)class_1657.class.cast((Object)this));
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick$1(CallbackInfo callback) {
        ((PlayerTickEvents.End)FabricPlayerEvents.PLAYER_TICK_END.invoker()).onEndPlayerTick((class_1657)class_1657.class.cast((Object)this));
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callback) {
        EventResult result = ((LivingAttackCallback)FabricLivingEvents.LIVING_ATTACK.invoker()).onLivingAttack(this, source, amount);
        if (result.isInterrupt()) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="TAIL")}, cancellable=true)
    public void drop(class_1799 itemStack, boolean throwRandomly, boolean retainOwnership, CallbackInfoReturnable<class_1542> callback) {
        class_1542 itemEntity = (class_1542)callback.getReturnValue();
        if (itemEntity != null && ((ItemTossCallback)FabricPlayerEvents.ITEM_TOSS.invoker()).onItemToss(itemEntity, (class_1657)class_1657.class.cast((Object)this)).isInterrupt()) {
            callback.setReturnValue(null);
        }
    }

    @ModifyVariable(method={"getDestroySpeed"}, at=@At(value="LOAD", ordinal=1), ordinal=0, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;onGround()Z")))
    public float getDestroySpeed(float destroySpeed, class_2680 state) {
        DefaultedFloat breakSpeed = DefaultedFloat.fromValue(destroySpeed);
        if (((PlayerEvents.BreakSpeed)FabricPlayerEvents.BREAK_SPEED.invoker()).onBreakSpeed((class_1657)class_1657.class.cast((Object)this), state, breakSpeed).isInterrupt()) {
            breakSpeed.accept(-1.0f);
        }
        return breakSpeed.getAsOptionalFloat().orElse(Float.valueOf(destroySpeed)).floatValue();
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    public void die(class_1282 damageSource, CallbackInfo callback) {
        EventResult result = ((LivingDeathCallback)FabricLivingEvents.LIVING_DEATH.invoker()).onLivingDeath(this, damageSource);
        if (result.isInterrupt()) {
            callback.cancel();
        }
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="HEAD")}, cancellable=true)
    protected void actuallyHurt(class_1282 damageSource, float damageAmount, CallbackInfo callback) {
        if (!this.method_5679(damageSource)) {
            this.puzzleslib$damageAmount = DefaultedFloat.fromValue(damageAmount);
            if (((LivingHurtCallback)FabricLivingEvents.LIVING_HURT.invoker()).onLivingHurt((class_1309)class_1309.class.cast((Object)this), damageSource, this.puzzleslib$damageAmount).isInterrupt()) {
                callback.cancel();
            }
        }
    }

    @ModifyVariable(method={"actuallyHurt"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    protected float actuallyHurt(float damageAmount, class_1282 damageSource) {
        if (!this.method_5679(damageSource)) {
            Objects.requireNonNull(this.puzzleslib$damageAmount, "damage amount is null");
            damageAmount = this.puzzleslib$damageAmount.getAsOptionalFloat().orElse(Float.valueOf(damageAmount)).floatValue();
            this.puzzleslib$damageAmount = null;
        }
        return damageAmount;
    }
}

