/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3665;
import net.minecraft.class_4013;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_763;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import org.slf4j.Logger;
import shetiphian.core.client.model.IPartData;
import shetiphian.core.client.model.PackTextureOverrideHandler;
import shetiphian.core.client.model.RetexturedBlockModel;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractModelCacheBuilder
implements class_4013 {
    private final Logger LOGGER;
    private final Table<String, String, EnumMap<class_1086, class_1087>> PART_CACHE = HashBasedTable.create();
    private final List<String> PART_ERROR = new ArrayList<String>();
    protected class_7775 BAKERY;
    protected Function<class_4730, class_1058> SPRITE_GETTER;
    protected class_763 MESHER;
    private static class_1100 MISSING_MODEL;
    public final Map<String, class_1087> ITEM_CACHE = new HashMap<String, class_1087>();
    private final EnumMap<class_1086, UVLocked> UVLOCKED = new EnumMap(class_1086.class);

    public AbstractModelCacheBuilder(Logger logger) {
        this.LOGGER = logger;
        class_3300 manager = class_310.method_1551().method_1478();
        if (manager instanceof class_3304) {
            ((class_3304)manager).method_14477((class_3302)this);
        }
    }

    public void preBakeSetup(class_7775 bakery, Function<class_4730, class_1058> spriteGetter) {
        this.BAKERY = bakery;
        this.SPRITE_GETTER = spriteGetter;
    }

    public final void method_14491(class_3300 manager) {
        this.PART_CACHE.clear();
        this.ITEM_CACHE.clear();
        this.PART_ERROR.clear();
        this.onReload();
    }

    protected abstract void onReload();

    protected class_1087 get(String part, String key, class_2350 facing, String particle, List<IPartData> models) {
        return this.get(part, key, AbstractModelCacheBuilder.toRotation(facing), particle, models);
    }

    public static class_1086 toRotation(class_2350 facing) {
        class_1086 class_10862;
        if (facing == null) {
            class_10862 = class_1086.field_5350;
        } else {
            switch (facing) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case field_11043: {
                    class_10862 = class_1086.field_5350;
                    break;
                }
                case field_11034: {
                    class_10862 = class_1086.field_5366;
                    break;
                }
                case field_11035: {
                    class_10862 = class_1086.field_5355;
                    break;
                }
                case field_11039: {
                    class_10862 = class_1086.field_5347;
                    break;
                }
                case field_11036: {
                    class_10862 = class_1086.field_5351;
                    break;
                }
                case field_11033: {
                    class_10862 = class_1086.field_5353;
                }
            }
        }
        return class_10862;
    }

    protected class_1087 get(String part, String key, class_1086 rotation, String particle, List<IPartData> models) {
        Map map;
        if (this.PART_ERROR.contains(part)) {
            return null;
        }
        if (!this.PART_CACHE.contains((Object)part, (Object)key)) {
            this.buildCache(part, key, particle, models);
        }
        if ((map = (Map)this.PART_CACHE.get((Object)part, (Object)key)) == null) {
            map = (Map)this.PART_CACHE.get((Object)part, (Object)"default");
        }
        return map == null ? null : (class_1087)map.get(rotation);
    }

    protected void buildCache(String part, String key, String particle, List<IPartData> models) {
        IPartData iPartData = null;
        for (IPartData data : models) {
            if (!data.getName().equalsIgnoreCase(part)) continue;
            iPartData = data;
            break;
        }
        if (iPartData == null) {
            return;
        }
        class_1100 unbaked = null;
        if (this.BAKERY != null && (unbaked = this.getModelOrMissing(iPartData.getLocation())).equals(this.BAKERY.method_45872((class_2960)class_1088.field_5374))) {
            if (!this.PART_ERROR.contains(part)) {
                unbaked = this.getModelOrMissing(iPartData.getLocation());
                if (unbaked.equals(this.BAKERY.method_45872((class_2960)class_1088.field_5374))) {
                    unbaked = null;
                }
            } else {
                unbaked = null;
            }
        }
        if (unbaked == null) {
            if (!this.PART_ERROR.contains(part)) {
                if (this.LOGGER != null) {
                    this.LOGGER.error("Unable to retrieve model form the ModelLoaderRegistry, this part may not render correctly: " + part);
                }
                this.PART_ERROR.add(part);
            }
            return;
        }
        if (!this.PART_CACHE.contains((Object)iPartData.getName(), (Object)"default")) {
            if (unbaked instanceof class_793) {
                this.PART_CACHE.put((Object)iPartData.getName(), (Object)"default", this.getMap(iPartData, (class_1100)RetexturedBlockModel.from((class_793)unbaked).retexture(this.setTextures(iPartData, iPartData.getDefaultTexture(), particle)), iPartData.getLocation()));
            } else {
                this.PART_CACHE.put((Object)iPartData.getName(), (Object)"default", this.getMap(iPartData, unbaked, iPartData.getLocation()));
            }
        }
        if (!key.equals("default")) {
            if (unbaked instanceof class_793) {
                this.PART_CACHE.put((Object)iPartData.getName(), (Object)key, this.getMap(iPartData, (class_1100)RetexturedBlockModel.from((class_793)unbaked).retexture(this.setTextures(iPartData, key, particle)), iPartData.getLocation()));
            } else {
                this.PART_CACHE.put((Object)iPartData.getName(), (Object)key, this.getMap(iPartData, unbaked, iPartData.getLocation()));
            }
        }
    }

    protected class_1100 getModelOrMissing(class_2960 identifier) {
        try {
            return this.BAKERY.method_45872(identifier);
        }
        catch (Exception e) {
            if (MISSING_MODEL == null) {
                try {
                    MISSING_MODEL = this.BAKERY.method_45872((class_2960)class_1088.field_5374);
                }
                catch (Exception e2) {
                    throw new RuntimeException("Missing the missing model, this should never happen");
                }
            }
            return MISSING_MODEL;
        }
    }

    public String getTexture(class_1799 stack) {
        return this.getTextureSprite(stack).method_45851().method_45816().toString();
    }

    public class_1058 getTextureSprite(class_1799 stack) {
        if (PackTextureOverrideHandler.contains(stack)) {
            return this.getTextureSprite(PackTextureOverrideHandler.get(stack));
        }
        try {
            if (this.MESHER == null) {
                this.MESHER = class_310.method_1551().method_1480().method_4012();
            }
            class_1087 model = this.MESHER.method_3308(stack);
            return model.method_4711();
        }
        catch (Exception exception) {
            return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
        }
    }

    public class_1058 getTextureSprite(class_2960 location) {
        try {
            return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(location);
        }
        catch (Exception exception) {
            return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
        }
    }

    protected abstract ImmutableMap<String, String> setTextures(IPartData var1, String var2, String var3);

    protected EnumMap<class_1086, class_1087> getMap(IPartData iPartData, class_1100 model, class_2960 location) {
        EnumMap<class_1086, class_1087> map = new EnumMap<class_1086, class_1087>(class_1086.class);
        if (iPartData.isUvLocked()) {
            for (class_1086 rotation : iPartData.getRotations()) {
                if (!this.UVLOCKED.containsKey(rotation)) {
                    this.UVLOCKED.put(rotation, new UVLocked(rotation));
                }
                map.put(rotation, model.method_4753(this.BAKERY, this.SPRITE_GETTER, (class_3665)this.UVLOCKED.get(rotation), location));
            }
        } else {
            for (class_1086 rotation : iPartData.getRotations()) {
                map.put(rotation, model.method_4753(this.BAKERY, this.SPRITE_GETTER, (class_3665)rotation, location));
            }
        }
        return map;
    }

    private static class UVLocked
    implements class_3665 {
        private final class_1086 rotation;

        private UVLocked(class_1086 rotation) {
            this.rotation = rotation;
        }

        public boolean method_3512() {
            return true;
        }

        public class_4590 method_3509() {
            return this.rotation.method_3509();
        }
    }
}

