/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackPropagator;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class TrackBlockEntityTilt {
    public Optional<Double> smoothingAngle;
    private Couple<Pair<class_243, Integer>> previousSmoothingHandles;
    private TrackBlockEntity blockEntity;

    public TrackBlockEntityTilt(TrackBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.smoothingAngle = Optional.empty();
    }

    public void tryApplySmoothing() {
        if (this.smoothingAngle.isPresent()) {
            return;
        }
        Pair discoveredSlopes = Couple.create(null, null);
        class_243 axis = null;
        class_2680 blockState = this.blockEntity.method_11010();
        class_2338 worldPosition = this.blockEntity.method_11016();
        class_1937 level = this.blockEntity.method_10997();
        class_2248 class_22482 = blockState.method_26204();
        if (!(class_22482 instanceof ITrackBlock)) {
            return;
        }
        ITrackBlock itb = (ITrackBlock)class_22482;
        List<class_243> axes = itb.getTrackAxes((class_1922)level, worldPosition, blockState);
        if (axes.size() != 1) {
            return;
        }
        if (axes.get((int)0).field_1351 != 0.0) {
            return;
        }
        if (this.blockEntity.boundLocation != null) {
            return;
        }
        for (BezierConnection bezierConnection : this.blockEntity.connections.values()) {
            if (((class_243)bezierConnection.starts.getFirst()).field_1351 == ((class_243)bezierConnection.starts.getSecond()).field_1351) continue;
            class_243 normedAxis = ((class_243)bezierConnection.axes.getFirst()).method_1029();
            if (axis != null) {
                if (discoveredSlopes.getSecond() != null) {
                    return;
                }
                if (normedAxis.method_1026(axis) > -0.984375) {
                    return;
                }
                discoveredSlopes.setSecond(bezierConnection);
                continue;
            }
            axis = normedAxis;
            discoveredSlopes.setFirst(bezierConnection);
        }
        if (((Couple)discoveredSlopes).either(Objects::isNull)) {
            return;
        }
        if (((class_243)((BezierConnection)discoveredSlopes.getFirst()).starts.getSecond()).field_1351 > ((class_243)((BezierConnection)discoveredSlopes.getSecond()).starts.getSecond()).field_1351) {
            discoveredSlopes = ((Couple)discoveredSlopes).swap();
        }
        Couple<class_243> lowStarts = ((BezierConnection)discoveredSlopes.getFirst()).starts;
        Couple<class_243> highStarts = ((BezierConnection)discoveredSlopes.getSecond()).starts;
        class_243 lowestPoint = (class_243)lowStarts.getSecond();
        class_243 highestPoint = (class_243)highStarts.getSecond();
        if (lowestPoint.field_1351 > ((class_243)lowStarts.getFirst()).field_1351) {
            return;
        }
        if (highestPoint.field_1351 < ((class_243)highStarts.getFirst()).field_1351) {
            return;
        }
        this.blockEntity.removeInboundConnections(false);
        this.blockEntity.connections.clear();
        TrackPropagator.onRailRemoved((class_1936)level, worldPosition, blockState);
        double hDistance = ((BezierConnection)discoveredSlopes.getFirst()).getLength() + ((BezierConnection)discoveredSlopes.getSecond()).getLength();
        class_243 baseAxis = (class_243)((BezierConnection)discoveredSlopes.getFirst()).axes.getFirst();
        double baseAxisLength = baseAxis.field_1352 != 0.0 && baseAxis.field_1350 != 0.0 ? Math.sqrt(2.0) : 1.0;
        double vDistance = highestPoint.field_1351 - lowestPoint.field_1351;
        double m = vDistance / hDistance;
        class_243 diff = ((class_243)highStarts.getFirst()).method_1020((class_243)lowStarts.getFirst());
        boolean flipRotation = diff.method_1026(new class_243(1.0, 0.0, 2.0).method_1029()) <= 0.0;
        this.smoothingAngle = Optional.of(Math.toDegrees(class_3532.method_15349((double)m, (double)1.0)) * (double)(flipRotation ? -1 : 1));
        int smoothingParam = class_3532.method_15340((int)((int)(m * baseAxisLength * 16.0)), (int)0, (int)15);
        Couple<Integer> smoothingResult = Couple.create(0, smoothingParam);
        class_243 raisedOffset = diff.method_1029().method_1031(0.0, class_3532.method_15350((double)m, (double)0.0, (double)0.998046875), 0.0).method_1029().method_1021(baseAxisLength);
        highStarts.setFirst(((class_243)lowStarts.getFirst()).method_1019(raisedOffset));
        boolean first = true;
        Iterator iterator = ((Couple)discoveredSlopes).iterator();
        while (iterator.hasNext()) {
            BezierConnection bezierConnection = (BezierConnection)iterator.next();
            int smoothingToApply = smoothingResult.get(first);
            if (bezierConnection.smoothing == null) {
                bezierConnection.smoothing = Couple.create(0, 0);
            }
            bezierConnection.smoothing.setFirst(smoothingToApply);
            bezierConnection.axes.setFirst(((class_243)bezierConnection.axes.getFirst()).method_1031(0.0, (double)(first ? 1 : -1) * -m, 0.0).method_1029());
            first = false;
            class_2338 otherPosition = bezierConnection.getKey();
            class_2680 otherState = level.method_8320(otherPosition);
            if (!(otherState.method_26204() instanceof TrackBlock)) continue;
            level.method_8501(otherPosition, (class_2680)otherState.method_11657((class_2769)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)));
            class_2586 otherBE = level.method_8321(otherPosition);
            if (!(otherBE instanceof TrackBlockEntity)) continue;
            TrackBlockEntity tbe = (TrackBlockEntity)otherBE;
            this.blockEntity.addConnection(bezierConnection);
            tbe.addConnection(bezierConnection.secondary());
        }
    }

    public void captureSmoothingHandles() {
        boolean first = true;
        this.previousSmoothingHandles = Couple.create(null, null);
        for (BezierConnection bezierConnection : this.blockEntity.connections.values()) {
            this.previousSmoothingHandles.set(first, Pair.of((class_243)bezierConnection.starts.getFirst(), bezierConnection.smoothing == null ? 0 : (Integer)bezierConnection.smoothing.getFirst()));
            first = false;
        }
    }

    public void undoSmoothing() {
        class_2338 otherPosition;
        if (this.smoothingAngle.isEmpty()) {
            return;
        }
        if (this.previousSmoothingHandles == null) {
            return;
        }
        if (this.blockEntity.connections.size() == 2) {
            return;
        }
        class_2680 blockState = this.blockEntity.method_11010();
        class_2338 worldPosition = this.blockEntity.method_11016();
        class_1937 level = this.blockEntity.method_10997();
        ArrayList<BezierConnection> validConnections = new ArrayList<BezierConnection>();
        for (BezierConnection bezierConnection : this.blockEntity.connections.values()) {
            otherPosition = bezierConnection.getKey();
            class_2586 otherBE = level.method_8321(otherPosition);
            if (!(otherBE instanceof TrackBlockEntity)) continue;
            TrackBlockEntity tbe = (TrackBlockEntity)otherBE;
            if (!tbe.connections.containsKey(worldPosition)) continue;
            validConnections.add(bezierConnection);
        }
        this.blockEntity.removeInboundConnections(false);
        TrackPropagator.onRailRemoved((class_1936)level, worldPosition, blockState);
        this.blockEntity.connections.clear();
        this.smoothingAngle = Optional.empty();
        for (BezierConnection bezierConnection : validConnections) {
            this.blockEntity.addConnection(this.restoreToOriginalCurve(bezierConnection));
            otherPosition = bezierConnection.getKey();
            class_2680 otherState = level.method_8320(otherPosition);
            if (!(otherState.method_26204() instanceof TrackBlock)) continue;
            level.method_8501(otherPosition, (class_2680)otherState.method_11657((class_2769)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)));
            class_2586 otherBE = level.method_8321(otherPosition);
            if (!(otherBE instanceof TrackBlockEntity)) continue;
            TrackBlockEntity tbe = (TrackBlockEntity)otherBE;
            tbe.addConnection(bezierConnection.secondary());
        }
        this.blockEntity.notifyUpdate();
        this.previousSmoothingHandles = null;
        TrackPropagator.onRailAdded((class_1936)level, worldPosition, blockState);
    }

    public BezierConnection restoreToOriginalCurve(BezierConnection bezierConnection) {
        if (bezierConnection.smoothing != null) {
            bezierConnection.smoothing.setFirst(0);
            if ((Integer)bezierConnection.smoothing.getFirst() == 0 && (Integer)bezierConnection.smoothing.getSecond() == 0) {
                bezierConnection.smoothing = null;
            }
        }
        class_243 raisedStart = (class_243)bezierConnection.starts.getFirst();
        bezierConnection.starts.setFirst(new TrackNodeLocation(raisedStart).getLocation());
        bezierConnection.axes.setFirst(((class_243)bezierConnection.axes.getFirst()).method_18805(1.0, 0.0, 1.0).method_1029());
        return bezierConnection;
    }

    public int getYOffsetForAxisEnd(class_243 end) {
        if (this.smoothingAngle.isEmpty()) {
            return 0;
        }
        for (BezierConnection bezierConnection : this.blockEntity.connections.values()) {
            if (!TrackBlockEntityTilt.compareHandles((class_243)bezierConnection.starts.getFirst(), end)) continue;
            return bezierConnection.yOffsetAt(end);
        }
        if (this.previousSmoothingHandles == null) {
            return 0;
        }
        for (Pair pair : this.previousSmoothingHandles) {
            if (pair == null || !TrackBlockEntityTilt.compareHandles((class_243)pair.getFirst(), end)) continue;
            return (Integer)pair.getSecond();
        }
        return 0;
    }

    public static boolean compareHandles(class_243 handle1, class_243 handle2) {
        return new TrackNodeLocation(handle1).getLocation().method_18805(1.0, 0.0, 1.0).method_1025(new TrackNodeLocation(handle2).getLocation().method_18805(1.0, 0.0, 1.0)) < 0.001953125;
    }
}

