/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.pipes.valve;

import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.PipeAttachmentBlockEntity;
import com.simibubi.create.content.fluids.pipes.StraightPipeBlockEntity;
import com.simibubi.create.content.fluids.pipes.valve.FluidValveBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class FluidValveBlockEntity
extends KineticBlockEntity
implements PipeAttachmentBlockEntity {
    LerpedFloat pointer = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.0, LerpedFloat.Chaser.LINEAR);

    public FluidValveBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        float speed = this.getSpeed();
        this.pointer.chase(speed > 0.0f ? 1.0 : 0.0, this.getChaseSpeed(), LerpedFloat.Chaser.LINEAR);
        this.sendData();
    }

    @Override
    public void tick() {
        super.tick();
        this.pointer.tickChaser();
        if (this.field_11863.field_9236) {
            return;
        }
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof FluidValveBlock)) {
            return;
        }
        boolean stateOpen = (Boolean)blockState.method_11654((class_2769)FluidValveBlock.ENABLED);
        if (stateOpen && this.pointer.getValue() == 0.0f) {
            FluidValveBlockEntity.switchToBlockState(this.field_11863, this.field_11867, (class_2680)blockState.method_11657((class_2769)FluidValveBlock.ENABLED, (Comparable)Boolean.valueOf(false)));
            return;
        }
        if (!stateOpen && this.pointer.getValue() == 1.0f) {
            FluidValveBlockEntity.switchToBlockState(this.field_11863, this.field_11867, (class_2680)blockState.method_11657((class_2769)FluidValveBlock.ENABLED, (Comparable)Boolean.valueOf(true)));
            return;
        }
    }

    private float getChaseSpeed() {
        return class_3532.method_15363((float)(Math.abs(this.getSpeed()) / 16.0f / 20.0f), (float)0.0f, (float)1.0f);
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10566("Pointer", (class_2520)this.pointer.writeNBT());
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.pointer.readNBT(compound.method_10562("Pointer"), clientPacket);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add(new ValvePipeBehaviour(this));
        this.registerAwardables(behaviours, FluidPropagator.getSharedTriggers());
    }

    @Nullable
    public Object getRenderAttachmentData() {
        return PipeAttachmentBlockEntity.getAttachments(this);
    }

    class ValvePipeBehaviour
    extends StraightPipeBlockEntity.StraightPipeFluidTransportBehaviour {
        public ValvePipeBehaviour(SmartBlockEntity be) {
            super(be);
        }

        @Override
        public boolean canHaveFlowToward(class_2680 state, class_2350 direction) {
            return FluidValveBlock.getPipeAxis(state) == direction.method_10166();
        }

        @Override
        public boolean canPullFluidFrom(FluidStack fluid, class_2680 state, class_2350 direction) {
            if (state.method_28498((class_2769)FluidValveBlock.ENABLED) && ((Boolean)state.method_11654((class_2769)FluidValveBlock.ENABLED)).booleanValue()) {
                return super.canPullFluidFrom(fluid, state, direction);
            }
            return false;
        }
    }
}

