/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.simplevillagers.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.samo_lego.simplevillagers.SimpleVillagers;
import org.samo_lego.simplevillagers.block.entity.AbstractFarmBlockEntity;
import org.samo_lego.simplevillagers.gui.VillagerBlockGui;
import org.samo_lego.simplevillagers.gui.slot.FoodSlot;
import org.samo_lego.simplevillagers.gui.slot.OutputSlot;
import org.samo_lego.simplevillagers.gui.slot.VillagerSlot;
import org.samo_lego.simplevillagers.util.VillagerUtil;

public class BreederBlockEntity
extends AbstractFarmBlockEntity {
    public static final class_2960 ID = new class_2960("simplevillagers", "breeder_block_entity");
    private int foodReserves;
    private static final class_1799 babyVillager = new class_1799((class_1935)SimpleVillagers.VILLAGER_ITEM);

    public BreederBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SimpleVillagers.BREEDER_BLOCK_ENTITY, blockPos, blockState);
    }

    @Override
    public void serverTick() {
        this.growBabies(this.getItems().size() - 4);
        if (this.canOperate() && this.foodReserves >= 12 && this.tickCount % SimpleVillagers.CONFIG.breedingTimer == 0) {
            this.tickCount = 0;
            int size = this.getItems().size();
            for (int i = size - 4; i < size; ++i) {
                if (!((class_1799)this.items.get(i)).method_7960()) continue;
                this.decreaseFoodReserves();
                ((class_3218)this.field_11863).method_14199((class_2394)class_2398.field_11201, (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.1);
                class_1799 babyVillager = new class_1799((class_1935)SimpleVillagers.VILLAGER_ITEM);
                class_2487 babyTag = new class_2487();
                babyTag.method_10569("Age", SimpleVillagers.CONFIG.bornBabyAge);
                class_2487 loreTag = new class_2487();
                class_2499 nbtLore = new class_2499();
                nbtLore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43470((String)"Baby"))));
                loreTag.method_10566("Lore", (class_2520)nbtLore);
                babyTag.method_10566("display", (class_2520)loreTag);
                babyVillager.method_7980(babyTag);
                this.items.set(i, (Object)babyVillager.method_7972());
                break;
            }
        }
    }

    @Override
    public int getScreenSize() {
        return 18;
    }

    private void decreaseFoodReserves() {
        List<class_1799> foods = this.items.stream().filter(stack -> class_1646.field_18526.containsKey(stack.method_7909())).toList();
        int leftover = 0;
        for (class_1799 food : foods) {
            int ratio = 12 / (Integer)class_1646.field_18526.get(food.method_7909()) - leftover;
            if (food.method_7947() >= ratio) {
                food.method_7934(ratio);
                break;
            }
            leftover += food.method_7947();
            food.method_7939(0);
        }
        this.foodReserves -= 12;
    }

    @Override
    public void method_11014(@NotNull class_2487 tag) {
        super.method_11014(tag);
        this.foodReserves = this.countFood();
    }

    private int countFood() {
        return class_1646.field_18526.entrySet().stream().mapToInt(entry -> this.method_18861((class_1792)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    @Override
    public void onUse(class_3222 player) {
        class_1799 villagerStack = new class_1799((class_1935)SimpleVillagers.VILLAGER_ITEM);
        villagerStack.method_7977((class_2561)class_2561.method_43471((String)class_1299.field_6077.method_5882()).method_27693(" ->"));
        villagerStack.method_7978(null, 0);
        class_1799 foodStack = new class_1799((class_1935)class_1802.field_8179);
        foodStack.method_7977((class_2561)class_2561.method_43471((String)"itemGroup.food").method_27693(" ->"));
        foodStack.method_7978(null, 0);
        new VillagerBlockGui(class_3917.field_18665, player, this, List.of(Pair.of((Object)villagerStack, (Object)2), Pair.of((Object)foodStack, (Object)4), Pair.of((Object)villagerStack, (Object)4)), this::getSlot).open();
    }

    private class_1735 getSlot(int index) {
        if (index < 2) {
            return new VillagerSlot((class_1263)this, index);
        }
        if (index < 6) {
            return new FoodSlot((class_1263)this, index);
        }
        return new OutputSlot((class_1263)this, index);
    }

    @Override
    protected void updateEmptyStatus(int index) {
        if (index < 2) {
            boolean canOperate = true;
            for (int i = 0; i < 2; ++i) {
                class_1799 stack = (class_1799)this.items.get(i);
                canOperate &= stack.method_7909() == SimpleVillagers.VILLAGER_ITEM && VillagerUtil.isParent(stack);
            }
            if (canOperate != this.canOperate()) {
                this.setOperative(canOperate);
                super.updateEmptyStatus(index);
            }
        } else if (index < 6) {
            this.foodReserves = this.countFood();
        }
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.simplevillagers.breeder");
    }

    public int method_5439() {
        return 10;
    }

    public int[] method_5494(@NotNull class_2350 side) {
        if (side == class_2350.field_11033) {
            return new int[]{6, 7, 8, 9};
        }
        if (side == class_2350.field_11036) {
            return new int[]{0, 1};
        }
        return new int[]{2, 3, 4, 5};
    }

    static {
        class_2487 babyTag = new class_2487();
        babyTag.method_10569("Age", -24000);
        babyVillager.method_7980(babyTag);
    }
}

