/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_429;
import net.minecraft.class_437;
import net.minecraft.class_4398;
import net.minecraft.class_442;
import net.minecraft.class_4439;
import net.minecraft.class_4877;
import net.minecraft.class_500;
import net.minecraft.class_638;
import org.apache.commons.lang3.StringUtils;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiEditMode;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWidgetUpdateAll;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.patreon.Patreon;
import xaero.common.settings.ModSettings;

public class ClientEvents {
    protected IXaeroMinimap modMain;
    private class_437 lastGuiOpen;
    private Field realmsTaskField;
    private Field realmsTaskServerField;
    public class_4877 latestRealm;

    public ClientEvents(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public class_437 handleGuiOpen(class_437 gui) {
        if (gui != null && gui.getClass() == class_429.class) {
            if (!ModSettings.settingsButton) {
                return gui;
            }
            gui = this.modMain.getGuiHelper().getMyOptions();
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        if (gui instanceof class_442 || gui instanceof class_500) {
            this.modMain.getSettings().resetServerSettings();
        }
        class_310 mc = class_310.method_1551();
        if (gui instanceof class_4398) {
            try {
                class_4439 realmsTask;
                class_4877 realm;
                class_4398 realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = Misc.getFieldReflection(class_4398.class, "queuedTasks", "field_19919", "Lnet/minecraft/class_4358;", "f_88773_");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = Misc.getFieldReflection(class_4439.class, "server", "field_20224", "Lnet/minecraft/class_4877;", "f_90327_");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (class_4398)gui)) instanceof class_4439 && (realm = (class_4877)this.realmsTaskServerField.get(realmsTask = (class_4439)task)) != null && (this.latestRealm == null || realm.field_22599 != this.latestRealm.field_22599)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        } else if ((gui instanceof GuiAddWaypoint || gui instanceof GuiWaypoints) && (mc.field_1724.method_6059(Effects.NO_WAYPOINTS) || mc.field_1724.method_6059(Effects.NO_WAYPOINTS_HARMFUL))) {
            gui = null;
        }
        this.lastGuiOpen = gui;
        return gui;
    }

    public void handleRenderGameOverlayEventPre(class_332 guiGraphics, float partialTicks) {
        if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)256)) {
            GuiEditMode.cancel(this.modMain.getInterfaces());
        }
    }

    public void handleRenderGameOverlayEventPost() {
        this.modMain.getInterfaces().onPostGameOverlay();
    }

    public boolean handleClientSendChatEvent(String message) {
        if (message.startsWith("xaero_waypoint_add:")) {
            String[] args = message.split(":");
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointAdd(args);
            return true;
        }
        if (message.equals("xaero_tp_anyway")) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointsManager().teleportAnyway();
            return true;
        }
        return false;
    }

    public boolean handleClientPlayerChatReceivedEvent(class_2556.class_7602 chatType, class_2561 component, GameProfile gameProfile) {
        if (component == null) {
            return false;
        }
        return this.handleChatMessage(gameProfile == null ? class_1074.method_4662((String)"gui.xaero_waypoint_somebody_shared", (Object[])new Object[0]) : gameProfile.getName(), component);
    }

    public boolean handleClientSystemChatReceivedEvent(class_2561 component) {
        String probableName;
        XaeroMinimapSession minimapSession;
        if (component == null) {
            return false;
        }
        String textString = component.getString();
        if (textString.contains("\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
            minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getMinimapProcessor().setNoMinimapMessageReceived(false);
            minimapSession.getMinimapProcessor().setFairPlayOnlyMessageReceived(false);
        }
        if (textString.contains("\u00a7n\u00a7o\u00a7m\u00a7i\u00a7n\u00a7i\u00a7m\u00a7a\u00a7p")) {
            minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getMinimapProcessor().setNoMinimapMessageReceived(true);
        }
        if (textString.contains("\u00a7f\u00a7a\u00a7i\u00a7r\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
            minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getMinimapProcessor().setFairPlayOnlyMessageReceived(true);
        }
        return this.handleChatMessage((probableName = StringUtils.substringBetween((String)textString, (String)"<", (String)">")) == null ? class_1074.method_4662((String)"gui.xaero_waypoint_server_shared", (Object[])new Object[0]) : probableName, component);
    }

    private boolean handleChatMessage(String playerName, class_2561 text) {
        String textString = text.getString();
        if (textString.contains("xaero_waypoint:") || textString.contains("xaero-waypoint:")) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointReceived(playerName, textString);
            return true;
        }
        return false;
    }

    public void handleDrawScreenEventPost(class_437 gui) {
        if (Patreon.needsNotification() && gui instanceof class_442) {
            class_310.method_1551().method_1507((class_437)new GuiWidgetUpdateAll(this.modMain));
        } else if (this.modMain.isOutdated()) {
            this.modMain.setOutdated(false);
        }
    }

    public void handlePlayerSetSpawnEvent(class_2338 newSpawnPoint, class_1937 world) {
        XaeroMinimapSession minimapSession;
        if (world instanceof class_638 && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            minimapSession.getWaypointsManager().setCurrentSpawn(newSpawnPoint, (class_638)world);
        }
    }

    public Object getLastGuiOpen() {
        return this.lastGuiOpen;
    }

    public void worldUnload(class_1936 world) {
        XaeroMinimapSession minimapSession;
        if (world instanceof class_638 && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            MinimapProcessor minimap = minimapSession.getMinimapProcessor();
            minimap.getEntityRadar().updateRadar(null, null, null, minimap);
        }
    }

    public void handleClientTickStart() {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            MinimapProcessor minimap = minimapSession.getMinimapProcessor();
            minimap.onClientTick();
            if (class_310.method_1551().field_1755 == null) {
                minimapSession.getKeyEventHandler().onKeyInput(class_310.method_1551(), this.modMain, minimapSession);
            }
        }
    }

    public void handlePlayerTickStart(class_1657 player) {
        if (player != class_310.method_1551().field_1724) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            try {
                MinimapProcessor minimap = minimapSession.getMinimapProcessor();
                WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
                waypointsManager.updateWorldIds();
                minimap.onPlayerTick();
                waypointsManager.updateWaypoints();
                class_310 mc = class_310.method_1551();
                minimapSession.getKeyEventHandler().handleEvents(mc, minimapSession);
                this.modMain.getForgeEventHandlerListener().playerTickPost(minimapSession);
            }
            catch (Throwable t) {
                this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(t);
            }
        }
    }

    public void handleRenderTickStart() {
        if (class_310.method_1551().field_1724 != null) {
            this.modMain.getInterfaces().getMinimapInterface().checkCrashes();
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                MinimapProcessor minimap = minimapSession.getMinimapProcessor();
                minimap.getMinimapWriter().onRender();
            }
        }
    }

    public boolean handleRenderStatusEffectOverlay(class_332 guiGraphics) {
        return this.modMain.getForgeEventHandlerListener().handleRenderStatusEffectOverlay(guiGraphics);
    }

    protected boolean handleRenderCrosshairOverlay(class_332 guiGraphics) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            return minimapSession.getMinimapProcessor().isEnlargedMap() && this.modMain.getSettings().centeredEnlarged;
        }
        return false;
    }
}

