/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.BlackBoardButton;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetBlackboardPacket;
import net.mehvahdjukaar.supplementaries.common.utils.CircularList;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.ImmediatelyFastCompat;
import net.minecraft.class_2561;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class BlackBoardScreen
extends class_437 {
    private static final class_5250 CLEAR = class_2561.method_43471((String)"gui.supplementaries.blackboard.clear");
    private static final class_5250 UNDO = class_2561.method_43471((String)"gui.supplementaries.blackboard.undo");
    private static final class_5250 EDIT = class_2561.method_43471((String)"gui.supplementaries.blackboard.edit");
    private final BlackboardBlockTile tile;
    private final BlackBoardButton[][] buttons = new BlackBoardButton[16][16];
    private final Deque<List<Entry>> history = new CircularList<List<Entry>>(20);
    private List<Entry> currentHistoryStep = new ArrayList<Entry>();
    private class_4185 historyButton;

    private BlackBoardScreen(BlackboardBlockTile teBoard) {
        super((class_2561)EDIT);
        this.tile = teBoard;
    }

    public static void open(BlackboardBlockTile sign) {
        class_310.method_1551().method_1507((class_437)new BlackBoardScreen(sign));
    }

    public void method_25393() {
        if (!this.isValid()) {
            this.method_25419();
        } else if (!(this.method_25399() instanceof BlackBoardButton)) {
            this.method_25395(null);
        }
    }

    private boolean isValid() {
        return this.field_22787 != null && this.field_22787.field_1724 != null && !this.tile.method_11015() && !this.tile.playerIsTooFarAwayToEdit(this.tile.method_10997(), this.tile.method_11016(), this.field_22787.field_1724.method_5667());
    }

    public void method_25419() {
        this.tile.method_5431();
        super.method_25419();
    }

    public void method_25432() {
        byte[][] pixels = new byte[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = this.buttons[xx][yy].getColor();
            }
        }
        ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundSetBlackboardPacket(this.tile.method_11016(), pixels));
    }

    public void updateBlackboard(int x, int y, byte newColor) {
        this.tile.setPixel(x, y, newColor);
    }

    public void addHistory(int x, int y, byte oldColor) {
        this.currentHistoryStep.add(new Entry(x, y, oldColor));
    }

    public void saveHistoryStep() {
        if (!this.currentHistoryStep.isEmpty()) {
            this.history.add(this.currentHistoryStep);
            this.currentHistoryStep = new ArrayList<Entry>();
            this.historyButton.field_22763 = true;
        }
    }

    public void onButtonDragged(double mx, double my, byte buttonValue) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                BlackBoardButton b = this.buttons[xx][yy];
                if (!b.method_25405(mx, my) || b.getColor() == buttonValue) continue;
                b.setColor(buttonValue);
            }
        }
    }

    private void clearPressed(class_4185 button) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy].setColor((byte)0);
            }
        }
        this.saveHistoryStep();
    }

    private void undoPressed(class_4185 button) {
        if (!this.history.isEmpty()) {
            for (Entry v : this.history.pollLast()) {
                this.buttons[v.x()][v.y()].setColor(v.color());
            }
            this.currentHistoryStep.clear();
        }
        if (this.history.isEmpty()) {
            this.historyButton.field_22763 = false;
        }
    }

    protected void method_25426() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                byte pixel = this.tile.getPixel(xx, yy);
                BlackBoardButton widget = new BlackBoardButton(this.field_22789 / 2, 65, xx, yy, this, pixel);
                this.buttons[xx][yy] = (BlackBoardButton)this.method_37063(widget);
            }
        }
        int buttonW = 56;
        int sep = 4;
        this.method_37063((class_364)class_4185.method_46430((class_2561)CLEAR, this::clearPressed).method_46434(this.field_22789 / 2 - buttonW / 2 - buttonW + sep / 2, this.field_22790 / 4 + 120, buttonW - sep, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - buttonW / 2 + sep / 2, this.field_22790 / 4 + 120, buttonW - sep, 20).method_46431());
        this.historyButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)UNDO, this::undoPressed).method_46434(this.field_22789 / 2 + buttonW / 2 + sep / 2, this.field_22790 / 4 + 120, buttonW - sep, 20).method_46431());
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (CompatHandler.IMMEDIATELY_FAST) {
            ImmediatelyFastCompat.startBatching();
        }
        class_308.method_24210();
        this.method_25420(graphics);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 40, 0xFFFFFF);
        graphics.method_51448().method_22903();
        int ut = -1;
        int vt = -1;
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                if (this.buttons[xx][yy].isHovered()) {
                    ut = xx;
                    vt = yy;
                }
                this.buttons[xx][yy].method_25394(graphics, mouseX, mouseY, partialTicks);
            }
        }
        if (ut != -1) {
            this.buttons[ut][vt].renderTooltip(graphics);
        }
        graphics.method_51448().method_22909();
        class_308.method_24211();
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (CompatHandler.IMMEDIATELY_FAST) {
            ImmediatelyFastCompat.endBatching();
        }
    }

    private record Entry(int x, int y, byte color) {
    }
}

