/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.docs;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import com.probejs.ProbeConfig;
import com.probejs.ProbeJS;
import com.probejs.ProbePaths;
import com.probejs.docs.DummyBindingEvent;
import com.probejs.docs.EventCompiler;
import com.probejs.docs.formatter.ClassResolver;
import com.probejs.docs.formatter.NameResolver;
import com.probejs.docs.formatter.SpecialTypes;
import com.probejs.docs.formatter.formatter.FormatterNamespace;
import com.probejs.docs.formatter.formatter.jdoc.FormatterClass;
import com.probejs.jdoc.Manager;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.DocumentClass;
import com.probejs.jdoc.java.Walker;
import com.probejs.jdoc.jsgen.DocGenerationEventJS;
import com.probejs.jdoc.property.PropertyComment;
import com.probejs.specials.RawCompiler;
import com.probejs.specials.RegistryCompiler;
import com.probejs.specials.SchemaCompiler;
import com.probejs.specials.SpecialCompiler;
import com.probejs.specials.TagEventCompiler;
import com.probejs.specials.assign.ClassAssignmentManager;
import com.probejs.specials.special.FormatterComponents;
import com.probejs.util.PlatformSpecial;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.event.EventGroupWrapper;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.recipe.schema.RecipeNamespace;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.server.ServerScriptManager;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaClass;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DocCompiler {
    private static final int CHUNK_SIZE = 128;

    public static void compileInternal(Collection<DocumentClass> internalClasses, int index) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.INTERNALS.resolve("internal_" + index + ".d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./internal_*.d.ts\" />\n");
        ArrayListMultimap namespaces = ArrayListMultimap.create();
        for (DocumentClass clazz : internalClasses) {
            FormatterClass formatter = new FormatterClass(clazz);
            NameResolver.ResolvedName resolvedName = NameResolver.getResolvedName(clazz.getName());
            if (resolvedName.getNamespace().isEmpty()) {
                throw new RuntimeException("Internal class %s cannot be in the root namespace!".formatted(resolvedName.getFullName()));
            }
            namespaces.put((Object)resolvedName.getNamespace(), (Object)formatter.setInternal(true));
        }
        for (String key : namespaces.keySet()) {
            Collection formatters = namespaces.get((Object)key);
            FormatterNamespace namespace = new FormatterNamespace(key, formatters);
            writer.write(namespace.formatString(0, 4) + "\n");
        }
        writer.close();
    }

    public static void compileInternals(Collection<DocumentClass> internalClasses) throws IOException {
        BufferedWriter indexWriter = Files.newBufferedWriter(ProbePaths.INTERNALS.resolve("index.d.ts"), new OpenOption[0]);
        indexWriter.close();
        int index = 0;
        ArrayList<DocumentClass> chunk = new ArrayList<DocumentClass>();
        for (DocumentClass clazz : internalClasses) {
            chunk.add(clazz);
            if (chunk.size() < 128) continue;
            DocCompiler.compileInternal(chunk, index++);
            chunk.clear();
        }
        if (!chunk.isEmpty()) {
            DocCompiler.compileInternal(chunk, index);
        }
    }

    public static void compileGlobal(Collection<DocumentClass> globalClasses) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("globals.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./internals/internal_*.d.ts\" />\n");
        ArrayList<DocumentClass> internalClasses = new ArrayList<DocumentClass>();
        for (DocumentClass clazz : globalClasses) {
            FormatterClass formatter = new FormatterClass(clazz);
            NameResolver.ResolvedName resolvedName = NameResolver.getResolvedName(clazz.getName());
            if (resolvedName.getNamespace().isEmpty()) {
                writer.write(formatter.formatString(0, 4) + "\n");
                if (!clazz.isInterface()) continue;
                writer.write("declare const %s: %s;\n".formatted(resolvedName.getFullName(), resolvedName.getFullName()));
                continue;
            }
            clazz.getConstructors().forEach(constructor -> constructor.addProperty(new PropertyComment("Internal constructor, this means that it's not valid unless you use `java()`.")));
            internalClasses.add(clazz);
        }
        FormatterNamespace specialNamespace = new FormatterNamespace("Special", SpecialCompiler.compileSpecial());
        writer.write(specialNamespace.formatString(0, 4) + "\n");
        writer.close();
        DocCompiler.compileInternals(internalClasses);
    }

    public static Set<Class<?>> readCachedClasses(String fileName) throws IOException {
        HashSet cachedClasses = new HashSet();
        Path cachedClassesPath = ProbePaths.CACHE.resolve(fileName);
        if (Files.exists(cachedClassesPath, new LinkOption[0])) {
            try {
                List cachedList = (List)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(cachedClassesPath), List.class);
                cachedList.forEach(c -> {
                    try {
                        Class<?> clazz = Class.forName((String)c);
                        cachedClasses.add(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        ProbeJS.LOGGER.warn("Class %s was in the cache, but disappeared in packages now.".formatted(c));
                    }
                });
            }
            catch (JsonIOException | JsonSyntaxException e) {
                ProbeJS.LOGGER.warn("Cannot read malformed cache, ignoring.");
            }
        }
        return cachedClasses;
    }

    public static void writeCachedClasses(String fileName, Set<Class<?>> javaClasses) throws IOException {
        BufferedWriter cacheWriter = Files.newBufferedWriter(ProbePaths.CACHE.resolve(fileName), new OpenOption[0]);
        JsonArray outJson = new JsonArray();
        for (Class<?> clazz : javaClasses) {
            outJson.add(clazz.getName());
        }
        ProbeJS.GSON.toJson((JsonElement)outJson, (Appendable)cacheWriter);
        cacheWriter.close();
    }

    public static Map<String, Class<?>> readCachedForgeEvents(String fileName) throws IOException {
        HashMap cachedEvents = new HashMap();
        Path cachedEventPath = ProbePaths.CACHE.resolve(fileName);
        if (Files.exists(cachedEventPath, new LinkOption[0])) {
            try {
                Map cachedMap = (Map)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(cachedEventPath), Map.class);
                cachedMap.forEach((k, v) -> {
                    if (k instanceof String && v instanceof String) {
                        try {
                            Class<?> clazz = Class.forName((String)v);
                            if (EventJS.class.isAssignableFrom(clazz)) {
                                cachedEvents.put((String)k, clazz);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            ProbeJS.LOGGER.warn("Class %s was in the cache, but disappeared in packages now.".formatted(v));
                        }
                    }
                });
            }
            catch (JsonIOException | JsonSyntaxException e) {
                ProbeJS.LOGGER.warn("Cannot read malformed cache, ignoring.");
            }
        }
        return cachedEvents;
    }

    public static void writeCachedForgeEvents(String fileName, Map<String, Class<?>> events) throws IOException {
        BufferedWriter cacheWriter = Files.newBufferedWriter(ProbePaths.CACHE.resolve(fileName), new OpenOption[0]);
        JsonObject outJson = new JsonObject();
        for (Map.Entry<String, Class<?>> entry : events.entrySet()) {
            String eventName = entry.getKey();
            Class<?> eventClass = entry.getValue();
            outJson.addProperty(eventName, eventClass.getName());
        }
        ProbeJS.GSON.toJson((JsonElement)outJson, (Appendable)cacheWriter);
        cacheWriter.close();
    }

    private static Set<Class<?>> fetchRecipeClasses() {
        return RecipeNamespace.getAll().values().stream().flatMap(namespace -> namespace.values().stream()).map(type -> type.schema.recipeType).collect(Collectors.toSet());
    }

    private static Set<Class<?>> fetchComponentClasses() {
        return RecipeNamespace.getAll().values().stream().flatMap(namespace -> namespace.values().stream()).flatMap(type -> Arrays.stream(type.schema.keys)).map(key -> key.component.componentClass()).map(clazz -> clazz.isArray() ? clazz.getComponentType() : clazz).filter(clazz -> !NameResolver.resolvedPrimitives.contains(clazz.getName())).collect(Collectors.toSet());
    }

    public static Set<Class<?>> fetchClasses(Set<Class<?>> typeMap, DummyBindingEvent bindingEvent, Set<Class<?>> cachedClasses) {
        HashSet touchableClasses = new HashSet(bindingEvent.getClassDumpMap().values());
        touchableClasses.addAll(cachedClasses);
        touchableClasses.addAll(typeMap);
        bindingEvent.getConstantDumpMap().values().stream().map(DummyBindingEvent::getConstantClassRecursive).forEach(touchableClasses::addAll);
        touchableClasses.addAll(CapturedClasses.getCapturedRawEvents().values());
        touchableClasses.addAll(CapturedClasses.getCapturedJavaClasses());
        touchableClasses.addAll(DocCompiler.fetchRecipeClasses());
        touchableClasses.addAll(DocCompiler.fetchComponentClasses());
        touchableClasses.addAll(FormatterComponents.loadComponentsClasses());
        touchableClasses.addAll((Collection<Class<?>>)ClassAssignmentManager.ASSIGNMENTS.keys());
        Walker walker = new Walker(touchableClasses);
        return walker.walk();
    }

    public static void compileConstants(DummyBindingEvent bindingEvent) throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("constants.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        for (Map.Entry<String, Object> entry : bindingEvent.getConstantDumpMap().entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof EventGroupWrapper) continue;
            writer.write("declare const %s: %s;\n".formatted(name, Objects.requireNonNull(Serde.getValueFormatter(Serde.getValueProperty(value))).formatFirst()));
        }
        writer.close();
    }

    public static void compileJSConfig() throws IOException {
        DocCompiler.writeMergedConfig(KubeJSPaths.DIRECTORY.resolve("jsconfig.json"), "{\n    \"compilerOptions\": {\n        \"lib\": [\"ES5\", \"ES2015\"],\n        \"rootDirs\": [\"probe/generated\", \"probe/user\", \"server_scripts\", \"startup_scripts\", \"client_scripts\"],\n        \"target\": \"ES2015\"\n    }\n}");
    }

    public static void compileVSCodeConfig() throws IOException {
        DocCompiler.writeMergedConfig(ProbePaths.WORKSPACE_SETTINGS.resolve("settings.json"), "{\n    \"json.schemas\": [\n            {\n                \"fileMatch\": [\n                    \"/lang/*.json\"\n                ],\n                \"url\": \"./.vscode/probe.lang-schema.json\"\n            },\n            {\n                \"fileMatch\": [\n                    \"/probe/docs/*.json\"\n                ],\n                \"url\": \"./.vscode/probe.doc-schema.json\"\n            }\n    ]\n}\n");
    }

    public static void compileGitIgnore() throws IOException {
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.PROBE.resolve(".gitignore"), new OpenOption[0]);
        writer.write("*\n");
        writer.write("*/\n");
        writer.close();
    }

    private static JsonElement mergeJsonRecursively(JsonElement first, JsonElement second) {
        if (first instanceof JsonObject) {
            JsonObject firstObject = (JsonObject)first;
            if (second instanceof JsonObject) {
                JsonObject secondObject = (JsonObject)second;
                JsonObject result = firstObject.deepCopy();
                for (Map.Entry entry : secondObject.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement value = (JsonElement)entry.getValue();
                    if (result.has(key)) {
                        result.add(key, DocCompiler.mergeJsonRecursively(result.get(key), value));
                        continue;
                    }
                    result.add(key, value);
                }
                return result;
            }
        }
        if (first instanceof JsonArray) {
            JsonArray firstArray = (JsonArray)first;
            if (second instanceof JsonArray) {
                JsonArray secondArray = (JsonArray)second;
                ArrayList<JsonElement> elements = new ArrayList<JsonElement>();
                for (JsonElement element : firstArray) {
                    elements.add(element.deepCopy());
                }
                for (JsonElement element : secondArray) {
                    int index = elements.indexOf(element);
                    if (index != -1) {
                        elements.set(index, DocCompiler.mergeJsonRecursively((JsonElement)elements.get(index), element));
                        continue;
                    }
                    elements.add(element);
                }
                JsonArray result = new JsonArray();
                for (JsonElement element : elements) {
                    result.add(element);
                }
                return result;
            }
        }
        return second;
    }

    private static void writeMergedConfig(Path path, String config) throws IOException {
        JsonObject read;
        JsonObject updates = (JsonObject)ProbeJS.GSON.fromJson(config, JsonObject.class);
        JsonObject jsonObject = read = Files.exists(path, new LinkOption[0]) ? (JsonObject)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(path), JsonObject.class) : new JsonObject();
        if (read == null) {
            read = new JsonObject();
        }
        JsonObject original = (JsonObject)DocCompiler.mergeJsonRecursively((JsonElement)read, (JsonElement)updates);
        JsonWriter jsonWriter = ProbeJS.GSON_WRITER.newJsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));
        jsonWriter.setIndent("    ");
        ProbeJS.GSON_WRITER.toJson((Object)original, JsonObject.class, jsonWriter);
        jsonWriter.close();
    }

    private static void exportClasses(List<DocumentClass> documents, Path path) throws IOException {
        JsonArray classes = new JsonArray();
        documents.forEach(document -> classes.add((JsonElement)document.serialize()));
        BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
        JsonWriter jsonWriter = ProbeJS.GSON_WRITER.newJsonWriter((Writer)writer);
        jsonWriter.setIndent("    ");
        ProbeJS.GSON_WRITER.toJson((Object)classes, JsonArray.class, jsonWriter);
        jsonWriter.close();
    }

    private static void exportSerializedClasses(List<DocumentClass> documents, List<DocumentClass> mergedDocuments) throws IOException {
        DocCompiler.exportClasses(documents, ProbePaths.CACHE.resolve("javaClasses.json"));
        DocCompiler.exportClasses(mergedDocuments, ProbePaths.CACHE.resolve("mergedClasses.json"));
    }

    private static DummyBindingEvent fetchBindings(ScriptManager manager) {
        DummyBindingEvent bindingEvent = new DummyBindingEvent();
        for (Object id : manager.topLevelScope.getIds(manager.context)) {
            if (!(id instanceof String)) continue;
            String string = (String)id;
            Object value = manager.topLevelScope.get(manager.context, string, manager.topLevelScope);
            if (value instanceof NativeJavaClass) {
                NativeJavaClass clazz = (NativeJavaClass)value;
                bindingEvent.add(string, clazz.getClassObject());
                continue;
            }
            bindingEvent.add(string, Context.jsToJava((Context)manager.context, (Object)value, Object.class));
        }
        return bindingEvent;
    }

    public static void compile(Consumer<String> sendMessage, DocGenerationEventJS event) throws IOException {
        PlatformSpecial.INSTANCE.get().preCompile();
        DummyBindingEvent bindingEvent = DocCompiler.fetchBindings(ServerScriptManager.getScriptManager()).merge(DocCompiler.fetchBindings(KubeJS.getClientScriptManager())).merge(DocCompiler.fetchBindings(KubeJS.getStartupScriptManager()));
        sendMessage.accept("KubeJS plugins reloaded.");
        CapturedClasses.capturedRawEvents.putAll(DocCompiler.readCachedForgeEvents("cachedForgeEvents.json"));
        CapturedClasses.capturedJavaClasses.addAll(DocCompiler.readCachedClasses("cachedJava.json"));
        HashSet cachedClasses = new HashSet();
        cachedClasses.addAll(EventCompiler.fetchEventClasses());
        cachedClasses.addAll(CapturedClasses.capturedRawEvents.values());
        cachedClasses.addAll(CapturedClasses.capturedJavaClasses);
        cachedClasses.addAll(RegistryCompiler.getKJSRegistryClasses());
        if (ProbeConfig.INSTANCE.allowRegistryObjectDumps) {
            cachedClasses.addAll(SpecialTypes.collectRegistryClasses());
        }
        Set<Class<?>> typeMap = RecipeNamespace.getAll().values().stream().flatMap(namespace -> namespace.values().stream()).map(type -> type.schema.recipeType).collect(Collectors.toSet());
        Set<Class<?>> globalClasses = DocCompiler.fetchClasses(typeMap, bindingEvent, cachedClasses);
        sendMessage.accept("Classes fetched.");
        globalClasses.removeIf(c -> ClassResolver.skipped.contains(c));
        bindingEvent.getClassDumpMap().forEach((s, c) -> NameResolver.putResolvedName(c, s));
        SpecialTypes.processEnums(globalClasses);
        List<DocumentClass> javaDocs = Manager.loadJavaClasses(globalClasses);
        javaDocs.addAll(PlatformSpecial.INSTANCE.get().getPlatformDocuments(javaDocs));
        sendMessage.accept("Started downloading and merging docs...");
        Manager.downloadDocs();
        List<DocumentClass> fetchedDocs = Manager.loadFetchedClassDoc();
        List<DocumentClass> modDocs = Manager.loadModDocuments();
        Map<String, DocumentClass> mergedDocsMap = Manager.mergeDocuments(javaDocs, fetchedDocs, modDocs);
        event.getTransformers().forEach((key, transformer) -> {
            if (mergedDocsMap.containsKey(key)) {
                transformer.forEach(t -> t.accept((DocumentClass)mergedDocsMap.get(key)));
            }
        });
        List<DocumentClass> mergedDocs = mergedDocsMap.values().stream().toList();
        sendMessage.accept("Docs merged. Started compiling...");
        NameResolver.priorSortClasses(mergedDocs).forEach(NameResolver::resolveName);
        SpecialCompiler.specialCompilers.addAll(event.getSpecialFormatters());
        if (ProbeConfig.INSTANCE.dumpJSONIntermediates) {
            DocCompiler.exportSerializedClasses(javaDocs, mergedDocs);
        }
        DocCompiler.compileGlobal(mergedDocs);
        RegistryCompiler.compileRegistryEvents();
        TagEventCompiler.compileTagEvents();
        EventCompiler.initSpecialEvents();
        EventCompiler.compileEvents(mergedDocsMap);
        DocCompiler.compileConstants(bindingEvent);
        DocCompiler.compileAdditionalTypeNames();
        RawCompiler.compileRaw();
        DocCompiler.compileJSConfig();
        DocCompiler.compileVSCodeConfig();
        DocCompiler.compileGitIgnore();
        SchemaCompiler.compile(mergedDocs);
        DocCompiler.writeCachedForgeEvents("cachedForgeEvents.json", CapturedClasses.getCapturedRawEvents());
        DocCompiler.writeCachedClasses("cachedJava.json", CapturedClasses.capturedJavaClasses);
    }

    public static void compileAdditionalTypeNames() throws IOException {
        Path path = ProbePaths.GENERATED.resolve("names.d.ts");
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        BufferedWriter writer = Files.newBufferedWriter(ProbePaths.GENERATED.resolve("names.d.ts"), new OpenOption[0]);
        writer.write("/// <reference path=\"./globals.d.ts\" />\n");
        for (Map.Entry<String, List<NameResolver.ResolvedName>> entry : NameResolver.resolvedNames.entrySet()) {
            List<NameResolver.ResolvedName> exportedNames = entry.getValue();
            if (exportedNames.size() <= 1) continue;
            for (int i = 1; i < exportedNames.size(); ++i) {
                if (NameResolver.resolvedPrimitives.contains(exportedNames.get(i).getLastName()) || exportedNames.get(0).getLastName().equals("any") || exportedNames.get(0).getLastName().equals(exportedNames.get(i).getLastName())) continue;
                writer.write("const %s: typeof %s\n".formatted(exportedNames.get(i).getLastName(), exportedNames.get(0).getLastName()));
            }
        }
        writer.close();
    }

    public static class CapturedClasses {
        public static Map<String, Class<?>> capturedRawEvents = new ConcurrentHashMap();
        public static Set<Class<?>> capturedJavaClasses = new HashSet();

        public static Map<String, Class<?>> getCapturedRawEvents() {
            return ImmutableMap.copyOf(capturedRawEvents);
        }

        public static Set<Class<?>> getCapturedJavaClasses() {
            return ImmutableSet.copyOf(capturedJavaClasses);
        }
    }
}

