/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.commandconfig.impl.option;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import dev.kikugie.commandconfig.Reference;
import dev.kikugie.commandconfig.api.builders.ListOptionBuilder;
import dev.kikugie.commandconfig.api.option.access.ListElementAccess;
import dev.kikugie.commandconfig.impl.builders.OptionBuilderImpl;
import dev.kikugie.commandconfig.impl.command.ListArgumentType;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ListOptionBuilderImpl<L extends List<T>, T, S extends class_2172, U extends ArgumentType<T>>
extends OptionBuilderImpl<L, S>
implements ListOptionBuilder<L, T, S> {
    private final ListArgumentType<T, U> listArgumentType;
    private final U argumentType;
    private final Class<T> valueType;
    private final String typeName;
    private ListElementAccess<T, S> elementAccess;

    public ListOptionBuilderImpl(String name, ListArgumentType<T, U> listArgumentType, U argumentType, Class<T> valueType, Class<S> type) {
        super(name, type);
        this.listArgumentType = listArgumentType;
        this.argumentType = argumentType;
        this.valueType = valueType;
        this.typeName = valueType.getSimpleName();
    }

    @Override
    public ListOptionBuilder<L, T, S> elementAccess(@NotNull ListElementAccess<T, S> access) {
        Validate.notNull(access, (String)Reference.optionError(this.name, "Element access can't be null for %s \"%s\""), (Object[])new Object[0]);
        this.elementAccess = access.name(this.name);
        return this;
    }

    @Override
    public ListOptionBuilder<L, T, S> elementAccess(@NotNull BiFunction<CommandContext<S>, Integer, class_2561> getter, @NotNull TriFunction<CommandContext<S>, Integer, T, class_2561> setter, @NotNull BiFunction<CommandContext<S>, T, class_2561> appender, @NotNull BiFunction<CommandContext<S>, Integer, Pair<@Nullable T, class_2561>> remover) {
        this.elementAccess = new ListElementAccess<T, S>(this.name, getter, setter, appender, remover);
        return this;
    }

    @Override
    public ListOptionBuilder<L, T, S> elementAccess(@NotNull Function<Integer, class_2561> getter, @NotNull BiFunction<Integer, T, class_2561> setter, @NotNull Function<T, class_2561> appender, @NotNull Function<Integer, Pair<@Nullable T, class_2561>> remover) {
        this.elementAccess = new ListElementAccess(this.name, (context, index) -> (class_2561)getter.apply((Integer)index), (context, index, val) -> (class_2561)setter.apply((Integer)index, (Object)val), (context, val) -> (class_2561)appender.apply(val), (context, index) -> (Pair)remover.apply((Integer)index));
        return this;
    }

    @Override
    public ListOptionBuilder<L, T, S> elementListener(@NotNull BiConsumer<String, T> listener) {
        Validate.notNull(listener, (String)Reference.optionError(this.name, "Listener can't be null for %s \"%s\""), (Object[])new Object[0]);
        Validate.notNull(this.elementAccess, (String)Reference.optionError(this.name, "No element access for list %s \"%s\".\nAdd it using `elementAccess()` before adding listeners."), (Object[])new Object[0]);
        this.elementAccess.addListener(listener);
        return this;
    }

    @Override
    @NotNull
    public LiteralArgumentBuilder<S> build() {
        Validate.notNull((Object)this.printFunc, (String)Reference.optionError(this.name, "No print function for %s \"%s\".\nAdd it using `printFunc` on current or any higher node."), (Object[])new Object[0]);
        if (this.extraNodes.isEmpty()) {
            Validate.notNull((Object)this.valueAccess, (String)Reference.optionError(this.name, "No value access for %s \"%s\".\nAdd it using `valueAccess()`."), (Object[])new Object[0]);
        }
        LiteralArgumentBuilder option = LiteralArgumentBuilder.literal((String)this.name);
        this.extraNodes.forEach(it -> it.accept(option));
        if (this.valueAccess == null) {
            return option;
        }
        option.then(this.list());
        if (this.elementAccess != null) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)option.then(this.append())).then(this.put())).then(this.get())).then(this.remove());
        }
        return option;
    }

    private LiteralArgumentBuilder<S> list() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"list").executes(context -> (Integer)this.printFunc.apply(context, this.valueAccess.get(context)))).then(RequiredArgumentBuilder.argument((String)(this.typeName + "..."), this.listArgumentType).executes(context -> {
            List val = ListArgumentType.getList(context, this.typeName + "...");
            int res = this.print(context, this.valueAccess.set(context, val));
            this.save();
            return res;
        }));
    }

    private LiteralArgumentBuilder<S> append() {
        return (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"add").then(RequiredArgumentBuilder.argument((String)this.typeName, this.argumentType).executes(context -> {
            Object val = context.getArgument(this.typeName, this.valueType);
            int res = this.print(context, this.elementAccess.append(context, val));
            this.save();
            return res;
        }));
    }

    private LiteralArgumentBuilder<S> get() {
        return (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"get").then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int index = (Integer)context.getArgument("index", Integer.class);
            int res = this.print(context, this.elementAccess.get(context, index));
            this.save();
            return res;
        }));
    }

    private LiteralArgumentBuilder<S> remove() {
        return (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"remove").then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            int index = (Integer)context.getArgument("index", Integer.class);
            int res = this.print(context, this.elementAccess.remove(context, index));
            this.save();
            return res;
        }));
    }

    private LiteralArgumentBuilder<S> put() {
        return (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"set").then(RequiredArgumentBuilder.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).then(RequiredArgumentBuilder.argument((String)this.typeName, this.argumentType).executes(context -> {
            Object val = context.getArgument(this.typeName, this.valueType);
            int index = (Integer)context.getArgument("index", Integer.class);
            int res = this.print(context, this.elementAccess.set(context, index, val));
            this.save();
            return res;
        })));
    }
}

