/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.commandconfig.impl.builders;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.kikugie.commandconfig.Reference;
import dev.kikugie.commandconfig.api.builders.CategoryBuilder;
import dev.kikugie.commandconfig.api.builders.OptionBuilder;
import dev.kikugie.commandconfig.impl.builders.CommandNodeImpl;
import dev.kikugie.commandconfig.impl.builders.OptionBuilderImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CategoryBuilderImpl<S extends class_2172>
extends CommandNodeImpl<S>
implements CategoryBuilder<S> {
    protected final List<CategoryBuilderImpl<S>> categories = new ArrayList<CategoryBuilderImpl<S>>();
    protected final List<OptionBuilderImpl<?, S>> options = new ArrayList();
    protected final List<Consumer<LiteralArgumentBuilder<S>>> extraNodes = new ArrayList<Consumer<LiteralArgumentBuilder<S>>>();

    public CategoryBuilderImpl(String name, Class<S> type) {
        super(name, type);
        Validate.matchesPattern((CharSequence)name, (String)"^[a-zA-Z0-9-_]+$", (String)Reference.categoryError(name, "Invalid name for %s: \"%s\".\nOption and category names can only contain letters, numbers, dashes and underscores without spaces."), (Object[])new Object[0]);
    }

    @Override
    public CategoryBuilder<S> node(@NotNull Consumer<LiteralArgumentBuilder<S>> node) {
        Validate.notNull(node, (String)Reference.categoryError(this.name, "Custom node can't be null for %s \"%s\""), (Object[])new Object[0]);
        this.extraNodes.add(node);
        return this;
    }

    @Override
    public CategoryBuilder<S> category(@NotNull Function<Class<S>, CategoryBuilder<S>> category) {
        Validate.notNull(category, (String)Reference.categoryError(this.name, "Category can't be null for %s \"%s\""), (Object[])new Object[0]);
        this.categories.add((CategoryBuilderImpl)category.apply(this.type));
        return this;
    }

    @Override
    public CategoryBuilder<S> option(@NotNull Function<Class<S>, OptionBuilder<?, S>> option) {
        Validate.notNull(option, (String)Reference.categoryError(this.name, "Option can't be null for %s \"%s\""), (Object[])new Object[0]);
        this.options.add((OptionBuilderImpl)option.apply(this.type));
        return this;
    }

    @Override
    public CategoryBuilder<S> printFunc(@NotNull BiFunction<CommandContext<S>, class_2561, Integer> printFunc) {
        super.printFunc(printFunc);
        return this;
    }

    @Override
    public CategoryBuilder<S> saveFunc(@NotNull Runnable saveFunc) {
        super.saveFunc(saveFunc);
        return this;
    }

    @Override
    public CategoryBuilder<S> helpFunc(@NotNull Supplier<class_2561> helpFunc) {
        super.helpFunc(helpFunc);
        return this;
    }

    @Override
    @Nullable
    public LiteralArgumentBuilder<S> buildHelpFunc() {
        Validate.notNull((Object)this.printFunc, (String)Reference.categoryError(this.name, "No print function for %s \"%s\".\nAdd it using `printFunc` on current or any higher node."), (Object[])new Object[0]);
        LiteralArgumentBuilder category = LiteralArgumentBuilder.literal((String)this.name);
        this.buildHelpers(category, this.options);
        this.buildHelpers(category, this.categories);
        category.executes(context -> this.print(context, this.helpFunc != null ? (class_2561)this.helpFunc.get() : Reference.NO_HELP_SAD.get()));
        return category.getArguments().isEmpty() && this.helpFunc == null ? null : category;
    }

    @Override
    @NotNull
    public LiteralArgumentBuilder<S> build() {
        LiteralArgumentBuilder category = LiteralArgumentBuilder.literal((String)this.name);
        this.extraNodes.forEach(it -> it.accept(category));
        this.buildNodes(category, this.options);
        this.buildNodes(category, this.categories);
        return category;
    }
}

