/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.particles.chimneypush;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.railwayteam.railways.content.smokestack.particles.chimneypush.ChimneyPushParticle;
import com.railwayteam.railways.registry.CRParticleTypes;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.class_1767;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_702;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class ChimneyPushParticleData<T extends ChimneyPushParticleData<T>>
implements class_2394,
ICustomParticleDataWithSprite<T> {
    boolean leadOnly;
    float red;
    float green;
    float blue;

    protected static <T extends ChimneyPushParticleData<T>> Codec<T> makeCodec(Constructor<T> constructor) {
        return RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("leadOnly").forGetter(p -> p.leadOnly), (App)Codec.FLOAT.fieldOf("red").forGetter(p -> Float.valueOf(p.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(p -> Float.valueOf(p.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(p -> Float.valueOf(p.blue))).apply((Applicative)i, constructor::create));
    }

    protected static <T extends ChimneyPushParticleData<T>> class_2394.class_2395<T> makeDeserializer(final Constructor<T> constructor) {
        return new class_2394.class_2395<T>(){

            @NotNull
            public T fromCommand(@NotNull class_2396<T> particleTypeIn, @NotNull StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                boolean stationary = reader.readBoolean();
                reader.expect(' ');
                float red = reader.readFloat();
                reader.expect(' ');
                float green = reader.readFloat();
                reader.expect(' ');
                float blue = reader.readFloat();
                return constructor.create(stationary, red, green, blue);
            }

            @NotNull
            public T fromNetwork(@NotNull class_2396<T> particleTypeIn, @NotNull class_2540 buffer) {
                return constructor.create(buffer.readBoolean(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };
    }

    protected ChimneyPushParticleData() {
        this(false);
    }

    protected ChimneyPushParticleData(float red, float green, float blue) {
        this(false, red, green, blue);
    }

    protected ChimneyPushParticleData(boolean leadOnly) {
        this(leadOnly, -1.0f);
    }

    protected ChimneyPushParticleData(boolean leadOnly, float brightness) {
        this(leadOnly, brightness, brightness, brightness);
    }

    protected ChimneyPushParticleData(boolean leadOnly, float red, float green, float blue) {
        this.leadOnly = leadOnly;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    @NotNull
    protected abstract CRParticleTypes getParticleType();

    @NotNull
    public class_2396<?> method_10295() {
        return this.getParticleType().get();
    }

    public void method_10294(class_2540 buffer) {
        buffer.writeBoolean(this.leadOnly);
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    @NotNull
    public String method_10293() {
        return String.format(Locale.ROOT, "%s %b %f %f %f", this.getParticleType().parameter(), this.leadOnly, Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public abstract class_2394.class_2395<T> getDeserializer();

    public abstract Codec<T> getCodec(class_2396<T> var1);

    public abstract class_702.class_4091<T> getMetaFactory();

    public abstract float getQuadSize();

    public static ChimneyPushParticleData<?> create(boolean small, boolean leadOnly, @NotNull class_1767 color) {
        float idx = -(2 + color.method_7789());
        return ChimneyPushParticleData.create(small, leadOnly, idx, idx, idx);
    }

    public static ChimneyPushParticleData<?> create(boolean small, boolean leadOnly, float red, float green, float blue) {
        if (small) {
            return new Small(leadOnly, red, green, blue);
        }
        return new Medium(leadOnly, red, green, blue);
    }

    public static ChimneyPushParticleData<?> create(boolean small, boolean leadOnly) {
        if (small) {
            return new Small(leadOnly);
        }
        return new Medium(leadOnly);
    }

    @FunctionalInterface
    protected static interface Constructor<T extends ChimneyPushParticleData<T>> {
        @Contract(value="_, _, _, _ -> new")
        public T create(boolean var1, float var2, float var3, float var4);
    }

    public static class Small
    extends ChimneyPushParticleData<Small> {
        public static final Codec<Small> CODEC = Small.makeCodec(Small::new);
        public static final class_2394.class_2395<Small> DESERIALIZER = Small.makeDeserializer(Small::new);

        public Small() {
        }

        public Small(float red, float green, float blue) {
            super(red, green, blue);
        }

        public Small(boolean leadOnly) {
            super(leadOnly);
        }

        public Small(boolean leadOnly, float brightness) {
            super(leadOnly, brightness);
        }

        public Small(boolean leadOnly, float red, float green, float blue) {
            super(leadOnly, red, green, blue);
        }

        @Override
        @NotNull
        protected CRParticleTypes getParticleType() {
            return CRParticleTypes.CHIMNEYPUSH_SMALL;
        }

        @Override
        public class_2394.class_2395<Small> getDeserializer() {
            return DESERIALIZER;
        }

        @Override
        public Codec<Small> getCodec(class_2396<Small> type) {
            return CODEC;
        }

        @Override
        public class_702.class_4091<Small> getMetaFactory() {
            return ChimneyPushParticle.Factory::new;
        }

        @Override
        public float getQuadSize() {
            return 0.5f;
        }
    }

    public static class Medium
    extends ChimneyPushParticleData<Medium> {
        public static final Codec<Medium> CODEC = Medium.makeCodec(Medium::new);
        public static final class_2394.class_2395<Medium> DESERIALIZER = Medium.makeDeserializer(Medium::new);

        public Medium() {
        }

        public Medium(float red, float green, float blue) {
            super(red, green, blue);
        }

        public Medium(boolean leadOnly) {
            super(leadOnly);
        }

        public Medium(boolean leadOnly, float brightness) {
            super(leadOnly, brightness);
        }

        public Medium(boolean leadOnly, float red, float green, float blue) {
            super(leadOnly, red, green, blue);
        }

        @Override
        @NotNull
        protected CRParticleTypes getParticleType() {
            return CRParticleTypes.CHIMNEYPUSH_MEDIUM;
        }

        @Override
        public class_2394.class_2395<Medium> getDeserializer() {
            return DESERIALIZER;
        }

        @Override
        public Codec<Medium> getCodec(class_2396<Medium> type) {
            return CODEC;
        }

        @Override
        public class_702.class_4091<Medium> getMetaFactory() {
            return ChimneyPushParticle.Factory::new;
        }

        @Override
        public float getQuadSize() {
            return 1.25f;
        }
    }
}

