/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.toolbox;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.content.conductor.toolbox.fabric.MountedToolboxEquipPacketImpl;
import com.railwayteam.railways.mixin.AccessorToolboxBlockEntity;
import com.railwayteam.railways.mixin.AccessorToolboxInventory;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.content.equipment.toolbox.ToolboxHandler;
import com.simibubi.create.content.equipment.toolbox.ToolboxInventory;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class MountedToolboxEquipPacket
implements C2SPacket {
    private Integer toolboxCarrierId = null;
    private final int slot;
    private final int hotbarSlot;

    public MountedToolboxEquipPacket(ConductorEntity toolboxCarrier, int slot, int hotbarSlot) {
        this.toolboxCarrierId = toolboxCarrier.method_5628();
        this.slot = slot;
        this.hotbarSlot = hotbarSlot;
    }

    public MountedToolboxEquipPacket(class_2540 buffer) {
        if (buffer.readBoolean()) {
            this.toolboxCarrierId = buffer.readInt();
        }
        this.slot = buffer.method_10816();
        this.hotbarSlot = buffer.method_10816();
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.writeBoolean(this.toolboxCarrierId != null);
        if (this.toolboxCarrierId != null) {
            buffer.writeInt(this.toolboxCarrierId.intValue());
        }
        buffer.method_10804(this.slot);
        buffer.method_10804(this.hotbarSlot);
    }

    @Override
    public void handle(class_3222 player) {
        ToolboxInventory inv;
        AccessorToolboxInventory invAccess;
        class_1799 filterStack;
        class_1937 world = player.field_6002;
        if (this.toolboxCarrierId == null) {
            ToolboxHandler.unequip((class_1657)player, (int)this.hotbarSlot, (boolean)false);
            ToolboxHandler.syncData((class_1657)player);
            return;
        }
        class_1297 entity = world.method_8469(this.toolboxCarrierId.intValue());
        double maxRange = ToolboxHandler.getMaxRange((class_1657)player);
        if (player.method_5858(entity) > maxRange * maxRange) {
            return;
        }
        if (!(entity instanceof ConductorEntity)) {
            return;
        }
        ConductorEntity conductorEntity = (ConductorEntity)entity;
        ToolboxHandler.unequip((class_1657)player, (int)this.hotbarSlot, (boolean)false);
        if (this.slot < 0 || this.slot >= 8) {
            ToolboxHandler.syncData((class_1657)player);
            return;
        }
        MountedToolbox toolbox = conductorEntity.getToolbox();
        if (toolbox == null) {
            return;
        }
        class_1799 held = player.method_31548().method_5438(this.hotbarSlot);
        if (!held.method_7960() && !ToolboxInventory.canItemsShareCompartment((class_1799)held, (class_1799)(filterStack = (invAccess = (AccessorToolboxInventory)(inv = ((AccessorToolboxBlockEntity)((Object)toolbox)).getInventory())).getFilters().get(this.slot)))) {
            inv.inLimitedMode($ -> MountedToolboxEquipPacket.doEquip(player, this.hotbarSlot, held, inv));
        }
        class_2487 playerData = EntityUtils.getPersistentData((class_1297)player);
        class_2487 compound = playerData.method_10562("CreateToolboxData");
        String key = String.valueOf(this.hotbarSlot);
        class_2487 data = new class_2487();
        data.method_10569("Slot", this.slot);
        data.method_25927("EntityUUID", conductorEntity.method_5667());
        data.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)new class_2338(0, 1000, 0)));
        compound.method_10566(key, (class_2520)data);
        playerData.method_10566("CreateToolboxData", (class_2520)compound);
        toolbox.connectPlayer(this.slot, (class_1657)player, this.hotbarSlot);
        ToolboxHandler.syncData((class_1657)player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void doEquip(class_3222 player, int hotbarSlot, class_1799 held, ToolboxInventory inv) {
        void var3_3;
        void var2_2;
        void var1_1;
        MountedToolboxEquipPacketImpl.doEquip(player, (int)var1_1, (class_1799)var2_2, (ToolboxInventory)var3_3);
    }
}

