/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.fluid.storage;

import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.fabric.fluid.holder.FabricFluidHolder;
import earth.terrarium.botarium.fabric.fluid.storage.ExtendedFluidContainer;
import earth.terrarium.botarium.fabric.fluid.storage.SingleItemFluidSlot;
import earth.terrarium.botarium.util.Updatable;
import java.util.Iterator;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricItemFluidContainer<T extends ItemFluidContainer & Updatable<class_1799>>
extends ExtendedFluidContainer
implements Storage<FluidVariant> {
    protected final T container;
    private final ContainerItemContext ctx;

    public FabricItemFluidContainer(ContainerItemContext ctx, T container) {
        this.container = container;
        this.ctx = ctx;
    }

    public boolean supportsInsertion() {
        return this.container.allowsInsertion();
    }

    public boolean supportsExtraction() {
        return this.container.allowsExtraction();
    }

    public long simulateInsert(FluidVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        return this.container.insertFluid(FabricFluidHolder.of(resource, maxAmount), true);
    }

    public long simulateExtract(FluidVariant resource, long maxAmount, @Nullable TransactionContext transaction) {
        return this.container.extractFluid(FabricFluidHolder.of(resource, maxAmount), true).getFluidAmount();
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        long inserted = this.container.insertFluid(FabricFluidHolder.of(resource, maxAmount), false);
        this.setChanged(transaction);
        return inserted;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        long extracted = this.container.extractFluid(FabricFluidHolder.of(resource, maxAmount), false).getFluidAmount();
        this.setChanged(transaction);
        return extracted;
    }

    @NotNull
    public Iterator<StorageView<FluidVariant>> iterator() {
        return IntStream.range(0, this.container.getSize()).mapToObj(index -> new SingleItemFluidSlot(this, index)).map(holder -> holder).iterator();
    }

    public void setChanged(TransactionContext transaction) {
        class_1799 stack = this.ctx.getItemVariant().toStack();
        ((Updatable)this.container).update(stack);
        this.ctx.exchange(ItemVariant.of((class_1799)stack), this.ctx.getAmount(), transaction);
    }

    @Override
    public void onFinalCommit() {
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    @Override
    public void readSnapshot(FluidSnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }
}

