/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.command;

import com.hlysine.create_power_loader.content.AbstractChunkLoaderBlockEntity;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.ChunkLoaderMovementBehaviour;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import com.hlysine.create_power_loader.content.WeakCollection;
import com.hlysine.create_power_loader.content.trains.CarriageChunkLoader;
import com.hlysine.create_power_loader.content.trains.StationChunkLoader;
import com.hlysine.create_power_loader.content.trains.TrainChunkLoader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.simibubi.create.foundation.utility.Components;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class SummaryCommand {
    private static int white = class_124.field_1068.method_532();
    private static int gray = class_124.field_1080.method_532();
    private static int blue = 13885148;

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"summary").requires(cs -> cs.method_9259(2))).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            SummaryCommand.fillReport((class_2960)ctx.getArgument("dimension", class_2960.class), (s, f) -> source.method_9226(() -> Components.literal((String)s).method_27694(st -> st.method_36139(f.intValue())), false), c -> source.method_9226(() -> c, false));
            return 1;
        }))).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            SummaryCommand.fillReport(null, (s, f) -> source.method_9226(() -> Components.literal((String)s).method_27694(st -> st.method_36139(f.intValue())), false), c -> source.method_9226(() -> c, false));
            return 1;
        });
    }

    private static void fillReport(@Nullable class_2960 dimension, BiConsumer<String, Integer> chat, Consumer<class_2561> chatRaw) {
        LinkedList<ChunkLoader> loaders = new LinkedList<ChunkLoader>();
        for (WeakCollection<ChunkLoader> list : ChunkLoadManager.allLoaders.values()) {
            loaders.addAll(list);
        }
        if (dimension != null) {
            loaders.removeIf(loader -> !((class_2960)loader.getLocation().getFirst()).equals((Object)dimension));
        }
        chat.accept("", white);
        chat.accept("-+------<< Chunk Loader Summary >>------+-", white);
        if (dimension != null) {
            chat.accept("For " + dimension, gray);
        }
        SummaryCommand.genSummary(null, loaders, chat, chatRaw);
        chat.accept("", white);
        chat.accept("-+------------------------------------+-", white);
    }

    private static void genSummary(@Nullable LoaderMode mode, List<ChunkLoader> loaders, BiConsumer<String, Integer> chat, Consumer<class_2561> chatRaw) {
        if (mode == LoaderMode.STATIC || mode == null) {
            chat.accept("", white);
            chat.accept("Static chunk loaders", white);
            int staticLoaders = 0;
            int functional = 0;
            int brass = 0;
            int andesite = 0;
            HashSet<ChunkLoadManager.LoadedChunkPos> chunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();
            for (ChunkLoader loader2 : loaders) {
                if (!(loader2 instanceof AbstractChunkLoaderBlockEntity)) continue;
                AbstractChunkLoaderBlockEntity be = (AbstractChunkLoaderBlockEntity)loader2;
                ++staticLoaders;
                if (be.getForcedChunks().size() > 0) {
                    ++functional;
                }
                if (be.type == LoaderType.BRASS) {
                    ++brass;
                } else if (be.type == LoaderType.ANDESITE) {
                    ++andesite;
                }
                chunks.addAll(be.getForcedChunks());
            }
            chatRaw.accept((class_2561)SummaryCommand.line("Total blocks", staticLoaders));
            chatRaw.accept((class_2561)SummaryCommand.line("Functional blocks", functional));
            chatRaw.accept((class_2561)SummaryCommand.line("Brass loaders", brass));
            chatRaw.accept((class_2561)SummaryCommand.line("Andesite loaders", andesite));
            chatRaw.accept((class_2561)SummaryCommand.line("Loaded chunks", chunks.size()));
        }
        if (mode == LoaderMode.CONTRAPTION || mode == null) {
            chat.accept("", white);
            chat.accept("Contraption chunk loaders", white);
            int nonTrain = 0;
            HashSet<ChunkLoadManager.LoadedChunkPos> chunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();
            for (ChunkLoader loader3 : loaders) {
                if (!(loader3 instanceof ChunkLoaderMovementBehaviour.SavedState)) continue;
                ChunkLoaderMovementBehaviour.SavedState state = (ChunkLoaderMovementBehaviour.SavedState)loader3;
                if (!state.isTrain) {
                    ++nonTrain;
                }
                chunks.addAll(state.forcedChunks);
            }
            chatRaw.accept((class_2561)SummaryCommand.line("Non-train contraptions", nonTrain));
            chatRaw.accept((class_2561)SummaryCommand.line("Loaded chunks", chunks.size()));
        }
        if (mode == LoaderMode.TRAIN || mode == null) {
            chat.accept("", white);
            chat.accept("Train chunk loaders", white);
            int trains = 0;
            int carriages = 0;
            int functionalTrains = 0;
            int functionalCarriages = 0;
            int unknown = 0;
            int brassAndAndesite = 0;
            int brass = 0;
            int andesite = 0;
            HashSet<ChunkLoadManager.LoadedChunkPos> chunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();
            for (ChunkLoader loader4 : loaders) {
                if (!(loader4 instanceof TrainChunkLoader)) continue;
                TrainChunkLoader train = (TrainChunkLoader)loader4;
                ++trains;
                carriages += train.carriageLoaders.size();
                if (train.getForcedChunks().size() > 0) {
                    ++functionalTrains;
                }
                for (CarriageChunkLoader carriage : train.carriageLoaders) {
                    if (carriage.getForcedChunks().size() > 0) {
                        ++functionalCarriages;
                    }
                    if (!carriage.known) {
                        ++unknown;
                    } else if (carriage.brass && carriage.andesite) {
                        ++brassAndAndesite;
                    } else if (carriage.brass) {
                        ++brass;
                    } else if (carriage.andesite) {
                        ++andesite;
                    }
                    chunks.addAll(carriage.getForcedChunks());
                }
            }
            chatRaw.accept((class_2561)SummaryCommand.line("Total trains", trains));
            chatRaw.accept((class_2561)SummaryCommand.line("Total carriages", carriages));
            chatRaw.accept((class_2561)SummaryCommand.line("Functional trains", functionalTrains));
            chatRaw.accept((class_2561)SummaryCommand.line("Functional carriages", functionalCarriages));
            chatRaw.accept((class_2561)SummaryCommand.line("Unknown carriages", unknown));
            chatRaw.accept((class_2561)SummaryCommand.line("Brass+Andesite carriages", brassAndAndesite));
            chatRaw.accept((class_2561)SummaryCommand.line("Brass carriages", brass));
            chatRaw.accept((class_2561)SummaryCommand.line("Andesite carriages", andesite));
            chatRaw.accept((class_2561)SummaryCommand.line("Loaded chunks", chunks.size()));
        }
        if (mode == LoaderMode.STATION || mode == null) {
            chat.accept("", white);
            chat.accept("Station chunk loaders", white);
            int stations = 0;
            int attachments = 0;
            int activeStations = 0;
            int activeAttachments = 0;
            int brass = 0;
            int andesite = 0;
            HashSet<ChunkLoadManager.LoadedChunkPos> chunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();
            for (ChunkLoader loader5 : loaders) {
                if (!(loader5 instanceof StationChunkLoader)) continue;
                StationChunkLoader station = (StationChunkLoader)loader5;
                ++stations;
                attachments += station.attachments.size();
                if (station.getForcedChunks().size() > 0) {
                    ++activeStations;
                    activeAttachments += station.attachments.size();
                }
                for (StationChunkLoader.AttachedLoader attachment : station.attachments) {
                    if (attachment.type() == LoaderType.ANDESITE) {
                        ++andesite;
                        continue;
                    }
                    if (attachment.type() != LoaderType.BRASS) continue;
                    ++brass;
                }
                chunks.addAll(station.getForcedChunks());
            }
            chatRaw.accept((class_2561)SummaryCommand.line("Total stations", stations));
            chatRaw.accept((class_2561)SummaryCommand.line("Total attachments", attachments));
            chatRaw.accept((class_2561)SummaryCommand.line("Active stations", activeStations));
            chatRaw.accept((class_2561)SummaryCommand.line("Active attachments", activeAttachments));
            chatRaw.accept((class_2561)SummaryCommand.line("Brass attachments", brass));
            chatRaw.accept((class_2561)SummaryCommand.line("Andesite attachments", andesite));
            chatRaw.accept((class_2561)SummaryCommand.line("Loaded chunks", chunks.size()));
        }
        if (mode == null) {
            chat.accept("", white);
            chat.accept("All chunk loaders", white);
            chatRaw.accept((class_2561)SummaryCommand.line("Total units", loaders.size()));
            HashSet allChunks = new HashSet();
            loaders.forEach(loader -> allChunks.addAll(loader.getForcedChunks()));
            chatRaw.accept((class_2561)SummaryCommand.line("Total chunks", allChunks.size()));
        }
    }

    private static class_5250 text(String text, int color) {
        return Components.literal((String)text).method_27694(style -> style.method_36139(color));
    }

    private static class_5250 line(String label, Object value) {
        return SummaryCommand.text("    ", gray).method_10852((class_2561)SummaryCommand.text(label + ": ", gray)).method_10852((class_2561)SummaryCommand.text(String.valueOf(value), blue));
    }
}

