/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1477;
import net.minecraft.class_1510;
import net.minecraft.class_1577;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5605;
import net.minecraft.class_562;
import net.minecraft.class_630;
import net.minecraft.class_8153;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.ETFConfigWarning;
import traben.entity_texture_features.config.ETFConfigWarnings;
import traben.entity_texture_features.config.screens.ETFConfigScreenWarnings;
import traben.tconfig.gui.TConfigScreenMain;
import traben.tconfig.gui.entries.TConfigEntryCategory;

public class ETFConfigScreenMain
extends TConfigScreenMain {
    final ObjectOpenHashSet<ETFConfigWarning> warningsFound = new ObjectOpenHashSet();
    private final Random rand = new Random();
    private final LogoCreeperRenderer LOGO_CREEPER = new LogoCreeperRenderer();
    private final class_2960 BLUE = new class_2960("entity_features", "textures/gui/entity/e.png");
    private final class_2960 RED = new class_2960("entity_features", "textures/gui/entity/t.png");
    private final class_2960 YELLOW = new class_2960("entity_features", "textures/gui/entity/f.png");
    boolean shownWarning = false;
    int warningCount = 0;
    private long timer = 0L;
    private class_1309 livingEntity = null;

    public ETFConfigScreenMain(class_437 parent) {
        super("config.entity_features", parent, ETF.configHandlers, List.of(new TConfigEntryCategory("config.entity_features.textures_main"), new TConfigEntryCategory("config.entity_features.models_main").setEmptyTooltip("config.entity_features.empty_emf"), new TConfigEntryCategory("config.entity_features.sounds_main").setEmptyTooltip("config.entity_features.empty_esf"), new TConfigEntryCategory("config.entity_features.general_settings.title"), new TConfigEntryCategory("config.entity_features.per_entity_settings")));
        for (ETFConfigWarning warning : ETFConfigWarnings.getRegisteredWarnings()) {
            if (!warning.isConditionMet()) continue;
            this.shownWarning = true;
            ++this.warningCount;
            this.warningsFound.add((Object)warning);
        }
    }

    public static void drawEntity(class_332 context, float x, float y, int size, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, class_1309 entity) {
        context.method_51448().method_22903();
        context.method_51448().method_22904((double)x, (double)y, 150.0);
        context.method_51448().method_34425(new Matrix4f().scaling((float)size, (float)size, (float)(-size)));
        context.method_51448().method_22907(quaternionf);
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        if (quaternionf2 != null) {
            quaternionf2.conjugate();
            entityRenderDispatcher.method_24196(quaternionf2);
        }
        entityRenderDispatcher.method_3948(false);
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, context.method_51448(), (class_4597)context.method_51450(), 0xF000F0));
        context.method_51452();
        entityRenderDispatcher.method_3948(true);
        context.method_51448().method_22909();
        class_308.method_24211();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.shownWarning) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"config.entity_features.warnings_main"), button -> Objects.requireNonNull(this.field_22787).method_1507((class_437)new ETFConfigScreenWarnings(this, this.warningsFound))).method_46434((int)((double)this.field_22789 * 0.1), (int)((double)this.field_22790 * 0.1) - 15, (int)((double)this.field_22789 * 0.2), 20).method_46431());
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.timer + 5000L < System.currentTimeMillis() && class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_37908() != null) {
            List entityList = class_310.method_1551().field_1724.method_37908().method_8335(null, class_310.method_1551().field_1724.method_5829().method_1014(128.0));
            class_1297 entity = null;
            for (int i = 0; i < Math.min(entityList.size(), 24) && !((entity = (class_1297)entityList.get(this.rand.nextInt(entityList.size()))) instanceof class_1309); ++i) {
            }
            if (entity instanceof class_1309) {
                this.livingEntity = (class_1309)entity;
                this.timer = System.currentTimeMillis();
            }
        }
        if (this.livingEntity != null && !this.livingEntity.method_31481()) {
            this.renderEntitySample(context, mouseY);
        } else {
            this.renderETFLogoCreepers(context, mouseX, mouseY);
        }
        context.method_51448().method_22909();
    }

    private void renderETFLogoCreepers(class_332 context, int mouseX, int mouseY) {
        int y = (int)((double)this.field_22790 * 0.75);
        int x = (int)((double)this.field_22789 * 0.33);
        float g = (float)(-Math.atan(((float)(-mouseY) + (float)this.field_22790 / 2.0f) / 40.0f));
        float g2 = (float)(-Math.atan(((float)(-mouseX) + (float)this.field_22789 / 3.0f) / 400.0f));
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY(g2);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(-(g * 20.0f * ((float)Math.PI / 180)));
        quaternionf.mul((Quaternionfc)quaternionf2);
        context.method_51448().method_22903();
        context.method_51448().method_22904((double)x, (double)y, 150.0);
        float scaling = (float)((double)this.field_22790 * 0.3);
        context.method_51448().method_34425(new Matrix4f().scaling(scaling, scaling, -scaling));
        context.method_51448().method_22907(quaternionf);
        class_308.method_34742();
        float sin1 = (float)(Math.sin((double)System.currentTimeMillis() / 500.0) / 32.0);
        float sin2 = (float)(Math.sin((double)System.currentTimeMillis() / 500.0 + 1.0) / 32.0);
        float sin3 = (float)(Math.sin((double)System.currentTimeMillis() / 500.0 + 2.0) / 32.0);
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        matrixStack.method_22904(-0.6, (double)(-sin1), 0.0);
        matrixStack.method_22905(1.0f + sin1, 1.0f + sin1, 1.0f + sin1);
        this.LOGO_CREEPER.renderSimple(matrixStack, (class_4597)context.method_51450(), this.YELLOW);
        matrixStack.method_22909();
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, -sin2, 0.0f);
        matrixStack.method_22905(1.0f + sin2, 1.0f + sin2, 1.0f + sin2);
        this.LOGO_CREEPER.renderSimple(matrixStack, (class_4597)context.method_51450(), this.RED);
        matrixStack.method_22909();
        matrixStack.method_22903();
        matrixStack.method_22904(0.6, (double)(-sin3), 0.0);
        matrixStack.method_22905(1.0f + sin3, 1.0f + sin3, 1.0f + sin3);
        this.LOGO_CREEPER.renderSimple(matrixStack, (class_4597)context.method_51450(), this.BLUE);
        matrixStack.method_22909();
        class_308.method_24211();
    }

    private void renderEntitySample(class_332 context, int mouseY) {
        double scale;
        int y = (int)((double)this.field_22790 * 0.75);
        if ((double)this.livingEntity.method_17682() < 0.7) {
            y -= (int)((double)this.field_22790 * 0.15);
        }
        int x = (int)((double)this.field_22789 * 0.33);
        float g = (float)Math.atan(((float)(-mouseY) + (float)this.field_22790 / 2.0f) / 40.0f);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)((double)System.currentTimeMillis() / 1000.0 % (Math.PI * 2)));
        Quaternionf quaternionf2 = new Quaternionf().rotateX(-(g * 20.0f * ((float)Math.PI / 180)));
        quaternionf.mul((Quaternionfc)quaternionf2);
        double autoScale = (double)this.field_22790 * 0.4 / (double)Math.max(1.0f, Math.max(this.livingEntity.method_17682(), this.livingEntity.method_17681()));
        if (this.livingEntity instanceof class_1477) {
            y -= (int)((double)this.field_22790 * 0.15);
            scale = autoScale * 0.5;
        } else if (this.livingEntity instanceof class_1577 || this.livingEntity instanceof class_8153) {
            y -= (int)((double)this.field_22790 * 0.1);
            scale = autoScale * 0.7;
        } else if (this.livingEntity instanceof class_1510) {
            y -= (int)((double)this.field_22790 * 0.15);
            scale = autoScale * 1.5;
        } else {
            scale = autoScale;
        }
        double scaleModify = Math.sin((double)(System.currentTimeMillis() - this.timer) / 5000.0 * Math.PI) * 6.0;
        double scaleModify2 = Math.max(Math.min(Math.abs(scaleModify), 1.0), 0.0);
        int modelHeight = (int)Math.min(scale * scaleModify2, (double)this.field_22790 * 0.4);
        context.method_51448().method_22903();
        ETFConfigScreenMain.drawEntity(context, x, y, modelHeight, quaternionf, quaternionf2, this.livingEntity);
    }

    public static class LogoCreeperRenderer {
        private final class_630 root = class_562.method_31991((class_5605)class_5605.field_27715).method_32109();

        public LogoCreeperRenderer() {
            this.root.method_32086((String)"right_hind_leg").field_3654 = (float)(-Math.toRadians(25.0));
            this.root.method_32086((String)"left_hind_leg").field_3654 = (float)Math.toRadians(25.0);
            this.root.method_32086((String)"left_hind_leg").field_3655 -= 2.0f;
            this.root.method_32086((String)"right_front_leg").field_3654 = (float)Math.toRadians(25.0);
            this.root.method_32086((String)"left_front_leg").field_3654 = (float)(-Math.toRadians(25.0));
            this.root.method_32086((String)"left_front_leg").field_3655 += 2.0f;
        }

        public void renderSimple(class_4587 matrix, class_4597 vcp, class_2960 texture) {
            matrix.method_22903();
            matrix.method_22905(-1.0f, -1.0f, 1.0f);
            matrix.method_46416(0.0f, -1.501f, 0.0f);
            class_1921 rendertype = class_1921.method_23572((class_2960)texture);
            if (rendertype != null) {
                class_4588 vertexconsumer = vcp.getBuffer(rendertype);
                this.root.method_22699(matrix, vertexconsumer, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            matrix.method_22909();
        }
    }
}

