/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonlib.mixin.AdvancementBehaviourAccessor;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.PrintEntry;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.PrinterTargetItemHandler;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.Printing;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.FilteringFluidTankBehaviour;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.ExperienceFluid;
import plus.dragons.createenchantmentindustry.entry.CeiTags;
import plus.dragons.createenchantmentindustry.foundation.advancement.CeiAdvancements;
import plus.dragons.createenchantmentindustry.foundation.advancement.CeiTriggers;
import plus.dragons.createenchantmentindustry.foundation.config.CeiConfigs;

public class PrinterBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
SidedStorageBlockEntity {
    public static final int COPYING_TIME = 100;
    protected BeltProcessingBehaviour beltProcessing;
    public int processingTicks = -1;
    SmartFluidTankBehaviour tank;
    private class_1799 copyTarget = null;
    public boolean tooExpensive = false;
    public PrintEntry printEntry;
    boolean sendParticles;
    LazyOptional<PrinterTargetItemHandler> itemHandler = LazyOptional.of(() -> new PrinterTargetItemHandler(this));
    SnapshotParticipant<class_1799> snapshotParticipant = new SnapshotParticipant<class_1799>(){

        protected class_1799 createSnapshot() {
            return PrinterBlockEntity.this.getCopyTarget();
        }

        protected void readSnapshot(class_1799 snapshot) {
            PrinterBlockEntity.this.setCopyTarget(snapshot == class_1799.field_8037 ? null : snapshot);
        }

        protected void onFinalCommit() {
            PrinterBlockEntity.this.notifyUpdate();
        }
    };
    protected static int ENCHANT_PARTICLE_COUNT = 20;

    public PrinterBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = FilteringFluidTankBehaviour.single(fluidStack -> fluidStack.getFluid().method_15791(CeiTags.FluidTag.PRINTER_INPUT.tag), this, (Integer)CeiConfigs.SERVER.copierTankCapacity.get() * 81);
        behaviours.add((BlockEntityBehaviour)this.tank);
        this.beltProcessing = new BeltProcessingBehaviour((SmartBlockEntity)this).whenItemEnters(this::onItemReceived).whileItemHeld(this::whenItemHeld);
        behaviours.add((BlockEntityBehaviour)this.beltProcessing);
        this.registerAwardables(behaviours, new CreateAdvancement[]{CeiAdvancements.COPIABLE_MASTERPIECE.asCreateAdvancement(), CeiAdvancements.COPIABLE_MYSTERY.asCreateAdvancement(), CeiAdvancements.RELIC_RESTORATION.asCreateAdvancement(), CeiAdvancements.EMERGING_BRAND.asCreateAdvancement()});
    }

    public void tick() {
        super.tick();
        if (this.processingTicks >= 0) {
            --this.processingTicks;
        }
    }

    public class_1799 getCopyTarget() {
        if (this.copyTarget == null) {
            return class_1799.field_8037;
        }
        return this.copyTarget;
    }

    public void setCopyTarget(@NotNull class_1799 copyTarget) {
        if (copyTarget.method_7960()) {
            this.copyTarget = null;
            this.tooExpensive = false;
            this.printEntry = null;
        } else {
            this.copyTarget = copyTarget;
            this.matchPrintEntry(copyTarget);
            this.tooExpensive = Printing.isTooExpensive(this.printEntry, copyTarget, (Integer)CeiConfigs.SERVER.copierTankCapacity.get() * 81);
        }
        this.processingTicks = -1;
        this.notifyUpdate();
    }

    private void matchPrintEntry(class_1799 copyTarget) {
        PrintEntry entry = Printing.match(copyTarget);
        if (entry == null) {
            this.copyTarget = null;
            this.tooExpensive = false;
        }
        this.printEntry = entry;
    }

    protected void spawnParticles() {
        if (this.isVirtual()) {
            return;
        }
        class_243 vec = VecHelper.getCenterOf((class_2382)this.field_11867);
        vec = vec.method_1023(0.0, 0.6875, 0.0);
        class_2400 particle = class_2398.field_11215;
        for (int i = 0; i < ENCHANT_PARTICLE_COUNT; ++i) {
            class_243 m = VecHelper.offsetRandomly((class_243)class_243.field_1353, (class_5819)this.field_11863.field_9229, (float)1.0f);
            m = new class_243(m.field_1352, Math.abs(m.field_1351), m.field_1350);
            this.field_11863.method_8494((class_2394)particle, vec.field_1352, vec.field_1351, vec.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
        this.field_11863.method_8486(vec.field_1352, vec.field_1351, vec.field_1350, class_3417.field_15119, class_3419.field_15245, 1.0f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f, true);
    }

    protected BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (handler.blockEntity.isVirtual()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tooExpensive || this.copyTarget == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!Printing.valid(this.printEntry, this.copyTarget, transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tank.isEmpty() || Printing.isCorrectInk(this.printEntry, this.getCurrentFluidInTank(), this.copyTarget)) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (Printing.getRequiredAmountForItem(this.printEntry, this.copyTarget) == -1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    protected BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (this.processingTicks != -1 && this.processingTicks != 10) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.tooExpensive || this.copyTarget == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!Printing.valid(this.printEntry, this.copyTarget, transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tank.isEmpty() || !Printing.isCorrectInk(this.printEntry, this.getCurrentFluidInTank(), this.copyTarget)) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        FluidStack fluid = this.getCurrentFluidInTank();
        int requiredAmountForItem = Printing.getRequiredAmountForItem(this.printEntry, this.copyTarget);
        if (requiredAmountForItem == -1) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if ((long)requiredAmountForItem > fluid.getAmount()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.processingTicks == -1) {
            this.processingTicks = 100;
            this.notifyUpdate();
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        class_1799 item = this.copyTarget.method_7972();
        if (!this.field_11863.method_8608()) {
            class_1657 player;
            AdvancementBehaviour advancementBehaviour;
            UUID playerId;
            if (item.method_31574(class_1802.field_8360)) {
                this.award(CeiAdvancements.COPIABLE_MASTERPIECE.asCreateAdvancement());
                if (item.method_7948().method_10550("generation") == 3) {
                    this.award(CeiAdvancements.RELIC_RESTORATION.asCreateAdvancement());
                }
            } else if (item.method_31574(class_1802.field_8598)) {
                this.award(CeiAdvancements.COPIABLE_MYSTERY.asCreateAdvancement());
            } else if (item.method_31574(class_1802.field_8448) && !transported.stack.method_31574(class_1802.field_8448)) {
                this.award(CeiAdvancements.EMERGING_BRAND.asCreateAdvancement());
            }
            if ((playerId = ((AdvancementBehaviourAccessor)(advancementBehaviour = (AdvancementBehaviour)this.getBehaviour(AdvancementBehaviour.TYPE))).getPlayerId()) != null && (player = this.field_11863.method_18470(playerId)) != null) {
                CeiTriggers.BOOK_PRINTED.trigger(player, 1);
            }
        }
        class_1799 copy = Printing.print(this.printEntry, this.copyTarget, requiredAmountForItem, transported.stack, fluid);
        ArrayList<TransportedItemStack> outList = new ArrayList<TransportedItemStack>();
        TransportedItemStack held = null;
        TransportedItemStack result = transported.copy();
        result.stack = copy;
        if (!transported.stack.method_7960()) {
            held = transported.copy();
        }
        outList.add(result);
        handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, (TransportedItemStack)held));
        this.tank.getPrimaryHandler().setFluid(fluid);
        this.sendParticles = true;
        this.notifyUpdate();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    private FluidStack getCurrentFluidInTank() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    public void destroy() {
        super.destroy();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            FluidStack fluidStack;
            class_3611 class_36112;
            class_3218 serverLevel = (class_3218)class_19372;
            class_1799 heldItemStack = this.copyTarget;
            class_2338 pos = this.method_11016();
            if (heldItemStack != null) {
                class_1264.method_5449((class_1937)this.field_11863, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)heldItemStack);
            }
            if ((class_36112 = (fluidStack = this.tank.getPrimaryHandler().getFluid()).getFluid()) instanceof ExperienceFluid) {
                ExperienceFluid expFluid = (ExperienceFluid)class_36112;
                expFluid.drop(serverLevel, VecHelper.getCenterOf((class_2382)pos), (int)fluidStack.getAmount());
            }
        }
    }

    protected void write(class_2487 compoundTag, boolean clientPacket) {
        super.write(compoundTag, clientPacket);
        compoundTag.method_10569("ProcessingTicks", this.processingTicks);
        compoundTag.method_10556("tooExpensive", this.tooExpensive);
        if (this.copyTarget != null) {
            compoundTag.method_10566("copyTarget", NBTSerializer.serializeNBT((Object)this.copyTarget));
        }
        if (this.sendParticles && clientPacket) {
            compoundTag.method_10556("SpawnParticles", true);
            this.sendParticles = false;
        }
    }

    public void writeSafe(class_2487 tag) {
        super.writeSafe(tag);
        tag.method_10556("tooExpensive", this.tooExpensive);
    }

    protected void read(class_2487 compoundTag, boolean clientPacket) {
        super.read(compoundTag, clientPacket);
        this.copyTarget = null;
        this.processingTicks = compoundTag.method_10550("ProcessingTicks");
        this.tooExpensive = compoundTag.method_10577("tooExpensive");
        if (compoundTag.method_10545("copyTarget")) {
            this.copyTarget = class_1799.method_7915((class_2487)compoundTag.method_10562("copyTarget"));
            this.matchPrintEntry(this.copyTarget);
        }
        if (!clientPacket) {
            return;
        }
        if (compoundTag.method_10545("SpawnParticles")) {
            this.spawnParticles();
        }
    }

    public void invalidate() {
        super.invalidate();
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(class_2350 side) {
        if (side != class_2350.field_11033) {
            return this.tank.getCapability();
        }
        return null;
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(class_2350 side) {
        return (Storage)this.itemHandler.getValueUnsafer();
    }

    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1012(0.0, -2.0, 0.0);
    }

    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        EnchantmentIndustry.LANG.translate("gui.goggles.printer", new Object[0]).forGoggles(tooltip);
        if (this.copyTarget == null) {
            EnchantmentIndustry.LANG.translate("gui.goggles.printer.no_target", new Object[0]).style(class_124.field_1080).forGoggles(tooltip, 1);
        } else {
            this.printEntry.addToGoggleTooltip(tooltip, isPlayerSneaking, this.copyTarget);
        }
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getFluidStorage(null));
        return true;
    }
}

