/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.elytratrims.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.kikugie.elytratrims.common.ETReference;
import dev.kikugie.elytratrims.common.util.UtilKt;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u000b\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\u000b\u0010\fJ1\u0010\u000f\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ldev/kikugie/elytratrims/common/config/ConfigLoader;", "", "<init>", "()V", "T", "Ljava/nio/file/Path;", "file", "Lcom/mojang/serialization/Codec;", "codec", "Ljava/util/function/Supplier;", "provider", "load", "(Ljava/nio/file/Path;Lcom/mojang/serialization/Codec;Ljava/util/function/Supplier;)Ljava/lang/Object;", "instance", "", "save", "(Ljava/nio/file/Path;Lcom/mojang/serialization/Codec;Ljava/lang/Object;)V", "elytratrims-fabric"})
public final class ConfigLoader {
    @NotNull
    public static final ConfigLoader INSTANCE = new ConfigLoader();

    private ConfigLoader() {
    }

    public final <T> T load(@NotNull Path file, @NotNull Codec<T> codec, @NotNull Supplier<T> provider) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            T newConfig = provider.get();
            this.save(file, codec, newConfig);
            return newConfig;
        }
        try {
            JsonElement json = JsonParser.parseReader((Reader)Files.newBufferedReader(file));
            DataResult dataResult = codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"decode(...)");
            return (T)((Pair)UtilKt.getAnyway(dataResult)).getFirst();
        }
        catch (Exception e) {
            ETReference.LOGGER.warn("Failed to read config: " + e);
            T newConfig = provider.get();
            this.save(file, codec, newConfig);
            return newConfig;
        }
    }

    public final <T> void save(@NotNull Path file, @NotNull Codec<T> codec, T instance) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        try {
            DataResult dataResult = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, instance);
            Intrinsics.checkNotNullExpressionValue((Object)dataResult, (String)"encodeStart(...)");
            JsonElement result = (JsonElement)UtilKt.getAnyway(dataResult);
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            Files.writeString(file, (CharSequence)result.toString(), openOptionArray);
        }
        catch (Exception e) {
            ETReference.LOGGER.warn("Failed to save config to " + file + ":\n" + e);
        }
    }
}

