/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emiffect.util.stack;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4074;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class StatusEffectEmiStack
extends EmiStack {
    @Nullable
    private final class_1291 effect;

    protected StatusEffectEmiStack(@Nullable class_1291 effect) {
        this.effect = effect;
    }

    public static StatusEffectEmiStack of(@Nullable class_1291 effect) {
        return new StatusEffectEmiStack(effect);
    }

    public EmiStack copy() {
        return StatusEffectEmiStack.of(this.effect);
    }

    public boolean isEmpty() {
        return this.effect == null;
    }

    @Nullable
    public class_1291 getEffect() {
        return this.effect;
    }

    public void render(class_332 draw, int x, int y, float delta, int flags) {
        class_4074 sprites = class_310.method_1551().method_18505();
        if (this.effect != null) {
            class_1058 sprite = sprites.method_18663(this.effect);
            RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)sprite.method_45852());
            draw.method_25298(x, y, 0, 18, 18, sprite);
            RenderSystem.applyModelViewMatrix();
        }
    }

    public class_2487 getNbt() {
        return null;
    }

    public Object getKey() {
        return this.effect;
    }

    public class_2960 getId() {
        return class_7923.field_41174.method_10221((Object)this.effect);
    }

    public List<class_2561> getTooltipText() {
        return List.of(this.getName());
    }

    public List<class_5684> getTooltip() {
        if (this.effect == null) {
            return List.of();
        }
        ArrayList<class_5684> tooltips = new ArrayList<class_5684>(this.getTooltipText().stream().map(EmiPort::ordered).map(class_5684::method_32662).toList());
        switch (this.effect.method_18792()) {
            case field_18271: {
                tooltips.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable((String)"tooltip.emiffect.beneficial").method_27692(class_124.field_1060))));
                break;
            }
            case field_18273: {
                tooltips.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable((String)"tooltip.emiffect.neutral").method_27692(class_124.field_1065))));
                break;
            }
            case field_18272: {
                tooltips.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable((String)"tooltip.emiffect.harmful").method_27692(class_124.field_1061))));
            }
        }
        tooltips.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable((String)"tooltip.emiffect.color", (Object[])new Object[]{"#" + String.format("%02x", this.effect.method_5556())}).method_27692(class_124.field_1080))));
        class_2960 id = class_7923.field_41174.method_10221((Object)this.effect);
        if (id != null) {
            tooltips.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.literal((String)EmiUtil.getModName((String)id.method_12836()), (class_124[])new class_124[]{class_124.field_1078, class_124.field_1056}))));
        }
        return tooltips;
    }

    public class_2561 getName() {
        return this.effect != null ? this.effect.method_5560() : EmiPort.literal((String)"missingno");
    }

    public class_1799 getItemStack() {
        class_1799 stack = super.getItemStack();
        if (this.effect != null) {
            stack = class_1844.method_8056((class_1799)class_1802.field_8574.method_7854(), Collections.singletonList(new class_1293(this.effect, 600)));
        }
        return stack;
    }
}

