/*
 * Decompiled with CFR 0.152.
 */
package com.chefmoon.ubesdelight.recipe;

import com.chefmoon.ubesdelight.recipe.ingredient.ChanceResult;
import com.chefmoon.ubesdelight.registry.RecipeTypesRegistry;
import com.chefmoon.ubesdelight.util.RecipeMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5819;

public class BakingMatRecipe
implements class_1860<class_1263> {
    private final class_2960 id;
    private final String group;
    private final class_2371<class_1856> ingredientList;
    private final class_2371<class_1856> processStages;
    private final class_1856 tool;
    private final class_2371<ChanceResult> resultList;
    private final String soundEvent;

    public BakingMatRecipe(class_2960 id, String group, class_2371<class_1856> ingredientList, class_2371<class_1856> processStages, class_1856 tool, class_2371<ChanceResult> resultList, String soundEvent) {
        this.id = id;
        this.group = group;
        this.ingredientList = ingredientList;
        this.processStages = processStages;
        this.tool = tool;
        this.resultList = resultList;
        this.soundEvent = soundEvent;
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        Boolean processMatch = false;
        ArrayList<class_1799> inputList = new ArrayList<class_1799>();
        int inputSlotCount = 0;
        for (int slotOffset = 0; slotOffset < 9; ++slotOffset) {
            class_1799 itemStack = inventory.method_5438(slotOffset);
            if (itemStack.method_7960()) continue;
            ++inputSlotCount;
            inputList.add(itemStack);
        }
        Boolean inputMatch = inputSlotCount == this.ingredientList.size() && RecipeMatcher.findMatches(inputList, this.ingredientList) != null;
        for (class_1856 ingredient : this.processStages) {
            if (!Arrays.stream(ingredient.method_8105()).findFirst().get().method_31574(((class_1799)inputList.get(0)).method_7909())) continue;
            processMatch = true;
        }
        return inputMatch != false || processMatch != false;
    }

    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        return ((ChanceResult)this.resultList.get(0)).stack().method_7972();
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.ingredientList.size();
    }

    public class_1799 method_8110(class_5455 registryManager) {
        return ((ChanceResult)this.resultList.get(0)).stack();
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return RecipeTypesRegistry.BAKING_MAT_RECIPE_SERIALIZER.serializer();
    }

    public class_3956<?> method_17716() {
        return RecipeTypesRegistry.BAKING_MAT_RECIPE_SERIALIZER.type();
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredientList;
    }

    public class_2371<class_1856> getProcessStages() {
        return this.processStages;
    }

    public class_2371<class_1856> getIngredientsAndTool() {
        class_2371 ingredientTool = class_2371.method_10211();
        for (class_1856 ingredient : this.ingredientList) {
            ingredientTool.add((Object)ingredient);
        }
        ingredientTool.add((Object)this.tool);
        return ingredientTool;
    }

    public List<class_1799> getResultList() {
        return this.getRollableResults().stream().map(ChanceResult::stack).collect(Collectors.toList());
    }

    public List<class_1799> getMandatoryResult() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() == 1.0f).map(ChanceResult::stack).toList();
    }

    public List<ChanceResult> getVariableResult() {
        return this.getRollableResults().stream().filter(chanceResult -> chanceResult.chance() != 1.0f).toList();
    }

    public class_2371<ChanceResult> getRollableResults() {
        return this.resultList;
    }

    public List<class_1799> getRolledResults(class_5819 rand, int fortuneLevel) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        this.getRollableResults().forEach(chanceResult -> {
            class_1799 stack = chanceResult.rollOutput(rand, fortuneLevel);
            if (!stack.method_7960()) {
                results.add(stack);
            }
        });
        return results;
    }

    public String method_8112() {
        return this.group;
    }

    public boolean method_8118() {
        return true;
    }

    public class_1856 getTool() {
        return this.tool;
    }

    public String getSoundEvent() {
        return this.soundEvent;
    }
}

