/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.mixin;

import com.affehund.voidtotem.core.ILivingEntityMixin;
import com.affehund.voidtotem.core.ModUtils;
import com.affehund.voidtotem.mixin.ServerGamePacketListenerImplAccessor;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2874;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class LivingEntityMixin
implements ILivingEntityMixin {
    private boolean isFallDamageImmune;
    private long lastSaveBlockPos;
    private class_2874 lastSaveBlockDim;

    @Inject(method={"checkTotemDeathProtection(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkTotemDeathProtection(class_1282 source, CallbackInfoReturnable<Boolean> cir) {
        class_1309 livingEntity = (class_1309)this;
        if (ModUtils.canProtectFromVoid(livingEntity, source)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void causeFallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        class_1309 livingEntity = (class_1309)this;
        if (((ILivingEntityMixin)livingEntity).isFallDamageImmune()) {
            if (livingEntity instanceof class_3222) {
                class_3222 player = (class_3222)livingEntity;
                ((ServerGamePacketListenerImplAccessor)player.field_13987).setAboveGroundTickCount(0);
            }
            ((ILivingEntityMixin)livingEntity).setFallDamageImmune(false);
            cir.cancel();
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        class_1309 livingEntity = (class_1309)this;
        ModUtils.setLastSaveBlockPos(livingEntity);
        ModUtils.resetFallDamageImmunity(livingEntity);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbt(@NotNull class_2487 tag, CallbackInfo ci) {
        this.isFallDamageImmune = tag.method_10577("Void TotemIsFallDamageImmune");
        this.lastSaveBlockPos = tag.method_10537("Void TotemLastSaveBlockPos");
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbt(@NotNull class_2487 tag, CallbackInfo ci) {
        tag.method_10556("Void TotemIsFallDamageImmune", this.isFallDamageImmune);
        tag.method_10544("Void TotemLastSaveBlockPos", this.lastSaveBlockPos);
    }

    @Override
    public boolean isFallDamageImmune() {
        return this.isFallDamageImmune;
    }

    @Override
    public void setFallDamageImmune(boolean isImmune) {
        this.isFallDamageImmune = isImmune;
    }

    @Override
    public long getLastSaveBlockPosAsLong() {
        return this.lastSaveBlockPos;
    }

    @Override
    public void setLastSaveBlockPosAsLong(long pos) {
        this.lastSaveBlockPos = pos;
    }

    @Override
    public class_2874 getLastSaveBlockDim() {
        return this.lastSaveBlockDim;
    }

    @Override
    public void setLastSaveBlockDim(class_2874 dimensionType) {
        this.lastSaveBlockDim = dimensionType;
    }
}

