/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1743;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2478;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_7713;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodType
extends BlockType {
    public static final Codec<WoodType> CODEC = class_2960.field_25139.flatXmap(r -> {
        WoodType w = WoodTypeRegistry.getValue(r);
        if (w == null) {
            return DataResult.error(() -> "No such wood type: " + r);
        }
        return DataResult.success((Object)w);
    }, t -> DataResult.success((Object)t.id));
    public final class_2248 planks;
    public final class_2248 log;
    private final Supplier<class_4719> vanillaType = Suppliers.memoize(this::detectVanillaWood);

    @Nullable
    private class_4719 detectVanillaWood() {
        Object object = this.getChild("hanging_sign");
        if (object instanceof class_7713) {
            class_7713 c = (class_7713)object;
            return c.method_24025();
        }
        object = this.getChild("sign");
        if (object instanceof class_2478) {
            class_2478 f = (class_2478)object;
            return f.method_24025();
        }
        String i = this.id.method_12836().equals("minecraft") ? this.id.method_12832() : this.id.toString();
        Stream values = class_4719.method_24026();
        Optional<class_4719> o = values.filter(v -> v.comp_1299().equals(i)).findAny();
        return o.orElse(null);
    }

    public WoodType(class_2960 id, class_2248 baseBlock, class_2248 logBlock) {
        super(id);
        this.planks = baseBlock;
        this.log = logBlock;
    }

    @Nullable
    protected class_2248 findStrippedLog(String ... possibleNames) {
        for (String v : possibleNames) {
            class_2248 stripped;
            class_2248 b = this.getBlockOfThis(v);
            if (v == null || (stripped = (class_2248)class_1743.field_7898.get(b)) == null || stripped == b) continue;
            return stripped;
        }
        return this.findLogRelatedBlock("stripped", possibleNames);
    }

    @Nullable
    protected class_2248 findLogRelatedBlock(String prefix, String ... possibleNames) {
        for (String n : possibleNames) {
            class_2248 b = this.findWithPrefix(prefix, n);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Nullable
    protected class_2248 findWithPrefix(String prefix, String postfix) {
        Optional o;
        Object prefix_ = prefix.isEmpty() ? "" : prefix + "_";
        class_2960 id = this.getId();
        String logN = Utils.getID(this.log).method_12832();
        String path = id.method_12832();
        String namespace = id.method_12836();
        if ((this.id.method_12836().equals("tfc") || this.id.method_12836().equals("afc")) && (o = class_7923.field_41175.method_17966(new class_2960(namespace, "wood/" + (String)prefix_ + postfix + "/" + path))).isPresent()) {
            return (class_2248)o.get();
        }
        HashSet targets = new HashSet();
        Collections.addAll(targets, new class_2960(namespace, path + "_" + (String)prefix_ + postfix), new class_2960(namespace, (String)prefix_ + path + "_" + postfix), new class_2960(namespace, logN + "_" + (String)prefix_ + postfix), new class_2960(namespace, (String)prefix_ + logN + "_" + postfix));
        class_2248 found = null;
        for (class_2960 r : targets) {
            if (!class_7923.field_41175.method_10250(r)) continue;
            found = (class_2248)class_7923.field_41175.method_10223(r);
            break;
        }
        return found;
    }

    @Override
    public class_1935 mainChild() {
        return this.planks;
    }

    @Nullable
    public class_4719 toVanilla() {
        return this.vanillaType.get();
    }

    @NotNull
    public class_4719 toVanillaOrOak() {
        class_4719 v = this.toVanilla();
        if (v != null) {
            return v;
        }
        return class_4719.field_21676;
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.planks.method_9564().method_50011();
    }

    public class_3620 getColor() {
        return this.planks.method_26403();
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("planks", this.planks);
        this.addChild("log", this.log);
        this.addChild("leaves", this.findRelatedEntry("leaves", class_7923.field_41175));
        this.addChild("wood", this.findLogRelatedBlock("", "wood", "hyphae"));
        this.addChild("stripped_log", this.findStrippedLog("log", "stem", "stalk"));
        this.addChild("stripped_wood", this.findStrippedLog("wood", "hyphae"));
        this.addChild("slab", this.findRelatedEntry("slab", class_7923.field_41175));
        this.addChild("stairs", this.findRelatedEntry("stairs", class_7923.field_41175));
        this.addChild("fence", this.findRelatedEntry("fence", class_7923.field_41175));
        this.addChild("fence_gate", this.findRelatedEntry("fence_gate", class_7923.field_41175));
        this.addChild("door", this.findRelatedEntry("door", class_7923.field_41175));
        this.addChild("trapdoor", this.findRelatedEntry("trapdoor", class_7923.field_41175));
        this.addChild("button", this.findRelatedEntry("button", class_7923.field_41175));
        this.addChild("pressure_plate", this.findRelatedEntry("pressure_plate", class_7923.field_41175));
        this.addChild("hanging_sign", this.findRelatedEntry("hanging_sign", class_7923.field_41175));
        this.addChild("wall_hanging_sign", this.findRelatedEntry("wall_hanging_sign", class_7923.field_41175));
        this.addChild("sign", this.findRelatedEntry("sign", class_7923.field_41175));
        this.addChild("stick", this.findRelatedEntry("twig", class_7923.field_41175));
        WoodTypeRegistry.INSTANCE.mapVanillaWood(this);
    }

    @Override
    public void initializeChildrenItems() {
        this.addChild("boat", this.findRelatedEntry("boat", class_7923.field_41178));
        this.addChild("chest_boat", this.findRelatedEntry("chest_boat", class_7923.field_41178));
        this.addChild("sapling", this.findRelatedEntry("sapling", class_7923.field_41178));
    }

    public class_4970.class_2251 copyProperties() {
        class_4970.class_2251 p = class_4970.class_2251.method_9637();
        p.method_31710(this.getColor());
        if (this.canBurn()) {
            p.method_50013();
        }
        p.method_9626(this.getSound());
        return p;
    }

    public static class Finder
    implements BlockType.SetFinder<WoodType> {
        private final Map<String, class_2960> childNames = new HashMap<String, class_2960>();
        private final Supplier<class_2248> planksFinder;
        private final Supplier<class_2248> logFinder;
        private final class_2960 id;

        public Finder(class_2960 id, Supplier<class_2248> planks, Supplier<class_2248> log) {
            this.id = id;
            this.planksFinder = planks;
            this.logFinder = log;
        }

        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(new class_2960(modId, woodTypeName), new class_2960(modId, planksName), new class_2960(modId, logName));
        }

        public static Finder simple(class_2960 woodTypeName, class_2960 planksName, class_2960 logName) {
            return new Finder(woodTypeName, () -> (class_2248)class_7923.field_41175.method_10223(planksName), () -> (class_2248)class_7923.field_41175.method_10223(logName));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, new class_2960(this.id.method_12836(), childName));
        }

        public void addChild(String childType, class_2960 childName) {
            this.childNames.put(childType, childName);
        }

        @Override
        @ApiStatus.Internal
        public Optional<WoodType> get() {
            if (PlatHelper.isModLoaded(this.id.method_12836())) {
                try {
                    class_2248 plank = this.planksFinder.get();
                    class_2248 log = this.logFinder.get();
                    class_2248 d = (class_2248)class_7923.field_41175.method_10223(class_7923.field_41175.method_10137());
                    if (plank != d && log != d && plank != null && log != null) {
                        WoodType w = new WoodType(this.id, plank, log);
                        this.childNames.forEach((key, value) -> w.addChild((String)key, class_7923.field_41175.method_10223(value)));
                        return Optional.of(w);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Moonlight.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

