/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.promenade.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import fr.hugman.promenade.entity.CapybaraEntity;
import fr.hugman.promenade.entity.ai.brain.sensor.PromenadeSensorTypes;
import fr.hugman.promenade.registry.content.AnimalContent;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4101;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4118;
import net.minecraft.class_4120;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4806;
import net.minecraft.class_4818;
import net.minecraft.class_5355;
import net.minecraft.class_5753;
import net.minecraft.class_5754;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6028;
import net.minecraft.class_7687;
import net.minecraft.class_7894;
import net.minecraft.class_7895;
import net.minecraft.class_7898;

public class CapybaraBrain {
    private static final class_6019 WALK_TOWARD_ADULT_RANGE = class_6019.method_35017((int)5, (int)16);
    private static final ImmutableList<class_4149<? extends class_4148<? super CapybaraEntity>>> SENSORS = ImmutableList.of((Object)class_4149.field_18466, (Object)class_4149.field_18469, PromenadeSensorTypes.CAPYBARA_TEMPTATIONS, (Object)class_4149.field_25362);
    private static final ImmutableList<class_4140<?>> MEMORY_MODULES = ImmutableList.of((Object)class_4140.field_39408, (Object)class_4140.field_18451, (Object)class_4140.field_18452, (Object)class_4140.field_18445, (Object)class_4140.field_18446, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_18442, (Object)class_4140.field_28325, (Object)class_4140.field_28326, (Object)class_4140.field_40127, (Object)class_4140.field_28327, (Object[])new class_4140[]{class_4140.field_18448, class_4140.field_25359});

    protected static void method_45367(CapybaraEntity capybara, class_5819 random) {
    }

    public static class_4095.class_5303<CapybaraEntity> createProfile() {
        return class_4095.method_28311(MEMORY_MODULES, SENSORS);
    }

    protected static class_4095<?> create(class_4095<CapybaraEntity> brain) {
        CapybaraBrain.addCoreActivities(brain);
        CapybaraBrain.addIdleActivities(brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void addCoreActivities(class_4095<CapybaraEntity> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)((Object)new WalkTask(1.0f)), (Object)new class_4110(45, 90), (Object)new class_4112(), (Object)new class_5753(class_4140.field_28326), (Object)new class_5753(class_4140.field_40127)));
    }

    private static void addIdleActivities(class_4095<CapybaraEntity> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)0, (Object)class_7895.method_47069((class_1299)class_1299.field_6097, (float)6.0f, (class_6019)class_6019.method_35017((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new class_4806(AnimalContent.CAPYBARA, 1.0f)), (Object)Pair.of((Object)2, (Object)new class_5754(entity -> Float.valueOf(1.5f))), (Object)Pair.of((Object)3, (Object)class_7898.method_47227(Predicate.not(CapybaraEntity::isStationary), (class_7894)class_5355.method_46896((class_6019)WALK_TOWARD_ADULT_RANGE, (float)1.5f))), (Object)Pair.of((Object)4, (Object)new class_7687((class_6017)class_6019.method_35017((int)150, (int)250), 30.0f, -50.0f, 10.0f)), (Object)Pair.of((Object)5, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)class_7898.method_47227(Predicate.not(CapybaraEntity::isStationary), (class_7894)class_4818.method_47014((float)1.0f)), (Object)1), (Object)Pair.of((Object)class_7898.method_47227(Predicate.not(CapybaraEntity::isStationary), (class_7894)class_4120.method_47104((float)1.0f, (int)3)), (Object)1), (Object)Pair.of((Object)((Object)new SleepTask(20)), (Object)1), (Object)Pair.of((Object)((Object)new FartTask(10)), (Object)1), (Object)Pair.of((Object)new class_4101(30, 60), (Object)1))))));
    }

    public static void updateActivities(CapybaraEntity capybara) {
        capybara.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_18595));
    }

    public static class WalkTask
    extends class_6028 {
        public WalkTask(float speed) {
            super(speed);
        }

        protected void method_35064(class_3218 world, class_1314 entity, long l) {
            if (entity instanceof CapybaraEntity) {
                CapybaraEntity capybara = (CapybaraEntity)entity;
                capybara.standUp();
            }
            super.method_35064(world, entity, l);
        }
    }

    public static class SleepTask
    extends class_4097<CapybaraEntity> {
        private final int lastPoseTickDelta;

        public SleepTask(int lastPoseSecondsDelta) {
            super((Map)ImmutableMap.of());
            this.lastPoseTickDelta = lastPoseSecondsDelta * 20;
        }

        protected boolean shouldRun(class_3218 world, CapybaraEntity capybara) {
            return !capybara.method_5799() && capybara.getLastStateTickDelta() >= (long)this.lastPoseTickDelta && !capybara.method_5934() && capybara.method_24828() && !capybara.method_42148();
        }

        protected void run(class_3218 world, CapybaraEntity capybara, long l) {
            if (capybara.canStopSleeping()) {
                capybara.stopSleeping();
            } else if (capybara.canFallToSleep()) {
                capybara.fallToSleep();
            }
        }
    }

    public static class FartTask
    extends class_4097<CapybaraEntity> {
        private final int lastPoseTickDelta;

        public FartTask(int lastPoseSecondsDelta) {
            super((Map)ImmutableMap.of());
            this.lastPoseTickDelta = lastPoseSecondsDelta * 20;
        }

        protected boolean shouldRun(class_3218 world, CapybaraEntity capybara) {
            return capybara.canFart() && !capybara.method_5799() && capybara.getLastStateTickDelta() >= (long)this.lastPoseTickDelta && !capybara.method_5934() && capybara.method_24828() && !capybara.method_42148();
        }

        protected void run(class_3218 world, CapybaraEntity capybara, long l) {
            capybara.fart();
        }
    }
}

