/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.api;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import shetiphian.endertanks.api.IEnderTankInfo;
import shetiphian.endertanks.api.ITankHandler;

public class HandlerRegistry {
    private static final HashMap<String, ITankHandlerProvider<?>> PROVIDERS = new HashMap();
    private static String DEFAULT_KEY;

    public static <T extends TransferVariant<?>> boolean register(Class<T> type, ITankHandlerProvider<T> provider) {
        String name = HandlerRegistry.getKey(type);
        if (Strings.isNullOrEmpty((String)DEFAULT_KEY)) {
            DEFAULT_KEY = name;
        }
        if (!PROVIDERS.containsKey(name)) {
            PROVIDERS.put(name, provider);
            return true;
        }
        return false;
    }

    public static Map<String, ITankHandlerProvider<?>> getProviders() {
        return Collections.unmodifiableMap(PROVIDERS);
    }

    public static String getDefaultKey() {
        return DEFAULT_KEY;
    }

    public static ITankHandler<?> createHandlerFor(Class<? extends TransferVariant<?>> type, IEnderTankInfo tank) {
        return HandlerRegistry.createHandlerFor(HandlerRegistry.getKey(type), tank);
    }

    public static ITankHandler<?> createHandlerFor(String name, IEnderTankInfo tank) {
        ITankHandlerProvider<?> provider = PROVIDERS.get(name);
        return provider != null ? provider.create(tank) : null;
    }

    public static String getKey(Class<? extends TransferVariant<?>> type) {
        return type.getName().intern();
    }

    public static interface ITankHandlerProvider<Type extends TransferVariant<?>> {
        public ITankHandler<Type> create(IEnderTankInfo var1);
    }
}

