/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.status.playerstate;

import de.maxhenkel.status.StatusClient;
import de.maxhenkel.status.events.ClientWorldEvents;
import de.maxhenkel.status.net.NetManager;
import de.maxhenkel.status.net.PlayerStatePacket;
import de.maxhenkel.status.net.PlayerStatesPacket;
import de.maxhenkel.status.playerstate.Availability;
import de.maxhenkel.status.playerstate.PlayerState;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ClientPlayerStateManager {
    private PlayerState state = this.getDefaultState();
    private boolean stateChanged;
    private Map<UUID, PlayerState> states = new HashMap<UUID, PlayerState>();
    private static final class_2960 DND = new class_2960("status", "textures/icons/dnd.png");
    private static final class_2960 OPEN = new class_2960("status", "textures/icons/open.png");
    private static final class_2960 NO_AVAILABILITY = new class_2960("status", "textures/icons/no_availability.png");
    private static final class_2960 RECORDING = new class_2960("status", "textures/icons/recording.png");
    private static final class_2960 STREAMING = new class_2960("status", "textures/icons/streaming.png");
    private static final class_2960 NEUTRAL = new class_2960("status", "textures/icons/neutral.png");

    public ClientPlayerStateManager() {
        NetManager.registerClientReceiver(PlayerStatePacket.class, (client, handler, responseSender, packet) -> this.states.put(packet.getPlayerState().getPlayer(), packet.getPlayerState()));
        NetManager.registerClientReceiver(PlayerStatesPacket.class, (client, handler, responseSender, packet) -> {
            this.states = packet.getPlayerStates();
        });
        ClientWorldEvents.DISCONNECT.register(this::onDisconnect);
        ClientWorldEvents.JOIN_SERVER.register(this::onConnect);
    }

    public String getState() {
        return this.state.getState();
    }

    public void setState(String s) {
        this.state.setState(s);
        this.syncOwnState();
        StatusClient.CLIENT_CONFIG.status.set(s);
        StatusClient.CLIENT_CONFIG.status.save();
        this.stateChanged = true;
    }

    public void setAvailability(Availability availability) {
        this.state.setAvailability(availability);
        this.syncOwnState();
        StatusClient.CLIENT_CONFIG.availability.set(availability);
        StatusClient.CLIENT_CONFIG.availability.save();
        this.stateChanged = true;
    }

    public Availability getAvailability() {
        return this.state.getAvailability();
    }

    public boolean getNoSleep() {
        return this.state.isNoSleep();
    }

    public void setNoSleep(boolean noSleep) {
        this.state.setNoSleep(noSleep);
        this.syncOwnState();
        StatusClient.CLIENT_CONFIG.noSleep.set(noSleep);
        StatusClient.CLIENT_CONFIG.noSleep.save();
        this.stateChanged = true;
    }

    private PlayerState getDefaultState() {
        if (StatusClient.CLIENT_CONFIG.persistState.get().booleanValue()) {
            return new PlayerState(class_310.method_1551().method_1548().method_1677().getId(), StatusClient.CLIENT_CONFIG.availability.get(), StatusClient.CLIENT_CONFIG.status.get(), StatusClient.CLIENT_CONFIG.noSleep.get());
        }
        return new PlayerState(class_310.method_1551().method_1548().method_1677().getId());
    }

    private void onDisconnect() {
        this.clearStates();
    }

    private void onConnect() {
        this.syncOwnState();
        if (StatusClient.CLIENT_CONFIG.showJoinMessage.get().booleanValue() && !this.stateChanged) {
            this.showChangeStatusMessage();
        }
    }

    private void showChangeStatusMessage() {
        class_310.method_1551().field_1724.method_43496((class_2561)class_2564.method_10885((class_2561)class_2561.method_43471((String)"message.status.mod_name")).method_27692(class_124.field_1060).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"message.status.change_status").method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"message.status.set_status")))).method_27692(class_124.field_1068)));
    }

    public void syncOwnState() {
        NetManager.sendToServer(new PlayerStatePacket(this.state));
    }

    @Nullable
    public PlayerState getState(UUID player) {
        if (player.equals(class_310.method_1551().field_1724.method_7334().getId())) {
            return this.state;
        }
        return this.states.get(player);
    }

    @Nullable
    public class_2960 getIcon(UUID player) {
        PlayerState state = this.getState(player);
        if (state == null) {
            return null;
        }
        if (state.getState().equals("recording")) {
            return RECORDING;
        }
        if (state.getState().equals("streaming")) {
            return STREAMING;
        }
        return NEUTRAL;
    }

    @Nullable
    public class_2960 getOverlay(UUID player) {
        PlayerState state = this.getState(player);
        if (state == null) {
            return null;
        }
        if (state.getAvailability().equals((Object)Availability.DO_NOT_DISTURB)) {
            return DND;
        }
        if (state.getAvailability().equals((Object)Availability.OPEN)) {
            return OPEN;
        }
        return NO_AVAILABILITY;
    }

    public void clearStates() {
        this.states.clear();
    }
}

